/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FontInputStream
extends FilterInputStream {
    private long position;
    private long length;
    private boolean bounded;

    public FontInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public FontInputStream(InputStream inputStream, int n) {
        this(inputStream);
        this.length = n;
        this.bounded = true;
    }

    @Override
    public int read() throws IOException {
        if (this.bounded && this.position >= this.length) {
            return -1;
        }
        int n = super.read();
        if (n >= 0) {
            ++this.position;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bounded && this.position >= this.length) {
            return -1;
        }
        int n3 = this.bounded ? (int)Math.min((long)n2, this.length - this.position) : n2;
        int n4 = super.read(byArray, n, n3);
        this.position += (long)n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long position() {
        return this.position;
    }

    public int readChar() throws IOException {
        return this.read();
    }

    public int readUShort() throws IOException {
        return 0xFFFF & (this.read() << 8 | this.read());
    }

    public int readShort() throws IOException {
        return (this.read() << 8 | this.read()) << 16 >> 16;
    }

    public int readUInt24() throws IOException {
        return 0xFFFFFF & (this.read() << 16 | this.read() << 8 | this.read());
    }

    public long readULong() throws IOException {
        return 0xFFFFFFFFL & (long)this.readLong();
    }

    public int readULongAsInt() throws IOException {
        long l = this.readULong();
        if ((l & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new ArithmeticException("Long value too large to fit into an integer.");
        }
        return (int)l & Integer.MAX_VALUE;
    }

    public int readLong() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public int readFixed() throws IOException {
        return this.readLong();
    }

    public long readDateTimeAsLong() throws IOException {
        return this.readULong() << 32 | this.readULong();
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.position += l2;
        return l2;
    }
}

