/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat1;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat2;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat3;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat4;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat5;
import java.util.Iterator;

public abstract class IndexSubTable
extends SubTable {
    private static final boolean DEBUG = false;
    private final int firstGlyphIndex;
    private final int lastGlyphIndex;
    private final int indexFormat;
    private final int imageFormat;
    private final int imageDataOffset;

    protected static IndexSubTable createIndexSubTable(ReadableFontData readableFontData, int n, int n2) {
        Builder<IndexSubTable> builder = Builder.createBuilder(readableFontData, n, n2);
        if (builder == null) {
            return null;
        }
        return (IndexSubTable)builder.build();
    }

    protected IndexSubTable(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData);
        this.firstGlyphIndex = n;
        this.lastGlyphIndex = n2;
        this.indexFormat = this.data.readUShort(EblcTable.Offset.indexSubHeader_indexFormat.offset);
        this.imageFormat = this.data.readUShort(EblcTable.Offset.indexSubHeader_imageFormat.offset);
        this.imageDataOffset = this.data.readULongAsInt(EblcTable.Offset.indexSubHeader_imageDataOffset.offset);
    }

    public int indexFormat() {
        return this.indexFormat;
    }

    public int firstGlyphIndex() {
        return this.firstGlyphIndex;
    }

    public int lastGlyphIndex() {
        return this.lastGlyphIndex;
    }

    public int imageFormat() {
        return this.imageFormat;
    }

    public int imageDataOffset() {
        return this.imageDataOffset;
    }

    public BitmapGlyphInfo glyphInfo(int n) {
        int n2 = this.checkGlyphRange(n);
        if (n2 == -1) {
            return null;
        }
        if (this.glyphStartOffset(n) == -1) {
            return null;
        }
        return new BitmapGlyphInfo(n, this.imageDataOffset(), this.glyphStartOffset(n), this.glyphLength(n), this.imageFormat());
    }

    public final int glyphOffset(int n) {
        int n2 = this.glyphStartOffset(n);
        if (n2 == -1) {
            return -1;
        }
        return this.imageDataOffset() + n2;
    }

    public abstract int glyphStartOffset(int var1);

    public abstract int glyphLength(int var1);

    public abstract int numGlyphs();

    protected static int checkGlyphRange(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException("Glyph ID is outside of the allowed range.");
        }
        return n - n2;
    }

    protected int checkGlyphRange(int n) {
        return IndexSubTable.checkGlyphRange(n, this.firstGlyphIndex(), this.lastGlyphIndex());
    }

    @Override
    public String toString() {
        String string = "IndexSubTable: [0x" + Integer.toHexString(this.firstGlyphIndex()) + " : Ox" + Integer.toHexString(this.lastGlyphIndex()) + "]" + ", format = " + this.indexFormat + ", image format = " + this.imageFormat() + ", imageOff = " + Integer.toHexString(this.imageDataOffset()) + "\n";
        return string;
    }

    public static abstract class Builder<T extends IndexSubTable>
    extends SubTable.Builder<T> {
        private int firstGlyphIndex;
        private int lastGlyphIndex;
        private int indexFormat;
        private int imageFormat;
        private int imageDataOffset;

        public static Builder<? extends IndexSubTable> createBuilder(int n) {
            switch (n) {
                case 1: {
                    return IndexSubTableFormat1.Builder.createBuilder();
                }
                case 2: {
                    return IndexSubTableFormat2.Builder.createBuilder();
                }
                case 3: {
                    return IndexSubTableFormat3.Builder.createBuilder();
                }
                case 4: {
                    return IndexSubTableFormat4.Builder.createBuilder();
                }
                case 5: {
                    return IndexSubTableFormat5.Builder.createBuilder();
                }
            }
            throw new IllegalArgumentException(String.format("Invalid Index SubTable Format %i%n", n));
        }

        static Builder<? extends IndexSubTable> createBuilder(ReadableFontData readableFontData, int n, int n2) {
            int n3 = n + n2 * EblcTable.Offset.indexSubTableEntryLength.offset;
            int n4 = readableFontData.readUShort(n3 + EblcTable.Offset.indexSubTableEntry_firstGlyphIndex.offset);
            int n5 = readableFontData.readUShort(n3 + EblcTable.Offset.indexSubTableEntry_lastGlyphIndex.offset);
            int n6 = readableFontData.readULongAsInt(n3 + EblcTable.Offset.indexSubTableEntry_additionalOffsetToIndexSubtable.offset);
            int n7 = n + n6;
            int n8 = readableFontData.readUShort(n7);
            switch (n8) {
                case 1: {
                    return IndexSubTableFormat1.Builder.createBuilder(readableFontData, n7, n4, n5);
                }
                case 2: {
                    return IndexSubTableFormat2.Builder.createBuilder(readableFontData, n7, n4, n5);
                }
                case 3: {
                    return IndexSubTableFormat3.Builder.createBuilder(readableFontData, n7, n4, n5);
                }
                case 4: {
                    return IndexSubTableFormat4.Builder.createBuilder(readableFontData, n7, n4, n5);
                }
                case 5: {
                    return IndexSubTableFormat5.Builder.createBuilder(readableFontData, n7, n4, n5);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid Index SubTable Foramt %i%n", n8));
        }

        protected Builder(int n, int n2) {
            super(n);
            this.indexFormat = n2;
        }

        protected Builder(int n, int n2, int n3, int n4) {
            this(n4, n);
            this.imageFormat = n2;
            this.imageDataOffset = n3;
        }

        protected Builder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData);
            this.firstGlyphIndex = n;
            this.lastGlyphIndex = n2;
            this.initialize(writableFontData);
        }

        protected Builder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData);
            this.firstGlyphIndex = n;
            this.lastGlyphIndex = n2;
            this.initialize(readableFontData);
        }

        private void initialize(ReadableFontData readableFontData) {
            this.indexFormat = readableFontData.readUShort(EblcTable.Offset.indexSubHeader_indexFormat.offset);
            this.imageFormat = readableFontData.readUShort(EblcTable.Offset.indexSubHeader_imageFormat.offset);
            this.imageDataOffset = readableFontData.readULongAsInt(EblcTable.Offset.indexSubHeader_imageDataOffset.offset);
        }

        protected void revert() {
            this.setModelChanged(false);
            this.initialize(this.internalReadData());
        }

        public int indexFormat() {
            return this.indexFormat;
        }

        public int firstGlyphIndex() {
            return this.firstGlyphIndex;
        }

        public void setFirstGlyphIndex(int n) {
            this.firstGlyphIndex = n;
        }

        public int lastGlyphIndex() {
            return this.lastGlyphIndex;
        }

        public void setLastGlyphIndex(int n) {
            this.lastGlyphIndex = n;
        }

        public int imageFormat() {
            return this.imageFormat;
        }

        public void setImageFormat(int n) {
            this.imageFormat = n;
        }

        public int imageDataOffset() {
            return this.imageDataOffset;
        }

        public void setImageDataOffset(int n) {
            this.imageDataOffset = n;
        }

        public abstract int numGlyphs();

        public BitmapGlyphInfo glyphInfo(int n) {
            return new BitmapGlyphInfo(n, this.imageDataOffset(), this.glyphStartOffset(n), this.glyphLength(n), this.imageFormat());
        }

        public final int glyphOffset(int n) {
            return this.imageDataOffset() + this.glyphStartOffset(n);
        }

        public abstract int glyphStartOffset(int var1);

        public abstract int glyphLength(int var1);

        protected int checkGlyphRange(int n) {
            return IndexSubTable.checkGlyphRange(n, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        protected int serializeIndexSubHeader(WritableFontData writableFontData) {
            int n = writableFontData.writeUShort(EblcTable.Offset.indexSubHeader_indexFormat.offset, this.indexFormat);
            n += writableFontData.writeUShort(EblcTable.Offset.indexSubHeader_imageFormat.offset, this.imageFormat);
            return n += writableFontData.writeULong(EblcTable.Offset.indexSubHeader_imageDataOffset.offset, this.imageDataOffset);
        }

        abstract Iterator<BitmapGlyphInfo> iterator();

        @Override
        protected T subBuildTable(ReadableFontData readableFontData) {
            return null;
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return 0;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return false;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            return 0;
        }

        public String toString() {
            String string = "IndexSubTable: [0x" + Integer.toHexString(this.firstGlyphIndex()) + " : Ox" + Integer.toHexString(this.lastGlyphIndex()) + "]" + ", format = " + this.indexFormat + ", image format = " + this.imageFormat() + ", imageOff = 0x" + Integer.toHexString(this.imageDataOffset()) + "\n";
            return string;
        }
    }

    public static final class Format {
        public static final int FORMAT_1 = 1;
        public static final int FORMAT_2 = 2;
        public static final int FORMAT_3 = 3;
        public static final int FORMAT_4 = 4;
        public static final int FORMAT_5 = 5;
    }
}

