/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IndexSubTableFormat4
extends IndexSubTable {
    public static final Comparator<CodeOffsetPair> CodeOffsetPairComparatorByGlyphCode = new CodeOffsetPairGlyphCodeComparator();

    private IndexSubTableFormat4(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2);
    }

    private static int numGlyphs(ReadableFontData readableFontData, int n) {
        int n2 = readableFontData.readULongAsInt(n + EblcTable.Offset.indexSubTable4_numGlyphs.offset);
        return n2;
    }

    @Override
    public int numGlyphs() {
        return IndexSubTableFormat4.numGlyphs(this.data, 0);
    }

    @Override
    public int glyphStartOffset(int n) {
        this.checkGlyphRange(n);
        int n2 = this.findCodeOffsetPair(n);
        if (n2 < 0) {
            return -1;
        }
        return this.data.readUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset + n2 * EblcTable.Offset.codeOffsetPairLength.offset + EblcTable.Offset.codeOffsetPair_offset.offset);
    }

    @Override
    public int glyphLength(int n) {
        this.checkGlyphRange(n);
        int n2 = this.findCodeOffsetPair(n);
        if (n2 < 0) {
            return -1;
        }
        return this.data.readUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset + (n2 + 1) * EblcTable.Offset.codeOffsetPairLength.offset + EblcTable.Offset.codeOffsetPair_offset.offset) - this.data.readUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset + n2 * EblcTable.Offset.codeOffsetPairLength.offset + EblcTable.Offset.codeOffsetPair_offset.offset);
    }

    protected int findCodeOffsetPair(int n) {
        return this.data.searchUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset, EblcTable.Offset.codeOffsetPairLength.offset, this.numGlyphs(), n);
    }

    public static final class Builder
    extends IndexSubTable.Builder<IndexSubTableFormat4> {
        private List<CodeOffsetPairBuilder> offsetPairArray;

        public static Builder createBuilder() {
            return new Builder();
        }

        static Builder createBuilder(ReadableFontData readableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(readableFontData, n, n2, n3);
            return new Builder(readableFontData.slice(n, n4), n2, n3);
        }

        static Builder createBuilder(WritableFontData writableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(writableFontData, n, n2, n3);
            return new Builder(writableFontData.slice(n, n4), n2, n3);
        }

        private static int dataLength(ReadableFontData readableFontData, int n, int n2, int n3) {
            int n4 = IndexSubTableFormat4.numGlyphs(readableFontData, n);
            return EblcTable.Offset.indexSubTable4_glyphArray.offset + n4 * EblcTable.Offset.indexSubTable4_codeOffsetPairLength.offset;
        }

        private Builder() {
            super(EblcTable.Offset.indexSubTable4_builderDataSize.offset, 4);
        }

        private Builder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData, n, n2);
        }

        private Builder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData, n, n2);
        }

        @Override
        public int numGlyphs() {
            return this.getOffsetArray().size() - 1;
        }

        @Override
        public int glyphLength(int n) {
            this.checkGlyphRange(n);
            int n2 = this.findCodeOffsetPair(n);
            if (n2 == -1) {
                return -1;
            }
            return this.getOffsetArray().get(n2 + 1).offset() - this.getOffsetArray().get(n2).offset();
        }

        @Override
        public int glyphStartOffset(int n) {
            this.checkGlyphRange(n);
            int n2 = this.findCodeOffsetPair(n);
            if (n2 == -1) {
                return -1;
            }
            return this.getOffsetArray().get(n2).offset();
        }

        public List<CodeOffsetPairBuilder> offsetArray() {
            return this.getOffsetArray();
        }

        private List<CodeOffsetPairBuilder> getOffsetArray() {
            if (this.offsetPairArray == null) {
                this.initialize(super.internalReadData());
                super.setModelChanged();
            }
            return this.offsetPairArray;
        }

        private void initialize(ReadableFontData readableFontData) {
            if (this.offsetPairArray == null) {
                this.offsetPairArray = new ArrayList<CodeOffsetPairBuilder>();
            } else {
                this.offsetPairArray.clear();
            }
            if (readableFontData != null) {
                int n = IndexSubTableFormat4.numGlyphs(readableFontData, 0) + 1;
                int n2 = EblcTable.Offset.indexSubTable4_glyphArray.offset;
                for (int i = 0; i < n; ++i) {
                    int n3 = readableFontData.readUShort(n2 + EblcTable.Offset.indexSubTable4_codeOffsetPair_glyphCode.offset);
                    int n4 = readableFontData.readUShort(n2 + EblcTable.Offset.indexSubTable4_codeOffsetPair_offset.offset);
                    n2 += EblcTable.Offset.indexSubTable4_codeOffsetPairLength.offset;
                    CodeOffsetPairBuilder codeOffsetPairBuilder = new CodeOffsetPairBuilder(n3, n4);
                    this.offsetPairArray.add(codeOffsetPairBuilder);
                }
            }
        }

        private int findCodeOffsetPair(int n) {
            List<CodeOffsetPairBuilder> list = this.getOffsetArray();
            int n2 = 0;
            int n3 = 0;
            int n4 = list.size();
            while (n4 != n3) {
                n2 = (n4 + n3) / 2;
                CodeOffsetPairBuilder codeOffsetPairBuilder = list.get(n2);
                if (n < codeOffsetPairBuilder.glyphCode()) {
                    n4 = n2;
                    continue;
                }
                if (n > codeOffsetPairBuilder.glyphCode()) {
                    n3 = n2 + 1;
                    continue;
                }
                return n2;
            }
            return -1;
        }

        public void setOffsetArray(List<CodeOffsetPairBuilder> list) {
            this.offsetPairArray = list;
            this.setModelChanged();
        }

        @Override
        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        @Override
        protected void revert() {
            super.revert();
            this.offsetPairArray = null;
        }

        @Override
        protected IndexSubTableFormat4 subBuildTable(ReadableFontData readableFontData) {
            return new IndexSubTableFormat4(readableFontData, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.offsetPairArray == null) {
                return this.internalReadData().length();
            }
            return EblcTable.Offset.indexSubHeaderLength.offset + FontData.DataSize.ULONG.size() + this.offsetPairArray.size() * EblcTable.Offset.indexSubTable4_codeOffsetPairLength.offset;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.offsetPairArray != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = super.serializeIndexSubHeader(writableFontData);
            if (!this.modelChanged()) {
                n += this.internalReadData().slice(EblcTable.Offset.indexSubTable4_numGlyphs.offset).copyTo(writableFontData.slice(EblcTable.Offset.indexSubTable4_numGlyphs.offset));
            } else {
                n += writableFontData.writeLong(n, this.offsetPairArray.size() - 1);
                for (CodeOffsetPairBuilder codeOffsetPairBuilder : this.offsetPairArray) {
                    n += writableFontData.writeUShort(n, codeOffsetPairBuilder.glyphCode());
                    n += writableFontData.writeUShort(n, codeOffsetPairBuilder.offset());
                }
            }
            return n;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            private int codeOffsetPairIndex;

            @Override
            public boolean hasNext() {
                return this.codeOffsetPairIndex < Builder.this.getOffsetArray().size() - 1;
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                List list = Builder.this.getOffsetArray();
                CodeOffsetPair codeOffsetPair = (CodeOffsetPair)list.get(this.codeOffsetPairIndex);
                BitmapGlyphInfo bitmapGlyphInfo = new BitmapGlyphInfo(codeOffsetPair.glyphCode(), Builder.this.imageDataOffset(), codeOffsetPair.offset(), ((CodeOffsetPairBuilder)list.get(this.codeOffsetPairIndex + 1)).offset() - codeOffsetPair.offset(), Builder.this.imageFormat());
                ++this.codeOffsetPairIndex;
                return bitmapGlyphInfo;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }

    private static final class CodeOffsetPairGlyphCodeComparator
    implements Comparator<CodeOffsetPair> {
        private CodeOffsetPairGlyphCodeComparator() {
        }

        @Override
        public int compare(CodeOffsetPair codeOffsetPair, CodeOffsetPair codeOffsetPair2) {
            return codeOffsetPair.glyphCode - codeOffsetPair2.glyphCode;
        }
    }

    public static final class CodeOffsetPairBuilder
    extends CodeOffsetPair {
        private CodeOffsetPairBuilder(int n, int n2) {
            super(n, n2);
        }

        public void setGlyphCode(int n) {
            this.glyphCode = n;
        }

        public void setOffset(int n) {
            this.offset = n;
        }
    }

    public static class CodeOffsetPair {
        protected int glyphCode;
        protected int offset;

        private CodeOffsetPair(int n, int n2) {
            this.glyphCode = n;
            this.offset = n2;
        }

        public int glyphCode() {
            return this.glyphCode;
        }

        public int offset() {
            return this.offset;
        }
    }
}

