/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.core.CMapFormat0;
import com.google.typography.font.sfntly.table.core.CMapFormat10;
import com.google.typography.font.sfntly.table.core.CMapFormat12;
import com.google.typography.font.sfntly.table.core.CMapFormat13;
import com.google.typography.font.sfntly.table.core.CMapFormat14;
import com.google.typography.font.sfntly.table.core.CMapFormat2;
import com.google.typography.font.sfntly.table.core.CMapFormat4;
import com.google.typography.font.sfntly.table.core.CMapFormat6;
import com.google.typography.font.sfntly.table.core.CMapFormat8;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CMap
extends SubTable
implements Iterable<Integer> {
    protected final int format;
    protected final CMapTable.CMapId cmapId;

    protected CMap(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
        super(readableFontData);
        this.format = n;
        this.cmapId = cMapId;
    }

    public int format() {
        return this.format;
    }

    public CMapTable.CMapId cmapId() {
        return this.cmapId;
    }

    public int platformId() {
        return this.cmapId().platformId();
    }

    public int encodingId() {
        return this.cmapId().encodingId();
    }

    public int hashCode() {
        return this.cmapId.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CMap)) {
            return false;
        }
        return this.cmapId.equals(((CMap)object).cmapId);
    }

    public abstract int language();

    public abstract int glyphId(int var1);

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cmap: ");
        stringBuilder.append(this.cmapId());
        stringBuilder.append(", ");
        stringBuilder.append((Object)CMapFormat.valueOf(this.format()));
        stringBuilder.append(", Data Size=0x");
        stringBuilder.append(Integer.toHexString(this.data.length()));
        return stringBuilder.toString();
    }

    public static abstract class Builder<T extends CMap>
    extends SubTable.Builder<T> {
        private final CMapFormat format;
        private final CMapTable.CMapId cmapId;
        private int language;

        protected Builder(ReadableFontData readableFontData, CMapFormat cMapFormat, CMapTable.CMapId cMapId) {
            super(readableFontData);
            this.format = cMapFormat;
            this.cmapId = cMapId;
        }

        public CMapTable.CMapId cmapId() {
            return this.cmapId;
        }

        public int encodingId() {
            return this.cmapId().encodingId();
        }

        public int platformId() {
            return this.cmapId().platformId();
        }

        public CMapFormat format() {
            return this.format;
        }

        public int language() {
            return this.language;
        }

        public void setLanguage(int n) {
            this.language = n;
        }

        protected Builder(WritableFontData writableFontData, CMapFormat cMapFormat, CMapTable.CMapId cMapId) {
            super(writableFontData);
            this.format = cMapFormat;
            this.cmapId = cMapId;
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return this.internalReadData().length();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            return this.internalReadData().copyTo(writableFontData);
        }

        static Builder<? extends CMap> getBuilder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            int n2 = readableFontData.readUShort(n);
            CMapFormat cMapFormat = CMapFormat.valueOf(n2);
            switch (cMapFormat) {
                case Format0: {
                    return new CMapFormat0.Builder(readableFontData, n, cMapId);
                }
                case Format2: {
                    return new CMapFormat2.Builder(readableFontData, n, cMapId);
                }
                case Format4: {
                    return new CMapFormat4.Builder(readableFontData, n, cMapId);
                }
                case Format6: {
                    return new CMapFormat6.Builder(readableFontData, n, cMapId);
                }
                case Format8: {
                    return new CMapFormat8.Builder(readableFontData, n, cMapId);
                }
                case Format10: {
                    return new CMapFormat10.Builder(readableFontData, n, cMapId);
                }
                case Format12: {
                    return new CMapFormat12.Builder(readableFontData, n, cMapId);
                }
                case Format13: {
                    return new CMapFormat13.Builder(readableFontData, n, cMapId);
                }
                case Format14: {
                    return new CMapFormat14.Builder(readableFontData, n, cMapId);
                }
            }
            return null;
        }

        static Builder<? extends CMap> getBuilder(CMapFormat cMapFormat, CMapTable.CMapId cMapId) {
            switch (cMapFormat) {
                case Format0: {
                    return new CMapFormat0.Builder(null, 0, cMapId);
                }
                case Format4: {
                    return new CMapFormat4.Builder(null, 0, cMapId);
                }
            }
            return null;
        }

        public String toString() {
            return String.format("%s, format = %s", new Object[]{this.cmapId(), this.format()});
        }
    }

    protected class CharacterIterator
    implements Iterator<Integer> {
        private int character = 0;
        private final int maxCharacter;

        CharacterIterator(int n, int n2) {
            this.character = n;
            this.maxCharacter = n2;
        }

        @Override
        public boolean hasNext() {
            return this.character < this.maxCharacter;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }

    public static enum CMapFormat {
        Format0(0),
        Format2(2),
        Format4(4),
        Format6(6),
        Format8(8),
        Format10(10),
        Format12(12),
        Format13(13),
        Format14(14);

        final int value;

        private CMapFormat(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static CMapFormat valueOf(int n) {
            for (CMapFormat cMapFormat : CMapFormat.values()) {
                if (!cMapFormat.equals(n)) continue;
                return cMapFormat;
            }
            return null;
        }
    }
}

