/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;

public final class CMapFormat2
extends CMap {
    protected CMapFormat2(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format2.value, cMapId);
    }

    private int subHeaderOffset(int n) {
        int n2 = this.data.readUShort(CMapTable.Offset.format2SubHeaderKeys.offset + n * FontData.DataSize.USHORT.size());
        return n2;
    }

    private int firstCode(int n) {
        int n2 = this.subHeaderOffset(n);
        int n3 = this.data.readUShort(n2 + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_firstCode.offset);
        return n3;
    }

    private int entryCount(int n) {
        int n2 = this.subHeaderOffset(n);
        int n3 = this.data.readUShort(n2 + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_entryCount.offset);
        return n3;
    }

    private int idRangeOffset(int n) {
        int n2 = this.subHeaderOffset(n);
        int n3 = this.data.readUShort(n2 + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_idRangeOffset.offset);
        return n3;
    }

    private int idDelta(int n) {
        int n2 = this.subHeaderOffset(n);
        int n3 = this.data.readShort(n2 + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_idDelta.offset);
        return n3;
    }

    public int bytesConsumed(int n) {
        int n2 = n >> 8 & 0xFF;
        int n3 = this.subHeaderOffset(n2);
        if (n3 == 0) {
            return 1;
        }
        return 2;
    }

    @Override
    public int glyphId(int n) {
        if (n > 65535) {
            return 0;
        }
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = this.subHeaderOffset(n2);
        if (n4 == 0) {
            n3 = n2;
            n2 = 0;
        }
        int n5 = this.firstCode(n2);
        int n6 = this.entryCount(n2);
        if (n3 < n5 || n3 >= n5 + n6) {
            return 0;
        }
        int n7 = this.idRangeOffset(n2);
        int n8 = n4 + CMapTable.Offset.format2SubHeader_idRangeOffset.offset + n7 + (n3 - n5) * FontData.DataSize.USHORT.size();
        int n9 = this.data.readUShort(n8);
        if (n9 == 0) {
            return 0;
        }
        if (n4 == 0) {
            return n9;
        }
        int n10 = this.idDelta(n2);
        return (n9 + n10) % 65536;
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format2Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CMap.CharacterIterator(0, 65535);
    }

    public static class Builder
    extends CMap.Builder<CMapFormat2> {
        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readUShort(n + CMapTable.Offset.format2Length.offset)), CMap.CMapFormat.Format2, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readUShort(n + CMapTable.Offset.format2Length.offset)), CMap.CMapFormat.Format2, cMapId);
        }

        @Override
        protected CMapFormat2 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat2(readableFontData, this.cmapId());
        }
    }
}

