/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class GlyfEncoder {
    private final boolean doPush;
    private final ByteArrayOutputStream glyfStream;
    private final ByteArrayOutputStream pushStream;
    private final ByteArrayOutputStream codeStream;

    public GlyfEncoder(boolean bl) {
        this.doPush = bl;
        this.glyfStream = new ByteArrayOutputStream();
        this.pushStream = new ByteArrayOutputStream();
        this.codeStream = new ByteArrayOutputStream();
    }

    public GlyfEncoder() {
        this(true);
    }

    public void encode(Font font) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        int n = locaTable.numGlyphs();
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        for (int i = 0; i < n; ++i) {
            int n2 = locaTable.glyphOffset(i);
            int n3 = locaTable.glyphLength(i);
            Glyph glyph = glyphTable.glyph(n2, n3);
            this.writeGlyph(glyph);
        }
    }

    private void writeGlyph(Glyph glyph) {
        try {
            if (glyph == null || glyph.dataLength() == 0) {
                this.writeUShort(0);
            } else if (glyph instanceof SimpleGlyph) {
                this.writeSimpleGlyph((SimpleGlyph)glyph);
            } else if (glyph instanceof CompositeGlyph) {
                this.writeCompositeGlyph((CompositeGlyph)glyph);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected IOException writing glyph data", iOException);
        }
    }

    private void writeInstructions(Glyph glyph) throws IOException {
        if (this.doPush) {
            this.splitPush(glyph);
        } else {
            int n = 0;
            int n2 = glyph.instructionSize();
            GlyfEncoder.write255UShort(this.glyfStream, n);
            GlyfEncoder.write255UShort(this.glyfStream, n2);
            if (n2 > 0) {
                glyph.instructions().copyTo(this.codeStream);
            }
        }
    }

    private void writeSimpleGlyph(SimpleGlyph simpleGlyph) throws IOException {
        int n = simpleGlyph.numberOfContours();
        this.writeUShort(n);
        for (int i = 0; i < n; ++i) {
            GlyfEncoder.write255UShort(this.glyfStream, simpleGlyph.numberOfPoints(i) - (i == 0 ? 1 : 0));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = simpleGlyph.numberOfPoints(i);
            for (int j = 0; j < n4; ++j) {
                int n5 = simpleGlyph.xCoordinate(i, j);
                int n6 = simpleGlyph.yCoordinate(i, j);
                int n7 = n5 - n2;
                int n8 = n6 - n3;
                this.writeTriplet(byteArrayOutputStream, simpleGlyph.onCurve(i, j), n7, n8);
                n2 = n5;
                n3 = n6;
            }
        }
        byteArrayOutputStream.writeTo(this.glyfStream);
        if (n > 0) {
            this.writeInstructions(simpleGlyph);
        }
    }

    private void writeCompositeGlyph(CompositeGlyph compositeGlyph) throws IOException {
        boolean bl = false;
        this.writeUShort(-1);
        this.writeUShort(compositeGlyph.xMin());
        this.writeUShort(compositeGlyph.yMin());
        this.writeUShort(compositeGlyph.xMax());
        this.writeUShort(compositeGlyph.yMax());
        for (int i = 0; i < compositeGlyph.numGlyphs(); ++i) {
            int n = compositeGlyph.flags(i);
            this.writeUShort(n);
            bl = (n & 0x100) != 0;
            this.writeUShort(compositeGlyph.glyphIndex(i));
            if ((n & 1) == 0) {
                this.glyfStream.write(compositeGlyph.argument1(i));
                this.glyfStream.write(compositeGlyph.argument2(i));
            } else {
                this.writeUShort(compositeGlyph.argument1(i));
                this.writeUShort(compositeGlyph.argument2(i));
            }
            if (compositeGlyph.transformationSize(i) == 0) continue;
            try {
                this.glyfStream.write(compositeGlyph.transformation(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            this.writeInstructions(compositeGlyph);
        }
    }

    private void writeUShort(int n) {
        this.glyfStream.write(n >> 8);
        this.glyfStream.write(n & 0xFF);
    }

    static void write255UShort(OutputStream outputStream, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 253) {
            outputStream.write((byte)n);
        } else if (n < 506) {
            outputStream.write(255);
            outputStream.write((byte)(n - 253));
        } else if (n < 762) {
            outputStream.write(254);
            outputStream.write((byte)(n - 506));
        } else {
            outputStream.write(253);
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)(n & 0xFF));
        }
    }

    static void write255Short(OutputStream outputStream, int n) throws IOException {
        int n2 = Math.abs(n);
        if (n < 0) {
            outputStream.write(250);
        }
        if (n2 < 250) {
            outputStream.write((byte)n2);
        } else if (n2 < 500) {
            outputStream.write(255);
            outputStream.write((byte)(n2 - 250));
        } else if (n2 < 756) {
            outputStream.write(254);
            outputStream.write((byte)(n2 - 500));
        } else {
            outputStream.write(253);
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)(n2 & 0xFF));
        }
    }

    void writeTriplet(OutputStream outputStream, boolean bl, int n, int n2) throws IOException {
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        int n5 = bl ? 0 : 128;
        int n6 = n < 0 ? 0 : 1;
        int n7 = n2 < 0 ? 0 : 1;
        int n8 = n6 + 2 * n7;
        if (n == 0 && n4 < 1280) {
            this.glyfStream.write(n5 + ((n4 & 0xF00) >> 7) + n7);
            outputStream.write(n4 & 0xFF);
        } else if (n2 == 0 && n3 < 1280) {
            this.glyfStream.write(n5 + 10 + ((n3 & 0xF00) >> 7) + n6);
            outputStream.write(n3 & 0xFF);
        } else if (n3 < 65 && n4 < 65) {
            this.glyfStream.write(n5 + 20 + (n3 - 1 & 0x30) + ((n4 - 1 & 0x30) >> 2) + n8);
            outputStream.write((n3 - 1 & 0xF) << 4 | n4 - 1 & 0xF);
        } else if (n3 < 769 && n4 < 769) {
            this.glyfStream.write(n5 + 84 + 12 * ((n3 - 1 & 0x300) >> 8) + ((n4 - 1 & 0x300) >> 6) + n8);
            outputStream.write(n3 - 1 & 0xFF);
            outputStream.write(n4 - 1 & 0xFF);
        } else if (n3 < 4096 && n4 < 4096) {
            this.glyfStream.write(n5 + 120 + n8);
            outputStream.write(n3 >> 4);
            outputStream.write((n3 & 0xF) << 4 | n4 >> 8);
            outputStream.write(n4 & 0xFF);
        } else {
            this.glyfStream.write(n5 + 124 + n8);
            outputStream.write(n3 >> 8);
            outputStream.write(n3 & 0xFF);
            outputStream.write(n4 >> 8);
            outputStream.write(n4 & 0xFF);
        }
    }

    private void splitPush(Glyph glyph) throws IOException {
        int n;
        int n2;
        int n3 = glyph.instructionSize();
        ReadableFontData readableFontData = glyph.instructions();
        int n4 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (n4 + 1 < n3) {
            n2 = n4;
            n = readableFontData.readUByte(n2++);
            int n5 = 0;
            int n6 = 0;
            if (n == 64 || n == 65) {
                n5 = readableFontData.readUByte(n2++);
                n6 = (n & 1) + 1;
            } else {
                if (n < 176 || n >= 192) break;
                n5 = 1 + (n & 7);
                n6 = ((n & 8) >> 3) + 1;
            }
            if (n4 + n6 * n5 > n3) break;
            for (int i = 0; i < n5; ++i) {
                if (n6 == 1) {
                    arrayList.add(readableFontData.readUByte(n2));
                } else {
                    arrayList.add(readableFontData.readShort(n2));
                }
                n2 += n6;
            }
            n4 = n2;
        }
        n2 = arrayList.size();
        n = n3 - n4;
        GlyfEncoder.write255UShort(this.glyfStream, n2);
        GlyfEncoder.write255UShort(this.glyfStream, n);
        this.encodePushSequence(this.pushStream, arrayList);
        if (n > 0) {
            readableFontData.slice(n4).copyTo(this.codeStream);
        }
    }

    private void encodePushSequence(OutputStream outputStream, List<Integer> list) throws IOException {
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(n2 & true)) {
                int n3 = list.get(i);
                if (n2 == 0 && i >= 2 && i + 2 < n && n3 == list.get(i - 2) && n3 == list.get(i + 2)) {
                    if (i + 4 < n && n3 == list.get(i + 4)) {
                        outputStream.write(252);
                        n2 = 20;
                    } else {
                        outputStream.write(251);
                        n2 = 4;
                    }
                } else {
                    GlyfEncoder.write255Short(outputStream, list.get(i));
                }
            }
            n2 >>= 1;
        }
    }

    public byte[] getGlyfBytes() {
        return this.glyfStream.toByteArray();
    }

    public byte[] getPushBytes() {
        return this.pushStream.toByteArray();
    }

    public byte[] getCodeBytes() {
        return this.codeStream.toByteArray();
    }
}

