/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.fontinfo;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import com.google.typography.font.tools.fontinfo.FontUtils;
import java.text.NumberFormat;

public class FontSummary {
    private final Font font;
    private final long length;

    FontSummary(Font font, long l) {
        this.font = font;
        this.length = l;
    }

    public String getCMapName() {
        String string = "unknown";
        CMapTable cMapTable = (CMapTable)this.font.getTable(Tag.cmap);
        if (cMapTable == null) {
            throw new RuntimeException("Missing cmap table");
        }
        CMap cMap = null;
        cMap = cMapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        if (cMap != null) {
            string = "USC-4";
        } else {
            cMap = cMapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value());
            if (cMap != null) {
                string = "USC-2";
            } else {
                throw new RuntimeException("Missing USC-4 and USC-2 cmap");
            }
        }
        return string;
    }

    public String getFontFamilyName() {
        return this.getNameTableEntry(NameTable.NameId.FontFamilyName);
    }

    public String getFontSubfamilyName() {
        return this.getNameTableEntry(NameTable.NameId.FontSubfamilyName);
    }

    public long getGlyphsLength() {
        LocaTable locaTable = (LocaTable)this.font.getTable(Tag.loca);
        int n = 0;
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            if (i == 0) continue;
            n += locaTable.glyphLength(i);
        }
        return n;
    }

    public long getInstructionsLength() {
        LocaTable locaTable = (LocaTable)this.font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)this.font.getTable(Tag.glyf);
        int n = 0;
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            Glyph glyph;
            if (i == 0) continue;
            int n2 = locaTable.glyphOffset(i);
            int n3 = locaTable.glyphLength(i);
            if (n3 == 0 || (glyph = glyphTable.glyph(n2, n3)).glyphType() != Glyph.GlyphType.Simple) continue;
            int n4 = ((SimpleGlyph)glyph).dataLength();
            int n5 = ((SimpleGlyph)glyph).instructionSize();
            n += n5;
        }
        return n;
    }

    public long getLength() {
        return this.length;
    }

    private String getNameTableEntry(NameTable.NameId nameId) {
        NameTable nameTable = (NameTable)this.font.getTable(Tag.name);
        String string = nameTable.name(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), nameId.value());
        return string;
    }

    public long getNumCodePoints() {
        CMap cMap = null;
        int n = 65535;
        int n2 = 0;
        CMapTable cMapTable = (CMapTable)this.font.getTable(Tag.cmap);
        if (cMapTable == null) {
            throw new RuntimeException("Missing cmap table");
        }
        cMap = cMapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        if (cMap != null) {
            n = 0x10FFFF;
        } else {
            cMap = cMapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value());
        }
        if (cMap != null) {
            for (int i = 0; i < n; ++i) {
                int n3 = cMap.glyphId(i);
                if (n3 == 0) continue;
                ++n2;
            }
        } else {
            throw new RuntimeException("Missing USC-4 and USC-2 cmap");
        }
        return n2;
    }

    public long getNumGlyphs() {
        LocaTable locaTable = (LocaTable)this.font.getTable(Tag.loca);
        return locaTable.numGlyphs();
    }

    public String getVersion() {
        double d = FontUtils.fixed1616ToDouble(this.font.sfntVersion());
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(d);
    }

    public String getVersionString() {
        return this.getNameTableEntry(NameTable.NameId.VersionString);
    }
}

