/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.fontinfo;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.tools.fontinfo.FontSummary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Logger;

public class ReportFontSummary {
    private static final Logger logger = Logger.getLogger(Font.class.getCanonicalName());

    public static void main(String[] stringArray) {
        int n;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            String string = null;
            if (stringArray[n].charAt(0) != '-') break;
            string = stringArray[n].substring(1);
            if (string == null) {
                ReportFontSummary.printUsage();
                System.exit(0);
            }
            if (string.equals("csv")) {
                bl = true;
                continue;
            }
            ReportFontSummary.printUsage();
            System.exit(0);
        }
        boolean bl2 = false;
        FontFactory fontFactory = FontFactory.getInstance();
        while (n < stringArray.length) {
            ReportFontSummary reportFontSummary = new ReportFontSummary();
            File file = null;
            try {
                Font[] fontArray;
                file = new File(stringArray[n]);
                FileInputStream fileInputStream = new FileInputStream(file);
                long l = file.length();
                for (Font font : fontArray = fontFactory.loadFonts(fileInputStream)) {
                    FontSummary fontSummary = new FontSummary(font, l);
                    if (bl) {
                        if (!bl2) {
                            bl2 = true;
                            System.out.println("Family Name,Style,Version,File Size,Cmap,# CodePoints,# Glyphs,#Glyph Bytes,# Instruction Bytes");
                        }
                        reportFontSummary.reportSummaryCsv(fontSummary);
                        continue;
                    }
                    reportFontSummary.reportSummary(fontSummary);
                }
            }
            catch (IOException iOException) {
                logger.severe(iOException.getLocalizedMessage());
                System.exit(0);
            }
            ++n;
        }
    }

    private static final void printUsage() {
        System.err.println("FontInfo [options] fontfile [...]");
        System.err.println("\t-csv\tprint results as csv");
        System.err.println("\t-h,--help\tprint this help information");
    }

    public void reportSummary(FontSummary fontSummary) {
        DecimalFormat decimalFormat = new DecimalFormat("#,###,###");
        System.out.println("     Family: " + fontSummary.getFontFamilyName());
        System.out.println("  Subfamily: " + fontSummary.getFontSubfamilyName());
        System.out.println("    Version: " + fontSummary.getVersion());
        System.out.println("     Length: " + decimalFormat.format(fontSummary.getLength()));
        System.out.println("       CMap: " + fontSummary.getCMapName());
        System.out.println("Code Points: " + decimalFormat.format(fontSummary.getNumCodePoints()));
        System.out.println("     Glyphs: " + decimalFormat.format(fontSummary.getNumGlyphs()));
        System.out.println("Glyph Bytes: " + decimalFormat.format(fontSummary.getGlyphsLength()));
        System.out.println("  BCI Bytes: " + decimalFormat.format(fontSummary.getInstructionsLength()));
        System.out.println();
    }

    public void reportSummaryCsv(FontSummary fontSummary) {
        System.out.print(fontSummary.getFontFamilyName());
        System.out.print(",");
        System.out.print(fontSummary.getFontSubfamilyName());
        System.out.print(",");
        System.out.print(fontSummary.getVersion());
        System.out.print(",");
        System.out.print(fontSummary.getLength());
        System.out.print(",");
        System.out.print(fontSummary.getCMapName());
        System.out.print(",");
        System.out.print(fontSummary.getNumCodePoints());
        System.out.print(",");
        System.out.print(fontSummary.getNumGlyphs());
        System.out.print(",");
        System.out.print(fontSummary.getGlyphsLength());
        System.out.print(",");
        System.out.print(fontSummary.getInstructionsLength());
        System.out.println();
    }
}

