/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import java.util.List;

public class HorizontalMetricsTableBuilder {
    private final Font.Builder fontBuilder;
    private final List<LongHorMetric> metrics;

    public HorizontalMetricsTableBuilder(Font.Builder builder, List<LongHorMetric> list) {
        this.fontBuilder = builder;
        this.metrics = list;
    }

    public void build() {
        int n;
        int n2;
        int n3 = this.metrics.size();
        if (n3 <= 0) {
            throw new IllegalArgumentException("nMetrics must be positive");
        }
        int n4 = this.metrics.get((int)(n3 - 1)).advanceWidth;
        for (n2 = n3; n2 > 1 && this.metrics.get((int)(n2 - 2)).advanceWidth == n4; --n2) {
        }
        int n5 = 4 * n2 + 2 * (n3 - n2);
        WritableFontData writableFontData = WritableFontData.createWritableFontData(n5);
        int n6 = 0;
        int n7 = 0;
        for (n = 0; n < n2; ++n) {
            int n8 = this.metrics.get((int)n).advanceWidth;
            n7 = Math.max(n8, n7);
            n6 += writableFontData.writeUShort(n6, n8);
            n6 += writableFontData.writeShort(n6, this.metrics.get((int)n).lsb);
        }
        for (n = n2; n < n3; ++n) {
            n6 += writableFontData.writeShort(n6, this.metrics.get((int)n).lsb);
        }
        this.fontBuilder.newTableBuilder(Tag.hmtx, writableFontData);
        HorizontalHeaderTable.Builder builder = (HorizontalHeaderTable.Builder)this.fontBuilder.getTableBuilder(Tag.hhea);
        builder.setNumberOfHMetrics(n2);
        builder.setAdvanceWidthMax(n7);
    }

    public static class LongHorMetric {
        public int advanceWidth;
        public int lsb;

        public LongHorMetric(int n, int n2) {
            this.advanceWidth = n;
            this.lsb = n2;
        }
    }
}

