/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.tools.subsetter.HorizontalMetricsTableBuilder;
import com.google.typography.font.tools.subsetter.Subsetter;
import com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.util.ArrayList;
import java.util.List;

public class HorizontalMetricsTableSubsetter
extends TableSubsetterImpl {
    protected HorizontalMetricsTableSubsetter() {
        super(Tag.hmtx, Tag.hhea);
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder builder) {
        List<Integer> list = subsetter.glyphMappingTable();
        if (list == null) {
            return false;
        }
        HorizontalMetricsTable horizontalMetricsTable = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        ArrayList<HorizontalMetricsTableBuilder.LongHorMetric> arrayList = new ArrayList<HorizontalMetricsTableBuilder.LongHorMetric>();
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            int n2 = horizontalMetricsTable.advanceWidth(n);
            int n3 = horizontalMetricsTable.leftSideBearing(n);
            arrayList.add(new HorizontalMetricsTableBuilder.LongHorMetric(n2, n3));
        }
        new HorizontalMetricsTableBuilder(builder, arrayList).build();
        return true;
    }
}

