/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import javax.swing.UIManager;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.Lexer;
import jsyntaxpane.util.Configuration;

public class DarkModeAwareSyntaxKit
extends DefaultSyntaxKit {
    public DarkModeAwareSyntaxKit(Lexer lexer) {
        super(lexer);
    }

    private int cut(double val) {
        int ival = (int)Math.round(val);
        if (ival < 0) {
            return 0;
        }
        if (ival > 255) {
            ival = 255;
        }
        return ival;
    }

    @Override
    public Configuration getConfig() {
        Configuration cnf = super.getConfig();
        Color editorBackground = UIManager.getColor("EditorPane.background");
        int light = (editorBackground.getRed() + editorBackground.getGreen() + editorBackground.getBlue()) / 3;
        if (light < 128) {
            cnf.put("Style.DEFAULT", "0xffffff, 0");
            cnf.put("Style.IDENTIFIER", "0xffffff, 0");
            cnf.put("Style.TYPE", "0xffffff, 2");
            cnf.put("Style.TYPE2", "0xffffff, 1");
            cnf.put("Style.TYPE3", "0xffffff, 3");
            cnf.put("Style.OPERATOR", "0xffffff, 0");
            cnf.put("Style.DELIMITER", "0xffffff, 1");
            cnf.put("Style.KEYWORD", "0x8888ff, 0");
            cnf.put("Style.KEYWORD2", "0x448888, 3");
            cnf.put("Style.COMMENT", "0x88ff88, 3");
            cnf.put("Style.COMMENT2", "0x88ff88, 3");
            cnf.put("CaretColor", "0xffffff");
        }
        return cnf;
    }
}

