/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.QuickFindDialog;
import jsyntaxpane.actions.gui.ReplaceDialog;

public class DocumentSearchData {
    private static final String PROPERTY_KEY = "SearchData";
    private Pattern pattern = null;
    private boolean wrap = true;
    private ReplaceDialog replaceDlg;
    private QuickFindDialog quickFindDlg;
    private Map<JTextComponent, Integer> currentOccurrenceMap = new WeakHashMap<JTextComponent, Integer>();

    private DocumentSearchData() {
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pat, boolean regex, boolean ignoreCase) throws PatternSyntaxException {
        if (pat != null && pat.length() > 0) {
            int flag = regex ? 0 : 16;
            this.setPattern(Pattern.compile(pat, flag |= ignoreCase ? 2 : 0));
        } else {
            this.setPattern(null);
        }
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public static DocumentSearchData getFromEditor(JTextComponent target) {
        if (target == null) {
            return null;
        }
        Object o = target.getDocument().getProperty(PROPERTY_KEY);
        if (o instanceof DocumentSearchData) {
            DocumentSearchData documentSearchData = (DocumentSearchData)o;
            return documentSearchData;
        }
        DocumentSearchData newDSD = new DocumentSearchData();
        target.getDocument().putProperty(PROPERTY_KEY, newDSD);
        return newDSD;
    }

    public void doReplaceAll(JTextComponent target, String replacement) {
        SyntaxDocument sDoc;
        if (replacement == null) {
            replacement = "";
        }
        if ((sDoc = ActionUtils.getSyntaxDocument(target)) == null) {
            return;
        }
        if (this.getPattern() == null) {
            return;
        }
        Matcher matcher = sDoc.getMatcher(this.getPattern());
        String newText = matcher.replaceAll(replacement);
        try {
            sDoc.replace(0, sDoc.getLength(), newText, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(DocumentSearchData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doReplace(JTextComponent target, String replacement) {
        if (target.getSelectedText() != null) {
            target.replaceSelection(replacement == null ? "" : replacement);
            this.doFindNext(target);
        }
    }

    public boolean doFindPrev(JTextComponent target) {
        if (this.getPattern() == null) {
            return false;
        }
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (sDoc == null) {
            return false;
        }
        int dot = target.getSelectionStart();
        Matcher matcher = sDoc.getMatcher(this.getPattern());
        if (matcher == null) {
            return false;
        }
        int start = -1;
        int end = -1;
        int occurrenceNumber = 0;
        while (matcher.find() && matcher.end() < dot) {
            ++occurrenceNumber;
            start = matcher.start();
            end = matcher.end();
        }
        if (end > 0) {
            target.select(start, end);
            this.currentOccurrenceMap.put(target, occurrenceNumber);
            return true;
        }
        return false;
    }

    public int getOccurrencesCount(JTextComponent target) {
        if (this.getPattern() == null) {
            return 0;
        }
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (sDoc == null) {
            return 0;
        }
        Matcher matcher = sDoc.getMatcher(this.getPattern());
        if (matcher == null) {
            return 0;
        }
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public int getCurrentOccurrence(JTextComponent target) {
        if (!this.currentOccurrenceMap.containsKey(target)) {
            return 0;
        }
        return this.currentOccurrenceMap.get(target);
    }

    public boolean doFindNext(JTextComponent target) {
        if (this.getPattern() == null) {
            return false;
        }
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (sDoc == null) {
            return false;
        }
        int start = target.getSelectionEnd();
        if (target.getSelectionEnd() == target.getSelectionStart()) {
            ++start;
        }
        if (start >= sDoc.getLength()) {
            start = sDoc.getLength();
        }
        Matcher matcher = sDoc.getMatcher(this.getPattern());
        int occurrenceNumber = 0;
        boolean found = false;
        if (matcher != null) {
            while (matcher.find()) {
                ++occurrenceNumber;
                if (matcher.start() < start) continue;
                found = true;
                break;
            }
        }
        if (found) {
            target.select(matcher.start(), matcher.end());
            this.currentOccurrenceMap.put(target, occurrenceNumber);
            return true;
        }
        if (this.isWrap()) {
            matcher = sDoc.getMatcher(this.getPattern());
            if (matcher != null && matcher.find()) {
                target.select(matcher.start(), matcher.end());
                this.currentOccurrenceMap.put(target, 1);
                return true;
            }
            this.currentOccurrenceMap.put(target, 0);
            return false;
        }
        return false;
    }

    public void msgNotFound(Component target) {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(target), MessageFormat.format(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("DocumentSearchData.SearchStringNotFound"), this.getPattern()), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("DocumentSearchData.Find"), 1);
    }

    public void showQuickFindDialogEx(JTextComponent target, boolean ignoreCase, boolean regularExpresion) {
        if (this.quickFindDlg == null) {
            this.quickFindDlg = new QuickFindDialog(target, this);
        }
        this.quickFindDlg.setIgnoreCase(ignoreCase);
        this.quickFindDlg.setRegularExpression(regularExpresion);
        this.quickFindDlg.showFor(target);
    }

    public void showReplaceDialog(JTextComponent target) {
        if (this.replaceDlg == null) {
            this.replaceDlg = new ReplaceDialog(target, this);
        }
        this.replaceDlg.setVisible(true);
    }

    public void showQuickFindDialog(JTextComponent target) {
        if (this.quickFindDlg == null) {
            this.quickFindDlg = new QuickFindDialog(target, this);
        }
        this.quickFindDlg.showFor(target);
    }
}

