/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class ToggleCommentsAction
extends DefaultSyntaxAction {
    protected String lineCommentStart = "// ";
    protected Pattern lineCommentPattern = null;

    public ToggleCommentsAction() {
        super("toggle-comment");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        if (this.lineCommentPattern == null) {
            this.lineCommentPattern = Pattern.compile("(^" + this.lineCommentStart + ")(.*)");
        }
        String[] lines = ActionUtils.getSelectedLines(target);
        int start = target.getSelectionStart();
        StringBuffer toggled = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            Matcher m = this.lineCommentPattern.matcher(lines[i]);
            if (m.find()) {
                toggled.append(m.replaceFirst("$2"));
            } else {
                toggled.append(this.lineCommentStart);
                toggled.append(lines[i]);
            }
            toggled.append('\n');
        }
        target.replaceSelection(toggled.toString());
        target.select(start, start + toggled.length());
    }

    public void setLineComments(String value) {
        this.lineCommentStart = value.replace("\"", "");
    }
}

