/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFInfo;
import gnu.jpdf.PDFJob;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Locale;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.RequestingUserName;
import javax.swing.JFileChooser;

public class PDFPrinterJob
extends PrinterJob {
    private static JFileChooser fileChooser;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private PDFInfo info = new PDFInfo();
    private Pageable pageable = null;
    private PageFormat pageFormat = new PageFormat();
    private Printable printable;
    private PDFJob printJob;

    public PDFPrinterJob() {
        this.setJobName("Java Printing");
    }

    @Override
    public void cancel() {
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        return this.validatePage(page);
    }

    @Override
    public int getCopies() {
        return ((IntegerSyntax)((Object)this.attributes.get(Copies.class))).getValue();
    }

    @Override
    public String getJobName() {
        return ((TextSyntax)((Object)this.attributes.get(JobName.class))).getValue();
    }

    public static PrinterJob getPrinterJob() {
        return new PDFPrinterJob();
    }

    @Override
    public String getUserName() {
        return ((TextSyntax)((Object)this.attributes.get(RequestingUserName.class))).getValue();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        return (PageFormat)page.clone();
    }

    public void print(String pathname) throws PrinterException {
        File file = null;
        FileOutputStream fileOutputStream = null;
        try {
            file = new File(pathname);
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            System.err.println("Error!! - Invalid output file path: " + pathname);
        }
        PDFGraphics pdfGraphics = null;
        this.printJob = new PDFJob(fileOutputStream);
        if (this.info != null) {
            this.printJob.getPDFDocument().setPDFInfo(this.info);
        }
        int pageCount = this.pageable.getNumberOfPages();
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            this.pageFormat = this.pageable.getPageFormat(pageIndex);
            pdfGraphics = (PDFGraphics)this.printJob.getGraphics(this.pageFormat);
            this.printable = this.pageable.getPrintable(pageIndex);
            this.printable.print(pdfGraphics, this.pageFormat, pageIndex);
            pdfGraphics.dispose();
        }
        this.printJob.end();
    }

    @Override
    public void print() throws PrinterException {
        String jobName = this.getJobName();
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
        }
        if (jobName.equals("")) {
            jobName = "Java Printing";
        }
        jobName = jobName.replaceAll("\\\\", "-");
        jobName = jobName.replaceAll("/", "-");
        File path = fileChooser.getCurrentDirectory();
        File file = new File(path, jobName + ".pdf");
        fileChooser.setSelectedFile(file);
        if (fileChooser.showSaveDialog(null) == 0) {
            file = fileChooser.getSelectedFile();
            this.print(file.getAbsolutePath());
        }
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        return true;
    }

    public void setAuthor(String author) {
        this.info.setAuthor(author);
    }

    @Override
    public void setCopies(int copies) {
        this.attributes.add(new Copies(copies));
    }

    public void setCreator(String creator) {
        this.info.setCreator(creator);
    }

    @Override
    public void setJobName(String jobName) {
        this.attributes.add(new JobName(jobName, Locale.getDefault()));
        if (this.info.getTitle() == null) {
            this.info.setTitle(jobName);
        }
    }

    @Override
    public void setPageable(Pageable document) throws NullPointerException {
        if (document == null) {
            throw new NullPointerException("Pageable cannot be null.");
        }
        this.pageable = document;
    }

    @Override
    public void setPrintable(Printable painter) {
        this.printable = painter;
    }

    @Override
    public void setPrintable(Printable painter, PageFormat format) {
        this.printable = painter;
        this.pageFormat = format;
    }

    public void setTitle(String title) {
        this.info.setTitle(title);
    }

    @Override
    public PageFormat validatePage(PageFormat page) {
        return (PageFormat)page.clone();
    }
}

