/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.zip.DeflaterOutputStream;

public class PDFStream
extends PDFObject
implements Serializable {
    transient ByteArrayOutputStream buf = new ByteArrayOutputStream();
    boolean deflate = false;

    public PDFStream() {
        this(null);
    }

    public PDFStream(String type) {
        super(type);
    }

    public void setDeflate(boolean mode) {
        this.deflate = mode;
    }

    public boolean getDeflate() {
        return this.deflate;
    }

    public OutputStream getOutputStream() {
        return this.buf;
    }

    public PrintWriter getWriter() {
        return new PrintWriter(this.buf, true);
    }

    public ByteArrayOutputStream getStream() {
        return this.buf;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        this.writeStream(os);
    }

    public void writeStream(OutputStream os) throws IOException {
        if (this.deflate) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream(b);
            this.buf.writeTo(dos);
            dos.finish();
            dos.close();
            os.write("/Filter /FlateDecode\n".getBytes("UTF-8"));
            os.write("/Length ".getBytes("UTF-8"));
            os.write(Integer.toString(b.size() + 1).getBytes("UTF-8"));
            os.write("\n>>\nstream\n".getBytes("UTF-8"));
            b.writeTo(os);
            os.write("\n".getBytes("UTF-8"));
        } else {
            os.write("/Length ".getBytes("UTF-8"));
            os.write(Integer.toString(this.buf.size()).getBytes("UTF-8"));
            os.write("\n>>\nstream\n".getBytes("UTF-8"));
            this.buf.writeTo(os);
        }
        os.write("endstream\nendobj\n".getBytes("UTF-8"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.buf.size());
        out.write(this.buf.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        int l = in.readInt();
        byte[] b = new byte[l];
        in.read(b, 0, l);
        this.buf = new ByteArrayOutputStream(l);
        this.buf.write(b);
    }
}

