/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.csv;

import com.jpexs.csv.CsvRow;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public final class CsvLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int STRING = 2;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    private static final String ZZ_CMAP_PACKED = "\n\u0000\u0001\u0002\u0001\u0005\u0001\u0005\u0001\u0001\u0014\u0000\u0001\u0004\u0018\u0000\u0001\u0003I\u0000\u0001\u0005\u1fa2\u0000\u0001\u0005\u0001\u0005\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = CsvLexer.zzUnpackCMap("\n\u0000\u0001\u0002\u0001\u0005\u0001\u0005\u0001\u0001\u0014\u0000\u0001\u0004\u0018\u0000\u0001\u0003I\u0000\u0001\u0005\u1fa2\u0000\u0001\u0005\u0001\u0005\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = CsvLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0002\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007";
    private static final int[] ZZ_ROWMAP = CsvLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0006\u0000\f\u0000\u0012\u0000\f\u0000\u0018\u0000\f\u0000\u001e\u0000\f\u0000\f";
    private static final int[] ZZ_TRANS = CsvLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0003\u0001\u0007\u0001\u0003\u0002\u0007\u0001\u0003\u0001\b\u0001\u0007\b\u0000\u0001\u0005\u0007\u0000\u0001\t\u0005\u0000\u0001\n\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CsvLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    StringBuilder string = new StringBuilder();
    List<String> currentRow = new ArrayList<String>();

    private static int[] zzUnpackAction() {
        int[] result = new int[10];
        int offset = 0;
        offset = CsvLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[10];
        int offset = 0;
        offset = CsvLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[36];
        int offset = 0;
        offset = CsvLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[10];
        int offset = 0;
        offset = CsvLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public CsvLexer(String source) {
        this(new StringReader(source));
    }

    public CsvLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 62) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int totalRead;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        int requested = this.zzBuffer.length - this.zzEndRead;
        for (totalRead = 0; totalRead < requested && (numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead + totalRead, requested - totalRead)) != -1; totalRead += numRead) {
        }
        if (totalRead > 0) {
            this.zzEndRead += totalRead;
            if (totalRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public CsvRow yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block20: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzCharCount;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            block21: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; zzCurrentPosL += zzCharCount) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block21;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block21;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            continue block21;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block21;
                    }
                    default: {
                        zzR = false;
                        this.yycolumn += zzCharCount;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.string.append(this.yytext());
                }
                case 8: {
                    continue block20;
                }
                case 2: {
                    this.currentRow.add(this.string.toString());
                    this.string.setLength(0);
                    CsvRow ret = new CsvRow(this.currentRow);
                    this.currentRow = new ArrayList<String>();
                    return ret;
                }
                case 9: {
                    continue block20;
                }
                case 3: {
                    this.currentRow.add(this.string.toString());
                    this.string.setLength(0);
                }
                case 10: {
                    continue block20;
                }
                case 4: 
                case 11: {
                    continue block20;
                }
                case 5: {
                    this.yybegin(0);
                }
                case 12: {
                    continue block20;
                }
                case 6: {
                    this.currentRow.add(this.string.toString());
                    this.string.setLength(0);
                    this.yybegin(2);
                }
                case 13: {
                    continue block20;
                }
                case 7: {
                    this.string.append("\"");
                }
                case 14: {
                    continue block20;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                if (this.string == null) {
                    return null;
                }
                if (this.currentRow.isEmpty() && this.string.length() == 0) {
                    this.string = null;
                    return null;
                }
                this.currentRow.add(this.string.toString());
                this.string.setLength(0);
                CsvRow ret = new CsvRow(this.currentRow);
                this.currentRow = new ArrayList<String>();
                this.string = null;
                return ret;
            }
            this.zzScanError(1);
        }
    }
}

