/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.cache.ScriptDecompiledListener;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.ImmediateFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DecompilerPool {
    private final ThreadPoolExecutor executor;
    private Map<Openable, List<Future<HighlightedText>>> openableToFutures = new WeakHashMap<Openable, List<Future<HighlightedText>>>();

    public DecompilerPool() {
        int threadCount = Configuration.getParallelThreadCount();
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public Future<HighlightedText> submitTask(final ASMSource src, final ActionList actions, final ScriptDecompiledListener<HighlightedText> listener) {
        final CancellableWorker w = CancellableWorker.getCurrent();
        Callable<HighlightedText> callable = new Callable<HighlightedText>(){
            final /* synthetic */ DecompilerPool this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public HighlightedText call() throws Exception {
                if (w != null) {
                    CancellableWorker.assignThreadToWorker(Thread.currentThread(), w);
                }
                if (listener != null) {
                    listener.onStart();
                }
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
                writer.startFunction("!script");
                src.getActionScriptSource(writer, actions);
                writer.endFunction();
                writer.finishHilights();
                HighlightedText result = new HighlightedText(writer);
                SWF swf = src.getSwf();
                if (swf != null) {
                    swf.as2Cache.put(src, result);
                }
                if (listener != null) {
                    listener.onComplete(result);
                }
                return result;
            }
        };
        return this.submit(callable);
    }

    public Future<HighlightedText> submitTask(final AbcIndexing abcIndex, final ScriptPack pack, final ScriptDecompiledListener<HighlightedText> listener) {
        final CancellableWorker w = CancellableWorker.getCurrent();
        Callable<HighlightedText> callable = new Callable<HighlightedText>(){
            final /* synthetic */ DecompilerPool this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public HighlightedText call() throws Exception {
                SWF swf;
                if (w != null) {
                    CancellableWorker.assignThreadToWorker(Thread.currentThread(), w);
                }
                if (listener != null) {
                    listener.onStart();
                }
                int scriptIndex = pack.scriptIndex;
                ScriptInfo script = null;
                if (scriptIndex > -1) {
                    script = pack.abc.script_info.get(scriptIndex);
                }
                boolean parallel = Configuration.parallelSpeedUp.get();
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
                pack.toSource(abcIndex, writer, script == null ? null : script.traits.traits, new ConvertData(), ScriptExportMode.AS, parallel, false, false);
                writer.finishHilights();
                HighlightedText result = new HighlightedText(writer);
                Openable openable = pack.getOpenable();
                SWF sWF = swf = openable instanceof SWF ? (SWF)openable : ((ABC)openable).getSwf();
                if (swf != null) {
                    swf.as3Cache.put(pack, result);
                }
                if (listener != null) {
                    listener.onComplete(result);
                }
                return result;
            }
        };
        return this.submit(callable);
    }

    private Future<HighlightedText> submit(Callable<HighlightedText> callable) {
        boolean parallel = Configuration.parallelSpeedUp.get();
        if (parallel) {
            Future<HighlightedText> f = this.executor.submit(callable);
            return f;
        }
        boolean cancelled = false;
        Exception throwable = null;
        HighlightedText result = null;
        try {
            result = callable.call();
        }
        catch (InterruptedException ex) {
            cancelled = true;
        }
        catch (Exception ex) {
            throwable = ex;
        }
        return new ImmediateFuture<HighlightedText>(result, throwable, cancelled);
    }

    public String getStat() {
        return "core: " + this.executor.getCorePoolSize() + " size: " + this.executor.getPoolSize() + " largest: " + this.executor.getLargestPoolSize() + " max: " + this.executor.getMaximumPoolSize() + " active: " + this.executor.getActiveCount() + " count: " + this.executor.getTaskCount() + " completed: " + this.executor.getCompletedTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightedText decompile(ASMSource src, ActionList actions) throws InterruptedException {
        final Future<HighlightedText> future = this.submitTask(src, actions, null);
        SWF swf = src.getSwf();
        if (!this.openableToFutures.containsKey(swf)) {
            this.openableToFutures.put(swf, new ArrayList());
        }
        this.openableToFutures.get(swf).add(future);
        final CancellableWorker w = CancellableWorker.getCurrent();
        if (w != null) {
            if (w.isCancelled()) {
                throw new InterruptedException();
            }
            w.addCancelListener(new Runnable(){
                final /* synthetic */ DecompilerPool this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    w.removeCancelListener(this);
                    future.cancel(true);
                }
            });
        }
        try {
            HighlightedText highlightedText = future.get();
            return highlightedText;
        }
        catch (InterruptedException ex) {
            future.cancel(true);
            throw ex;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ex.getCause();
            }
            Logger.getLogger(DecompilerPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            List<Future<HighlightedText>> futures = this.openableToFutures.get(swf);
            if (futures != null) {
                futures.remove(future);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightedText decompile(AbcIndexing abcIndex, ScriptPack pack) throws InterruptedException {
        Future<HighlightedText> future = this.submitTask(abcIndex, pack, null);
        Openable openable = pack.getOpenable();
        if (!this.openableToFutures.containsKey(openable)) {
            this.openableToFutures.put(openable, new ArrayList());
        }
        this.openableToFutures.get(openable).add(future);
        try {
            HighlightedText highlightedText = future.get();
            return highlightedText;
        }
        catch (InterruptedException ex) {
            future.cancel(true);
            throw ex;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ex.getCause();
            }
            Logger.getLogger(DecompilerPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            List<Future<HighlightedText>> futures = this.openableToFutures.get(openable);
            if (futures != null) {
                futures.remove(future);
            }
        }
        return null;
    }

    public void shutdown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(100L, TimeUnit.SECONDS);
    }

    public void destroySwf(SWF swf) {
        List<Future<HighlightedText>> futures = this.openableToFutures.get(swf);
        if (futures != null) {
            for (Future<HighlightedText> future : futures) {
                if (future == null) continue;
                future.cancel(true);
            }
        }
    }
}

