/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.BinarySWFBundle;
import com.jpexs.decompiler.flash.Bundle;
import com.jpexs.decompiler.flash.OpenableSourceKind;
import com.jpexs.decompiler.flash.SWC;
import com.jpexs.decompiler.flash.SearchMode;
import com.jpexs.decompiler.flash.ZippedBundle;
import com.jpexs.decompiler.flash.iggy.conversion.IggySwfBundle;
import com.jpexs.helpers.Path;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OpenableSourceInfo {
    private final InputStream inputStream;
    private String file;
    private String fileTitle;
    private final boolean detectBundle;
    private boolean empty = false;
    private OpenableSourceKind kind;

    public OpenableSourceInfo(String fileTitle) {
        this(null, null, fileTitle, false);
        this.empty = true;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public OpenableSourceInfo(InputStream inputStream, String file, String fileTitle) {
        this(inputStream, file, fileTitle, true);
    }

    public OpenableSourceInfo(InputStream inputStream, String file, String fileTitle, boolean detectBundle) {
        this.inputStream = inputStream;
        this.file = file;
        this.fileTitle = fileTitle;
        this.detectBundle = detectBundle;
        this.detectKind();
    }

    public OpenableSourceKind getKind() {
        return this.kind;
    }

    private void detectKind() {
        this.kind = this.isBundle() ? OpenableSourceKind.BUNDLE : (this.file != null && this.file.endsWith(".abc") ? OpenableSourceKind.ABC : OpenableSourceKind.SWF);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
        this.detectKind();
        this.empty = false;
    }

    public void setFileTitle(String fileTitle) {
        this.fileTitle = fileTitle;
    }

    public String getFileTitle() {
        return this.fileTitle;
    }

    public String getFileTitleOrName() {
        if (this.fileTitle != null) {
            return this.fileTitle;
        }
        return this.file;
    }

    public boolean isBundle() {
        if (this.inputStream == null && this.file != null) {
            File fileObj = new File(this.file);
            String fileName = fileObj.getName();
            if (fileName.startsWith("asdec_") && fileName.endsWith(".tmp")) {
                return false;
            }
            String extension = Path.getExtension(fileObj);
            return this.detectBundle && (extension == null || !extension.equals(".swf") && !extension.equals(".spl") && !extension.equals(".swt") && !extension.equals(".gfx") && !extension.equals(".abc"));
        }
        return false;
    }

    public Bundle getBundle(boolean noCheck, SearchMode searchMode) throws IOException {
        if (!this.isBundle()) {
            return null;
        }
        String extension = Path.getExtension(new File(this.file));
        if (extension != null) {
            switch (extension) {
                case ".swc": {
                    return new SWC(new File(this.file));
                }
                case ".zip": {
                    return new ZippedBundle(new File(this.file));
                }
                case ".iggy": {
                    return new IggySwfBundle(new File(this.file));
                }
            }
        }
        return new BinarySWFBundle(new BufferedInputStream(new FileInputStream(this.file)), noCheck, searchMode);
    }
}

