/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.ZippedBundle;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SWC
extends ZippedBundle {
    public SWC(File filename) throws IOException {
        super(filename);
    }

    @Override
    protected void initBundle(File filename) throws IOException {
        super.initBundle(filename);
        this.keySet.clear();
        ZipFile zipFile = new ZipFile(filename);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().equals("catalog.xml")) continue;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                DefaultHandler handler = new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        String path;
                        if (qName.equalsIgnoreCase("library") && (path = attributes.getValue("path")) != null) {
                            SWC.this.keySet.add(path);
                        }
                    }
                };
                saxParser.parse(zipFile.getInputStream(entry), handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        zipFile.close();
    }

    @Override
    public String getExtension() {
        return "swc";
    }
}

