/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.Bundle;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.streams.SeekableInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZippedBundle
implements Bundle {
    protected Set<String> keySet = new HashSet<String>();
    protected File filename;

    public ZippedBundle(File filename) throws IOException {
        this.initBundle(filename);
    }

    protected void initBundle(File filename) throws IOException {
        this.filename = filename;
        ZipFile zipFile = new ZipFile(filename);
        this.keySet.clear();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().toLowerCase().endsWith(".swf") && !entry.getName().toLowerCase().endsWith(".spl") && !entry.getName().toLowerCase().endsWith(".gfx") && !entry.getName().toLowerCase().endsWith(".abc")) continue;
            this.keySet.add(entry.getName());
        }
        zipFile.close();
    }

    @Override
    public int length() {
        return this.keySet.size();
    }

    @Override
    public Set<String> getKeys() {
        return this.keySet;
    }

    @Override
    public SeekableInputStream getOpenable(String key) throws IOException {
        MemoryInputStream mis;
        if (!this.keySet.contains(key)) {
            return null;
        }
        ZipFile zipFile = new ZipFile(this.filename);
        ZipEntry entry = zipFile.getEntry(key);
        MemoryInputStream ret = mis = new MemoryInputStream(Helper.readStream(zipFile.getInputStream(entry)));
        zipFile.close();
        return ret;
    }

    @Override
    public Map<String, SeekableInputStream> getAll() throws IOException {
        HashMap<String, SeekableInputStream> ret = new HashMap<String, SeekableInputStream>();
        for (String key : this.getKeys()) {
            ret.put(key, this.getOpenable(key));
        }
        return ret;
    }

    @Override
    public String getExtension() {
        return "zip";
    }

    @Override
    public boolean isReadOnly() {
        return this.filename == null || !this.filename.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putOpenable(String key, InputStream swfIs) throws IOException {
        if (this.isReadOnly()) {
            return false;
        }
        if (key == null) {
            return false;
        }
        if (!this.getKeys().contains(key)) {
            return false;
        }
        ZipFile zipFile = new ZipFile(this.filename);
        File tempFile = new File(this.filename.getAbsolutePath() + ".tmp");
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempFile));
            byte[] swfData = Helper.readStream(swfIs);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            try {
                while (entries.hasMoreElements()) {
                    InputStream src;
                    ZipEntry entryOut;
                    ZipEntry entryIn = entries.nextElement();
                    if (entryIn.getName().equals(key)) {
                        entryOut = new ZipEntry(key);
                        src = new ByteArrayInputStream(swfData);
                    } else {
                        src = zipFile.getInputStream(entryIn);
                        entryOut = entryIn;
                    }
                    zos.putNextEntry(entryOut);
                    Helper.copyStream(src, zos, entryOut.getSize() == -1L ? Long.MAX_VALUE : entryOut.getSize());
                    zos.closeEntry();
                }
            }
            finally {
                zos.close();
                zipFile.close();
            }
        }
        catch (IOException ex) {
            tempFile.delete();
            throw ex;
        }
        this.filename.delete();
        tempFile.renameTo(this.filename);
        this.initBundle(this.filename);
        return true;
    }
}

