/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.avm2.ConvertException;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugFileIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugLineIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.LookupSwitchIns;
import com.jpexs.decompiler.flash.abc.avm2.model.GlobalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.helpers.FileTextWriter;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScriptPack
extends AS3ClassTreeItem {
    private static final Logger logger = Logger.getLogger(ScriptPack.class.getName());
    public final ABC abc;
    public List<ABC> allABCs;
    public final int scriptIndex;
    public final List<Integer> traitIndices;
    private final ClassPath path;
    public boolean isSimple = false;
    public boolean scriptInitializerIsEmpty = false;

    @Override
    public Openable getOpenable() {
        return this.abc.getOpenable();
    }

    public ClassPath getClassPath() {
        return this.path;
    }

    public ScriptPack(ClassPath path, ABC abc, List<ABC> allAbcs, int scriptIndex, List<Integer> traitIndices) {
        super(path.className, path.namespaceSuffix, path);
        this.abc = abc;
        this.scriptIndex = scriptIndex;
        this.traitIndices = traitIndices;
        this.path = path;
        this.allABCs = allAbcs;
    }

    public DottedChain getPathPackage() {
        DottedChain packageName = DottedChain.TOPLEVEL;
        for (int t : this.traitIndices) {
            Multiname name = this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t).getName(this.abc);
            int nskind = name.getSimpleNamespaceKind(this.abc.constants);
            if (nskind != 22 && nskind != 23) continue;
            packageName = name.getSimpleNamespaceName(this.abc.constants);
        }
        return packageName;
    }

    public Trait getPublicTrait() {
        for (int t : this.traitIndices) {
            Multiname name = this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t).getName(this.abc);
            int nskind = name.getSimpleNamespaceKind(this.abc.constants);
            if (nskind != 22 && nskind != 23) continue;
            return this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t);
        }
        return null;
    }

    public String getPathScriptName() {
        String scriptName = "script_" + this.scriptIndex;
        for (int t : this.traitIndices) {
            Multiname name = this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t).getName(this.abc);
            int nskind = name.getSimpleNamespaceKind(this.abc.constants);
            if (nskind != 22 && nskind != 23) continue;
            scriptName = name.getName(new LinkedHashSet<String>(), this.abc, this.abc.constants, null, false, true);
        }
        return scriptName;
    }

    public File getExportFile(String directory, String extension) {
        String scriptName = this.getPathScriptName();
        DottedChain packageName = this.getPathPackage();
        File outDir = new File(directory + File.separatorChar + packageName.toFilePath(this.abc.getSwf()));
        String fileName = outDir.toString() + File.separator + Helper.makeFileName(scriptName) + extension;
        return new File(fileName);
    }

    public File getExportFile(String directory, ScriptExportSettings exportSettings) {
        if (exportSettings.singleFile) {
            return null;
        }
        return this.getExportFile(directory, exportSettings.getFileExtension());
    }

    public void convert(Set<String> usedDeobfuscations, AbcIndexing abcIndex, NulWriter writer, List<Trait> traits, ConvertData convertData, ScriptExportMode exportMode, boolean parallel) throws InterruptedException {
        int sinit_index;
        int sinit_bodyIndex;
        int swfVersion = -1;
        if (this.getOpenable() instanceof SWF) {
            swfVersion = ((SWF)this.getOpenable()).version;
        }
        if ((sinit_bodyIndex = this.abc.findBodyIndex(sinit_index = this.abc.script_info.get((int)this.scriptIndex).init_index)) != -1 && (this.isSimple || this.traitIndices.isEmpty())) {
            ArrayList<Integer> initClasses = new ArrayList<Integer>();
            for (Trait t : traits) {
                if (!(t instanceof TraitClass)) continue;
                initClasses.add(((TraitClass)t).class_info);
            }
            writer.mark();
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
            callStack.add(this.abc.bodies.get(sinit_bodyIndex));
            this.abc.bodies.get(sinit_bodyIndex).convert(swfVersion, callStack, abcIndex, convertData, this.path + "/.scriptinitializer", exportMode, true, sinit_index, this.scriptIndex, -1, this.abc, null, new ScopeStack(), -3, writer, new ArrayList<DottedChain>(), this.abc.script_info.get((int)this.scriptIndex).traits, true, new HashSet<Integer>(), initClasses, usedDeobfuscations);
            this.scriptInitializerIsEmpty = !writer.getMark();
        }
        ScopeStack scopeStack = new ScopeStack();
        scopeStack.push(new GlobalAVM2Item(null, null));
        Iterator<Serializable> iterator = this.traitIndices.iterator();
        while (iterator.hasNext()) {
            int t = (Integer)iterator.next();
            Trait trait = traits.get(t);
            Multiname name = trait.getName(this.abc);
            int nskind = name.getSimpleNamespaceKind(this.abc.constants);
            if (nskind == 22 || nskind == 23) {
                trait.convertPackaged(usedDeobfuscations, swfVersion, abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, scopeStack);
                continue;
            }
            trait.convert(usedDeobfuscations, swfVersion, abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, scopeStack);
        }
    }

    private void appendTo(Set<String> usedDeobfuscations, AbcIndexing abcIndex, GraphTextWriter writer, List<Trait> traits, ConvertData convertData, ScriptExportMode exportMode, boolean parallel, boolean exportAllClasses) throws InterruptedException {
        String documentClass;
        int t;
        Trait trait;
        int swfVersion = -1;
        if (this.getOpenable() instanceof SWF) {
            swfVersion = ((SWF)this.getOpenable()).version;
        }
        boolean first = true;
        int script_init = this.abc.script_info.get((int)this.scriptIndex).init_index;
        int bodyIndex = this.abc.findBodyIndex(script_init);
        if (!this.isSimple && this.traitIndices.isEmpty()) {
            for (Trait t2 : this.abc.script_info.get((int)this.scriptIndex).traits.traits) {
                if (t2 instanceof TraitSlotConst) continue;
                String fullName = t2.getName(this.abc).getNameWithNamespace(usedDeobfuscations, this.abc, this.abc.constants, false).toPrintableString(usedDeobfuscations, this.abc.getSwf(), true);
                writer.appendNoHilight("include \"" + fullName.replace(".", "/") + ".as\";").newLine();
            }
            writer.newLine();
        }
        DottedChain pkg = this.getPathPackage();
        ArrayList<Trait> traitList = new ArrayList<Trait>();
        ArrayList<Integer> traitIndicesList = new ArrayList<Integer>(this.traitIndices);
        for (int t3 : this.traitIndices) {
            trait = traits.get(t3);
            traitList.add(trait);
        }
        ArrayList<DottedChain> fullyQualifiedNames = new ArrayList<DottedChain>();
        for (int t3 = 0; t3 < traitList.size(); ++t3) {
            trait = (Trait)traitList.get(t3);
            int nskind = trait.getName(this.abc).getSimpleNamespaceKind(this.abc.constants);
            if (nskind != 22 && nskind != 23) continue;
            if (!first) {
                writer.newLine();
            }
            writer.startTrait(((Integer)traitIndicesList.get(t3)).intValue());
            trait.toStringPackaged(usedDeobfuscations, swfVersion, abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, fullyQualifiedNames, parallel, false);
            if (!(trait instanceof TraitClass)) {
                writer.endTrait();
            }
            first = false;
            traitList.remove(t3);
            traitIndicesList.remove(t3);
            --t3;
        }
        if (!first) {
            writer.newLine();
        }
        DottedChain ignorePackage = null;
        if (this.isSimple) {
            ignorePackage = this.getPathPackage();
        }
        Trait.writeImports(usedDeobfuscations, traitList, script_init, abcIndex, this.scriptIndex, -1, true, this.abc, writer, ignorePackage, fullyQualifiedNames);
        first = true;
        for (t = 0; t < traitList.size(); ++t) {
            Trait trait2 = (Trait)traitList.get(t);
            if (trait2 instanceof TraitSlotConst) continue;
            if (!first) {
                writer.newLine();
            }
            writer.startTrait(((Integer)traitIndicesList.get(t)).intValue());
            trait2.toString(usedDeobfuscations, swfVersion, abcIndex, pkg, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, false);
            if (!(trait2 instanceof TraitClass)) {
                writer.endTrait();
            }
            first = false;
            traitList.remove(t);
            traitIndicesList.remove(t);
            --t;
        }
        for (t = 0; t < traitList.size(); ++t) {
            Trait trait3 = (Trait)traitList.get(t);
            if (!(trait3 instanceof TraitSlotConst) || convertData.assignedValues.containsKey((TraitSlotConst)trait3)) continue;
            if (!first) {
                writer.newLine();
            }
            writer.startTrait(((Integer)traitIndicesList.get(t)).intValue());
            Multiname name = trait3.getName(this.abc);
            int nskind = name.getSimpleNamespaceKind(this.abc.constants);
            if (nskind == 22 || nskind == 23) {
                trait3.toStringPackaged(usedDeobfuscations, swfVersion, abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, false);
            } else {
                trait3.toString(usedDeobfuscations, swfVersion, abcIndex, pkg, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, false);
            }
            writer.endTrait();
            first = false;
        }
        if (bodyIndex != -1 && (this.isSimple || this.traitIndices.isEmpty())) {
            writer.startTrait(-3L);
            writer.startMethod(script_init, null);
            if (exportMode != ScriptExportMode.AS_METHOD_STUBS) {
                if (!this.scriptInitializerIsEmpty) {
                    ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                    callStack.add(this.abc.bodies.get(bodyIndex));
                    if (!first) {
                        writer.newLine();
                    }
                    this.abc.bodies.get(bodyIndex).toString(usedDeobfuscations, swfVersion, callStack, abcIndex, this.path + "/.scriptinitializer", exportMode, this.abc, null, writer, fullyQualifiedNames, new HashSet<Integer>());
                } else {
                    writer.append("");
                }
            }
            writer.endMethod();
            writer.endTrait();
            if (!this.scriptInitializerIsEmpty) {
                writer.newLine();
                first = false;
            }
        }
        if (exportAllClasses && (documentClass = this.abc.getSwf().getDocumentClass()) != null && this.path.toRawString().equals(documentClass)) {
            writer.append("//Include all classes in the build").append("\r\n");
            writer.append("function __ffdec_include_classes():void { FFDecIncludeClasses; }");
        }
        IdentifiersDeobfuscation.writeCurrentScriptReplacements(writer, usedDeobfuscations, this.abc.getSwf());
    }

    public void toSource(final AbcIndexing abcIndex, GraphTextWriter writer, final List<Trait> traits, final ConvertData convertData, final ScriptExportMode exportMode, final boolean parallel, boolean ignoreFrameScripts, boolean exportAllClasses) throws InterruptedException {
        writer.suspendMeasure();
        final Set<String> usedDeobfuscations = Collections.synchronizedSet(new LinkedHashSet());
        int timeout = Configuration.decompilationTimeoutFile.get();
        try {
            CancellableWorker.call("script.scriptPack.toSource", new Callable<Void>(){
                final /* synthetic */ ScriptPack this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void call() throws Exception {
                    this.this$0.convert(usedDeobfuscations, abcIndex, new NulWriter(), traits, convertData, exportMode, parallel);
                    return null;
                }
            }, timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            writer.continueMeasure();
            logger.log(Level.SEVERE, "Decompilation timeout", ex);
            Helper.appendTimeoutCommentAs3(writer, timeout, 0);
            return;
        }
        catch (CancellationException ex) {
            throw new InterruptedException();
        }
        catch (ExecutionException ex) {
            writer.continueMeasure();
            Exception convertException = ex;
            Throwable cause = ex.getCause();
            if (cause instanceof Exception) {
                convertException = (Exception)cause;
            }
            if (convertException instanceof CancellationException) {
                throw new InterruptedException();
            }
            if (convertException instanceof InterruptedException) {
                throw (InterruptedException)convertException;
            }
            logger.log(Level.SEVERE, "Decompilation error", convertException);
            Helper.appendErrorComment(writer, convertException);
            return;
        }
        writer.continueMeasure();
        this.appendTo(usedDeobfuscations, abcIndex, writer, traits, convertData, exportMode, parallel, exportAllClasses);
    }

    public File export(AbcIndexing abcIndex, File file, ScriptExportSettings exportSettings, boolean parallel) throws IOException, InterruptedException {
        if (!exportSettings.singleFile && file.exists() && !Configuration.overwriteExistingFiles.get().booleanValue()) {
            return file;
        }
        if (file != null) {
            Path.createDirectorySafe(file.getParentFile());
        }
        try (FileTextWriter writer = exportSettings.singleFile ? null : new FileTextWriter(Configuration.getCodeFormatting(), new FileOutputStream(file));){
            FileTextWriter writer2 = exportSettings.singleFile ? exportSettings.singleFileWriter : writer;
            ConvertData convertData = new ConvertData();
            convertData.ignoreFrameScripts = exportSettings.ignoreFrameScripts;
            convertData.ignoreAccessibility = exportSettings.ignoreAccessibility;
            convertData.exportEmbed = exportSettings.exportEmbed;
            convertData.exportEmbedFlaMode = exportSettings.exportEmbedFlaMode;
            convertData.assetsDir = exportSettings.assetsDir;
            this.toSource(abcIndex, writer2, this.abc.script_info.get((int)this.scriptIndex).traits.traits, convertData, exportSettings.mode, parallel, exportSettings.ignoreFrameScripts, exportSettings.includeAllClasses);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, "The file path is probably too long", ex);
        }
        return file;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + System.identityHashCode(this.abc);
        hash = 79 * hash + this.scriptIndex;
        hash = 79 * hash + Objects.hashCode(this.path);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptPack other = (ScriptPack)obj;
        if (this.abc != other.abc) {
            return false;
        }
        if (this.scriptIndex != other.scriptIndex) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    @Override
    public boolean isModified() {
        if (this.scriptIndex >= this.abc.script_info.size()) {
            return false;
        }
        return this.abc.script_info.get(this.scriptIndex).isModified();
    }

    public void clearModified() {
        if (this.scriptIndex >= this.abc.script_info.size()) {
            return;
        }
        this.abc.script_info.get(this.scriptIndex).setModified(false);
    }

    @Override
    protected SWF getSwf() {
        return this.abc.getSwf();
    }

    public void injectDebugInfo(File directoryPath) {
        this.injectDebugInfo(directoryPath, "main");
    }

    public void injectDebugInfo(File directoryPath, String swfHash) {
        HashMap bodyToPosToLine = new HashMap();
        HashMap bodyLineToPos = new HashMap();
        HashMap bodyToRegToName = new HashMap();
        HashMap bodyToRegToLine = new HashMap();
        HashMap<Integer, Integer> bodyToActivationReg = new HashMap<Integer, Integer>();
        HashSet<Integer> lonelyBody = new HashSet<Integer>();
        HashMap<Integer, Integer> bodyLines = new HashMap<Integer, Integer>();
        HashMap<Integer, String> bodyToFunctionName = new HashMap<Integer, String>();
        try {
            HighlightedText decompiled = SWF.getCached(this);
            int line = 1;
            String txt = decompiled.text;
            txt = txt.replace("\r", "");
            for (int i = 0; i < txt.length(); ++i) {
                block41: {
                    String regName;
                    int regIndex;
                    int bodyIndex2;
                    block45: {
                        block42: {
                            int pos;
                            block44: {
                                long instrOffset;
                                block43: {
                                    Highlighting sh = Highlighting.searchPos(decompiled.getSpecialHighlights(), i);
                                    Highlighting cls = Highlighting.searchPos(decompiled.getClassHighlights(), i);
                                    Highlighting trt = Highlighting.searchPos(decompiled.getTraitHighlights(), i);
                                    Highlighting method = Highlighting.searchPos(decompiled.getMethodHighlights(), i);
                                    if (method == null) break block41;
                                    Highlighting instr = Highlighting.searchPos(decompiled.getInstructionHighlights(), i);
                                    int classIndex = cls == null ? -1 : (int)cls.getProperties().index;
                                    int methodIndex = (int)method.getProperties().index;
                                    bodyIndex2 = this.abc.findBodyIndex(methodIndex);
                                    if (bodyIndex2 == -1) break block41;
                                    if (!bodyLines.containsKey(bodyIndex2)) {
                                        bodyLines.put(bodyIndex2, line);
                                    }
                                    if (!bodyToFunctionName.containsKey(bodyIndex2)) {
                                        bodyToFunctionName.put(bodyIndex2, method.getProperties().localName);
                                    }
                                    bodyToActivationReg.put(bodyIndex2, method.getProperties().activationRegIndex);
                                    pos = -1;
                                    regIndex = -1;
                                    regName = null;
                                    if (sh != null && sh.getProperties().declaration && sh.getProperties().regIndex > -1) {
                                        regIndex = sh.getProperties().regIndex;
                                        regName = sh.getProperties().localName;
                                    }
                                    if (instr == null) break block42;
                                    if (instr.getProperties().declaration && instr.getProperties().regIndex > -1) {
                                        regIndex = instr.getProperties().regIndex;
                                        regName = instr.getProperties().localName;
                                    }
                                    if ((instrOffset = instr.getProperties().firstLineOffset) != -1L) break block43;
                                    lonelyBody.add(bodyIndex2);
                                    break block41;
                                }
                                try {
                                    pos = this.abc.bodies.get(bodyIndex2).getCode().adr2pos(instrOffset);
                                }
                                catch (ConvertException convertException) {
                                    // empty catch block
                                }
                                if (pos != -1) break block44;
                                lonelyBody.add(bodyIndex2);
                                break block41;
                            }
                            if (!bodyToPosToLine.containsKey(bodyIndex2)) {
                                bodyToPosToLine.put(bodyIndex2, new HashMap());
                                bodyLineToPos.put(bodyIndex2, new HashMap());
                            }
                            ((Map)bodyToPosToLine.get(bodyIndex2)).put(pos, line);
                            ((Map)bodyLineToPos.get(bodyIndex2)).put(line, pos);
                            break block45;
                        }
                        lonelyBody.add(bodyIndex2);
                    }
                    if (regIndex > -1 && regName != null) {
                        if (!bodyToRegToName.containsKey(bodyIndex2)) {
                            bodyToRegToName.put(bodyIndex2, new HashMap());
                            bodyToRegToLine.put(bodyIndex2, new HashMap());
                        }
                        if (!((Map)bodyToRegToName.get(bodyIndex2)).containsKey(regIndex)) {
                            ((Map)bodyToRegToName.get(bodyIndex2)).put(regIndex, regName);
                            ((Map)bodyToRegToLine.get(bodyIndex2)).put(regIndex, line);
                        }
                    }
                }
                if (txt.charAt(i) != '\n') continue;
                ++line;
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Cannot decompile", ex);
        }
        int scriptInitBody = this.abc.findBodyIndex(this.abc.script_info.get((int)this.scriptIndex).init_index);
        if (!bodyToRegToName.containsKey(scriptInitBody)) {
            lonelyBody.add(scriptInitBody);
        }
        String pkg = this.path.packageStr.toString();
        String cls = this.path.className;
        String filename = new File(directoryPath, this.path.packageStr.toFilePath(this.abc.getSwf())).getPath().replace(";", "{{semicolon}}") + ";" + swfHash + ":" + pkg.replace(".", File.separator).replace(";", "{{semicolon}}") + ";" + cls.replace(";", "{{semicolon}}") + ".as";
        filename = filename.replaceAll("\\{(invalid_utf8=[0-9]+)\\}", "[$1]");
        Iterator<Object> iterator = lonelyBody.iterator();
        while (iterator.hasNext()) {
            int bodyIndex = (Integer)iterator.next();
            if (bodyToPosToLine.keySet().contains(bodyIndex)) continue;
            MethodBody b = this.abc.bodies.get(bodyIndex);
            List<AVM2Instruction> code = b.getCode().code;
            for (int i = 0; i < code.size(); ++i) {
                AVM2Instruction ins = code.get(i);
                if (ins.definition instanceof DebugLineIns) {
                    b.removeInstruction(i);
                    --i;
                    continue;
                }
                if (ins.definition instanceof DebugFileIns) {
                    b.removeInstruction(i);
                    --i;
                    continue;
                }
                if (!(ins.definition instanceof DebugIns)) continue;
                b.removeInstruction(i);
                --i;
            }
            b.setModified();
        }
        iterator = bodyToPosToLine.keySet().iterator();
        while (iterator.hasNext()) {
            AVM2Instruction ins;
            Object obj;
            int i;
            int bodyIndex = (Integer)iterator.next();
            ArrayList<AVM2Instruction> delIns = new ArrayList<AVM2Instruction>();
            MethodBody b = this.abc.bodies.get(bodyIndex);
            List<AVM2Instruction> code = b.getCode().code;
            for (AVM2Instruction ins2 : code) {
                if (ins2.definition instanceof DebugLineIns) {
                    delIns.add(ins2);
                }
                if (ins2.definition instanceof DebugFileIns) {
                    delIns.add(ins2);
                }
                if (!(ins2.definition instanceof DebugIns)) continue;
                delIns.add(ins2);
            }
            ArrayList<Object> code2 = new ArrayList<Object>();
            code2.add(new AVM2Instruction(0L, 241, new int[]{this.abc.constants.getStringId(filename, true)}));
            TreeSet regs = bodyToRegToName.containsKey(bodyIndex) ? ((Map)bodyToRegToName.get(bodyIndex)).keySet() : new TreeSet();
            Iterator bodyIndex2 = regs.iterator();
            while (bodyIndex2.hasNext()) {
                int r = (Integer)bodyIndex2.next();
                String name = (String)((Map)bodyToRegToName.get(bodyIndex)).get(r);
                int line = (Integer)((Map)bodyToRegToLine.get(bodyIndex)).get(r);
                code2.add(new AVM2Instruction(0L, 239, new int[]{1, this.abc.constants.getStringId(name, true), r - 1, line}));
            }
            int activationReg = -1;
            if (bodyToActivationReg.containsKey(bodyIndex)) {
                activationReg = (Integer)bodyToActivationReg.get(bodyIndex);
            }
            if (activationReg > -1) {
                int bodyLine = bodyLines.containsKey(bodyIndex) ? (Integer)bodyLines.get(bodyIndex) : 0;
                String activationRegName = "anonymous$0";
                if (bodyToFunctionName.containsKey(bodyIndex) && bodyToFunctionName.get(bodyIndex) != null) {
                    activationRegName = (String)bodyToFunctionName.get(bodyIndex) + "$0";
                }
                code2.add(new AVM2Instruction(0L, 239, new int[]{1, this.abc.constants.getStringId(activationRegName, true), activationReg - 1, bodyLine}));
            }
            ArrayList pos = new ArrayList(((Map)bodyToPosToLine.get(bodyIndex)).keySet());
            Collections.sort(pos);
            Collections.reverse(pos);
            HashSet<Integer> addedLines = new HashSet<Integer>();
            Set<Long> importantOffsets = b.getCode().getImportantOffsets(b, true);
            HashMap<Integer, Integer> origPosToNewPos = new HashMap<Integer, Integer>();
            for (int i2 = 0; i2 < code.size(); ++i2) {
                long adr = b.getCode().pos2adr(i2);
                if (importantOffsets.contains(adr)) {
                    code2.add(new Label(adr));
                }
                origPosToNewPos.put(i2, code2.size());
                if (delIns.contains(code.get(i2))) continue;
                code2.add(code.get(i2));
            }
            Iterator i2 = pos.iterator();
            while (i2.hasNext()) {
                int i3 = (Integer)i2.next();
                int line = (Integer)((Map)bodyToPosToLine.get(bodyIndex)).get(i3);
                if (addedLines.contains(line) || !origPosToNewPos.containsKey(i3)) continue;
                addedLines.add(line);
                logger.log(Level.FINE, "Script {0}: Insert debugline({1}) at pos {2} to body {3}", new Object[]{this.path, line, i3, bodyIndex});
                code2.add((Integer)origPosToNewPos.get(i3), new AVM2Instruction(0L, 240, new int[]{line}));
            }
            long adr = 0L;
            HashMap<Long, Long> mapOffsets = new HashMap<Long, Long>();
            for (i = 0; i < code2.size(); ++i) {
                obj = code2.get(i);
                if (obj instanceof AVM2Instruction) {
                    ins = (AVM2Instruction)obj;
                    adr += (long)ins.getBytesLength();
                }
                if (!(obj instanceof Label)) continue;
                Label lab = (Label)obj;
                mapOffsets.put(lab.addr, adr);
            }
            code.clear();
            adr = 0L;
            for (i = 0; i < code2.size(); ++i) {
                int changedOperand;
                long changedAddr;
                long targetAddr;
                obj = code2.get(i);
                if (!(obj instanceof AVM2Instruction)) continue;
                ins = (AVM2Instruction)obj;
                if (ins.definition instanceof IfTypeIns) {
                    targetAddr = ins.getTargetAddress();
                    if (mapOffsets.containsKey(targetAddr)) {
                        changedAddr = (Long)mapOffsets.get(targetAddr);
                        ins.operands[0] = changedOperand = (int)(changedAddr - adr - 4L);
                    } else {
                        logger.log(Level.WARNING, "Invalid jump target in script {0}, bodyIndex {1}", new Object[]{this.toString(), bodyIndex});
                    }
                }
                if (ins.definition instanceof LookupSwitchIns) {
                    targetAddr = ins.getAddress() + (long)ins.operands[0];
                    if (mapOffsets.containsKey(targetAddr)) {
                        changedAddr = (Long)mapOffsets.get(targetAddr);
                        ins.operands[0] = changedOperand = (int)(changedAddr - adr);
                    } else {
                        logger.log(Level.WARNING, "Invalid jump target in script {0}, bodyIndex {1}", new Object[]{this.toString(), bodyIndex});
                    }
                    for (int k = 2; k < ins.operands.length; ++k) {
                        targetAddr = ins.getAddress() + (long)ins.operands[k];
                        if (mapOffsets.containsKey(targetAddr)) {
                            changedAddr = (Long)mapOffsets.get(targetAddr);
                            ins.operands[k] = changedOperand = (int)(changedAddr - adr);
                            continue;
                        }
                        logger.log(Level.WARNING, "Invalid jump target in script {0}, bodyIndex {1}", new Object[]{this.toString(), bodyIndex});
                    }
                }
                ins.setAddress(adr);
                adr += (long)ins.getBytesLength();
                code.add(ins);
            }
            for (ABCException ex : b.exceptions) {
                long lstart = ex.start;
                long ltarget = ex.target;
                long lend = ex.end;
                lstart = (Long)mapOffsets.get(lstart);
                ltarget = (Long)mapOffsets.get(ltarget);
                lend = (Long)mapOffsets.get(lend);
                ex.start = (int)lstart;
                ex.target = (int)ltarget;
                ex.end = (int)lend;
            }
            b.setModified();
        }
        ((Tag)((Object)this.abc.parentTag)).setModified(true);
    }

    public void injectPCodeDebugInfo(int abcIndex, String swfHash) {
        HashMap<Integer, String> bodyToIdentifier = new HashMap<Integer, String>();
        try {
            HighlightedText decompiled = SWF.getCached(this);
            String txt = decompiled.text;
            txt = txt.replace("\r", "");
            for (int i = 0; i < txt.length(); ++i) {
                Highlighting sh = Highlighting.searchPos(decompiled.getSpecialHighlights(), i);
                Highlighting cls = Highlighting.searchPos(decompiled.getClassHighlights(), i);
                Highlighting trt = Highlighting.searchPos(decompiled.getTraitHighlights(), i);
                Highlighting method = Highlighting.searchPos(decompiled.getMethodHighlights(), i);
                if (method == null) continue;
                int classIndex = cls == null ? -1 : (int)cls.getProperties().index;
                int methodIndex = (int)method.getProperties().index;
                int bodyIndex = this.abc.findBodyIndex(methodIndex);
                if (bodyIndex == -1) continue;
                int traitIndex = -10;
                if (trt != null && cls != null) {
                    traitIndex = (int)trt.getProperties().index;
                }
                bodyToIdentifier.put(bodyIndex, "abc:" + abcIndex + ",script:" + this.scriptIndex + ",class:" + classIndex + ",trait:" + traitIndex + ",method:" + methodIndex + ",body:" + bodyIndex);
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Cannot decompile", ex);
        }
        int scriptInitBody = this.abc.findBodyIndex(this.abc.script_info.get((int)this.scriptIndex).init_index);
        if (!bodyToIdentifier.containsKey(scriptInitBody)) {
            bodyToIdentifier.put(scriptInitBody, "abc:" + abcIndex + ",script:" + this.scriptIndex + ",class:-1,trait:-3,method:" + this.abc.script_info.get((int)this.scriptIndex).init_index + ",body:" + scriptInitBody);
        }
        String pkg = this.path.packageStr.toString();
        String cls = this.path.className;
        Iterator iterator = bodyToIdentifier.keySet().iterator();
        while (iterator.hasNext()) {
            int i;
            int bodyIndex = (Integer)iterator.next();
            String bodyName = (String)bodyToIdentifier.get(bodyIndex);
            MethodBody b = this.abc.bodies.get(bodyIndex);
            List<AVM2Instruction> list = b.getCode().code;
            int siz = list.size();
            for (i = 0; i < siz; ++i) {
                b.insertInstruction(i * 2, new AVM2Instruction(0L, 240, new int[]{i + 1}));
            }
            for (i = 1; i < list.size(); i += 2) {
                if (list.get((int)i).definition instanceof DebugLineIns) {
                    b.removeInstruction(i);
                    b.removeInstruction(i - 1);
                    i -= 2;
                    continue;
                }
                if (list.get((int)i).definition instanceof DebugFileIns) {
                    b.removeInstruction(i);
                    b.removeInstruction(i - 1);
                    i -= 2;
                    continue;
                }
                if (!(list.get((int)i).definition instanceof DebugIns)) continue;
                b.removeInstruction(i);
                b.removeInstruction(i - 1);
                i -= 2;
            }
            String filename = swfHash + ":#PCODE " + bodyName + ";" + pkg.replace(".", File.separator) + ";" + cls + ".as";
            b.insertInstruction(0, new AVM2Instruction(0L, 241, new int[]{this.abc.constants.getStringId(filename, true)}));
            b.setModified();
        }
        ((Tag)((Object)this.abc.parentTag)).setModified(true);
    }

    public void getMethodInfos(List<MethodId> methodInfos) {
        int script_init = this.abc.script_info.get((int)this.scriptIndex).init_index;
        methodInfos.add(new MethodId(-3, -1, script_init));
        List<Trait> traits = this.abc.script_info.get((int)this.scriptIndex).traits.traits;
        for (int t : this.traitIndices) {
            Trait trait = traits.get(t);
            trait.getMethodInfos(this.abc, -4, -1, methodInfos);
        }
    }

    public void delete(ABC abc, boolean d) {
        ScriptInfo si = abc.script_info.get(this.scriptIndex);
        if (this.isSimple) {
            si.delete(abc, d);
        } else {
            for (int t : this.traitIndices) {
                si.traits.traits.get(t).delete(abc, d);
            }
        }
    }

    public boolean isDocumentClass() {
        String documentClass = this.abc.getSwf().getDocumentClass();
        return documentClass != null && documentClass.equals(this.getClassPath().toRawString());
    }

    private class Label {
        public long addr;

        public Label(long addr) {
            this.addr = addr;
        }
    }
}

