/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2;

public class NumberContext {
    public static final int ROUND_CEILING = 0;
    public static final int ROUND_UP = 1;
    public static final int ROUND_HALF_UP = 2;
    public static final int ROUND_HALF_EVEN = 3;
    public static final int ROUND_HALF_DOWN = 4;
    public static final int ROUND_DOWN = 5;
    public static final int ROUND_FLOOR = 6;
    public static final int USE_NUMBER = 0;
    public static final int USE_DECIMAL = 1;
    public static final int USE_DOUBLE = 2;
    public static final int USE_INT = 3;
    public static final int USE_UINT = 4;
    private static String[] usageNames = new String[]{"Number", "decimal", "double", "int", "uint"};
    private static String[] roundingNames = new String[]{"CEILING", "UP", "HALF_UP", "HALF_EVEN", "HALF_DOWN", "DOWN", "FLOOR"};
    private int usage = 0;
    private int precision = 34;
    private int rounding = 3;

    public NumberContext(int usage, int precision, int rounding) {
        this.usage = usage;
        this.precision = precision;
        this.rounding = rounding;
    }

    public NumberContext(int param) {
        this.usage = param & 7;
        this.rounding = param >> 3 & 7;
        this.precision = param >> 6;
        if ((this.usage == 0 || this.usage == 1) && this.precision == 0) {
            this.precision = 34;
        }
    }

    public void setUsage(int usage) {
        if (usage >= usageNames.length || usage < 0) {
            this.usage = 0;
            return;
        }
        this.usage = usage;
    }

    public int getUsage() {
        return this.usage;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        if (precision > 34) {
            precision = 34;
        }
        this.precision = precision;
    }

    public void setRounding(int rounding) {
        if (rounding >= roundingNames.length || rounding < 0) {
            this.rounding = 3;
            return;
        }
        this.rounding = rounding;
    }

    public int getRounding() {
        return this.rounding;
    }

    public int toParam() {
        int ret = this.usage;
        if (this.usage == 0 || this.usage == 1) {
            ret |= this.rounding << 3;
            if (this.precision < 34) {
                ret |= this.precision << 6;
            }
        }
        return ret;
    }

    public static String usageToName(int usage) {
        if (usage >= usageNames.length || usage < 0) {
            return "Number";
        }
        return usageNames[usage];
    }

    public static String roundingToName(int rounding) {
        if (rounding >= roundingNames.length || rounding < 0) {
            return "HALF_EVEN";
        }
        return roundingNames[rounding];
    }

    public boolean isDefault() {
        return this.usage == 0 && this.precision == 34;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NumberContext");
        sb.append("(");
        sb.append(NumberContext.usageToName(this.usage));
        if (this.usage == 0 || this.usage == 1) {
            sb.append(",");
            sb.append(NumberContext.roundingToName(this.rounding));
            if (this.precision < 34) {
                sb.append(",");
                sb.append(this.precision);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

