/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.deobfuscation;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorJumps;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.LookupSwitchIns;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AVM2DeobfuscatorGroupParts
extends SWFDecompilerAdapter {
    @Override
    public void avm2CodeRemoveTraps(String path, int classIndex, boolean isStatic, int scriptIndex, ABC abc, Trait trait, int methodInfo, MethodBody body) throws InterruptedException {
        AVM2Code code = body.getCode();
        code.removeDeadCode(body);
        HashMap<Integer, List<Integer>> refs = body.getCode().visitCode(body);
        for (int i = 0; i < code.code.size(); ++i) {
            long targetAddr;
            int targetIp;
            AVM2Instruction ins = code.code.get(i);
            if (!(ins.definition instanceof JumpIns) || this.realRefs(refs, targetIp = code.adr2pos(targetAddr = ins.getTargetAddress())) != 1) continue;
            int startIp = 0;
            for (int j = i; j >= 0; --j) {
                AVM2Instruction startIns = code.code.get(j);
                if (j < i && (startIns.definition instanceof IfTypeIns || startIns.definition instanceof LookupSwitchIns)) {
                    startIp = j + 1;
                    break;
                }
                long srcAddr = code.pos2adr(j);
                boolean exceptionMismatch = false;
                for (int e = 0; e < body.exceptions.length; ++e) {
                    boolean targetMatch;
                    boolean sourceMatch = srcAddr >= (long)body.exceptions[e].start && srcAddr < (long)body.exceptions[e].end;
                    boolean bl = targetMatch = targetAddr >= (long)body.exceptions[e].start && targetAddr < (long)body.exceptions[e].end;
                    if (sourceMatch == targetMatch) continue;
                    exceptionMismatch = true;
                    break;
                }
                if (exceptionMismatch) {
                    startIp = j + 1;
                    break;
                }
                if (this.realRefs(refs, j) <= 1) continue;
                startIp = j;
                break;
            }
            if (startIp >= i) continue;
            ArrayList<AVM2Instruction> movedInstructions = new ArrayList<AVM2Instruction>();
            for (int k = startIp; k < i; ++k) {
                movedInstructions.add(code.code.get(startIp));
                code.removeInstruction(startIp, body);
            }
            int newTargetIp = targetIp;
            if (targetIp > i) {
                newTargetIp -= movedInstructions.size();
            }
            for (int m = 0; m < movedInstructions.size(); ++m) {
                code.insertInstruction(newTargetIp + m, (AVM2Instruction)movedInstructions.get(m), body);
            }
            i = -1;
            refs = body.getCode().visitCode(body);
        }
        new AVM2DeobfuscatorJumps().avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
    }

    private int realRefs(Map<Integer, List<Integer>> refs, int ip) {
        int refCount = 0;
        for (int r : refs.get(ip)) {
            if (r < 0) continue;
            ++refCount;
        }
        return refCount;
    }
}

