/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.deobfuscation;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AVM2DeobfuscatorJumps
extends SWFDecompilerAdapter {
    @Override
    public void avm2CodeRemoveTraps(String path, int classIndex, boolean isStatic, int scriptIndex, ABC abc, Trait trait, int methodInfo, MethodBody body) throws InterruptedException {
        boolean found;
        AVM2Code code = body.getCode();
        ArrayList<Integer> exceptionStarts = new ArrayList<Integer>();
        for (ABCException ex : body.exceptions) {
            exceptionStarts.add(code.adr2pos(ex.start, true));
        }
        do {
            found = false;
            HashMap<Integer, List<Integer>> refs = body.getCode().visitCode(body);
            for (int i = 0; i < code.code.size(); ++i) {
                AVM2Instruction ins = code.code.get(i);
                if (!(ins.definition instanceof JumpIns)) continue;
                long srcAddr = ins.getAddress();
                long targetAddr = ins.getTargetAddress();
                boolean exceptionMismatch = false;
                for (int e = 0; e < body.exceptions.length; ++e) {
                    boolean targetMatch;
                    boolean sourceMatch = srcAddr >= (long)body.exceptions[e].start && srcAddr < (long)body.exceptions[e].end;
                    boolean bl = targetMatch = targetAddr >= (long)body.exceptions[e].start && targetAddr < (long)body.exceptions[e].end;
                    if (sourceMatch == targetMatch) continue;
                    exceptionMismatch = true;
                    break;
                }
                if (exceptionMismatch || exceptionStarts.contains(i)) continue;
                Iterator iterator = ((List)refs.get(i)).iterator();
                while (iterator.hasNext()) {
                    int r = (Integer)iterator.next();
                    if (r < 0) continue;
                    AVM2Instruction srcIns = code.code.get(r);
                    srcAddr = srcIns.getAddress();
                    if (!(srcIns.definition instanceof JumpIns) && (!(srcIns.definition instanceof IfTypeIns) || r == i - 1)) continue;
                    exceptionMismatch = false;
                    for (int e = 0; e < body.exceptions.length; ++e) {
                        boolean targetMatch;
                        boolean sourceMatch = srcAddr >= (long)body.exceptions[e].start && srcAddr < (long)body.exceptions[e].end;
                        boolean bl = targetMatch = targetAddr >= (long)body.exceptions[e].start && targetAddr < (long)body.exceptions[e].end;
                        if (sourceMatch == targetMatch) continue;
                        exceptionMismatch = true;
                        break;
                    }
                    if (exceptionMismatch) continue;
                    int oldop = srcIns.operands[0];
                    srcIns.operands[0] = (int)(targetAddr - (srcIns.getAddress() + (long)srcIns.getBytesLength()));
                    if (srcIns.operands[0] == oldop) continue;
                    found = true;
                }
            }
            code.removeDeadCode(body);
        } while (found);
    }
}

