/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CallAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CallMethodAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CallPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CallStaticAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CallSuperAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InitVectorAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewFunctionAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.List;
import java.util.Objects;

public class ConstructAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public List<GraphTargetItem> args;

    public ConstructAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, List<GraphTargetItem> args) {
        super(instruction, lineStartIns, 0);
        this.object = object;
        this.args = args;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visitAll(this.args);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.object instanceof NewFunctionAVM2Item) {
            writer.append("new ");
            return this.object.toString(writer, localData);
        }
        writer.append("new ");
        boolean objectIsCall = this.object instanceof CallAVM2Item || this.object instanceof CallPropertyAVM2Item || this.object instanceof CallMethodAVM2Item || this.object instanceof CallStaticAVM2Item || this.object instanceof CallSuperAVM2Item;
        boolean isGetDefinition = false;
        if (this.object instanceof GetPropertyAVM2Item) {
            GetPropertyAVM2Item getProperty = (GetPropertyAVM2Item)this.object;
            if (getProperty.propertyName instanceof FullMultinameAVM2Item) {
                FullMultinameAVM2Item fm = (FullMultinameAVM2Item)getProperty.propertyName;
                if (fm.multinameIndex > 0) {
                    Multiname m = localData.abc.constants.getMultiname(fm.multinameIndex);
                    if (m.kind == 27 && m.getNamespaceSet((AVM2ConstantPool)localData.abc.constants).namespaces.length == 1) {
                        isGetDefinition = true;
                        writer.append("(");
                        if (localData.fullyQualifiedNames.contains(DottedChain.parseNoSuffix("flash.utils.getDefinitionByName"))) {
                            writer.append("flash.utils.getDefinitionByName");
                        } else {
                            writer.append("getDefinitionByName");
                        }
                        writer.append("(");
                        String nname = m.getSingleNamespace(localData.abc.constants).getName(localData.abc.constants).toRawString();
                        if (!nname.isEmpty()) {
                            writer.append("\"");
                            writer.append(Helper.escapeActionScriptString(nname));
                            writer.append("\"+\".\"+");
                        }
                        fm.name.appendTo(writer, localData);
                        writer.append("))");
                    }
                }
            }
        }
        if (!isGetDefinition) {
            if (this.object.getPrecedence() > this.getPrecedence() || objectIsCall) {
                writer.append("(");
            }
            this.object.toString(writer, localData);
            if (this.object.getPrecedence() > this.getPrecedence() || objectIsCall) {
                writer.append(")");
            }
        }
        writer.spaceBeforeCallParenthesis(this.args.size());
        if (this.object instanceof InitVectorAVM2Item) {
            return writer;
        }
        writer.append("(");
        for (int a = 0; a < this.args.size(); ++a) {
            if (a > 0) {
                writer.allowWrapHere().append(",");
            }
            this.args.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return this.object.returnType();
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.object);
        hash = 59 * hash + Objects.hashCode(this.args);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructAVM2Item other = (ConstructAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        if (!Objects.equals(this.args, other.args)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

