/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.List;
import java.util.Objects;

public class ConstructPropAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public GraphTargetItem propertyName;
    public List<GraphTargetItem> args;
    public GraphTargetItem type;
    public boolean isStatic;

    public ConstructPropAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, GraphTargetItem propertyName, List<GraphTargetItem> args, GraphTargetItem type, boolean isStatic) {
        super(instruction, lineStartIns, 0);
        this.object = object;
        this.propertyName = propertyName;
        this.args = args;
        this.type = type;
        this.isStatic = isStatic;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.propertyName);
        visitor.visitAll(this.args);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("new ");
        boolean isGetDefinition = false;
        if (this.propertyName instanceof FullMultinameAVM2Item) {
            FullMultinameAVM2Item fm = (FullMultinameAVM2Item)this.propertyName;
            if (fm.multinameIndex > 0) {
                Multiname m = localData.abc.constants.getMultiname(fm.multinameIndex);
                if (m.kind == 27 && m.getNamespaceSet((AVM2ConstantPool)localData.abc.constants).namespaces.length == 1) {
                    isGetDefinition = true;
                    writer.append("(");
                    if (localData.fullyQualifiedNames.contains(DottedChain.parseNoSuffix("flash.utils.getDefinitionByName"))) {
                        writer.append("flash.utils.getDefinitionByName");
                    } else {
                        writer.append("getDefinitionByName");
                    }
                    writer.append("(");
                    String nname = m.getSingleNamespace(localData.abc.constants).getName(localData.abc.constants).toRawString();
                    if (!nname.isEmpty()) {
                        writer.append("\"");
                        writer.append(Helper.escapeActionScriptString(nname));
                        writer.append("\"+\".\"+");
                    }
                    fm.name.appendTo(writer, localData);
                    writer.append("))");
                }
            }
        }
        if (!isGetDefinition) {
            this.formatProperty(writer, this.object, this.propertyName, localData, this.isStatic, false);
        }
        writer.spaceBeforeCallParenthesis(this.args.size());
        writer.append("(");
        for (int a = 0; a < this.args.size(); ++a) {
            if (a > 0) {
                writer.allowWrapHere().append(",");
            }
            this.args.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.object);
        hash = 67 * hash + Objects.hashCode(this.propertyName);
        hash = 67 * hash + Objects.hashCode(this.args);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructPropAVM2Item other = (ConstructPropAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        return Objects.equals(this.args, other.args);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

