/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;

public class NameSpaceAVM2Item
extends AVM2Item {
    public int namespaceIndex;

    public NameSpaceAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, int namespaceIndex) {
        super(instruction, lineStartIns, 17);
        this.namespaceIndex = namespaceIndex;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        String identifier;
        String nsname;
        if (this.namespaceIndex == 0) {
            return writer.append("*");
        }
        AVM2ConstantPool constants = localData.constantsAvm2;
        DottedChain dc = localData.abc.findCustomNsOfNamespace(this.namespaceIndex);
        String string = nsname = dc != null ? dc.getLast() : null;
        if (nsname != null && (identifier = IdentifiersDeobfuscation.printIdentifier(localData.abc.getSwf(), localData.usedDeobfuscations, true, nsname, new String[0])) != null && !identifier.isEmpty()) {
            writer.append(identifier);
            return writer;
        }
        writer.append("new Namespace").spaceBeforeCallParenthesis(1).append("(");
        writer.append("\"").append(Helper.escapeActionScriptString(constants.getNamespace(this.namespaceIndex).getRawName(constants))).append("\"");
        writer.append(")");
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem("Namespace");
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + this.namespaceIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameSpaceAVM2Item other = (NameSpaceAVM2Item)obj;
        return this.namespaceIndex == other.namespaceIndex;
    }
}

