/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.instructions.SetTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.AssignmentAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.DeclarationAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.Objects;

public class SetSlotAVM2Item
extends AVM2Item
implements SetTypeAVM2Item,
AssignmentAVM2Item {
    public Multiname slotName;
    public GraphTargetItem scope;
    public DeclarationAVM2Item declaration;
    public GraphTargetItem slotObject;
    public int slotIndex;
    public GraphTargetItem compoundValue;
    public String compoundOperator;
    public GraphTargetItem type;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.scope);
        visitor.visit(this.slotObject);
        if (this.value != null) {
            visitor.visit(this.value);
        }
    }

    @Override
    public DeclarationAVM2Item getDeclaration() {
        return this.declaration;
    }

    @Override
    public void setDeclaration(DeclarationAVM2Item declaration) {
        this.declaration = declaration;
    }

    public SetSlotAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scope, GraphTargetItem slotObject, int slotIndex, Multiname slotName, GraphTargetItem value, GraphTargetItem type) {
        super(instruction, lineStartIns, 15, value);
        this.slotName = slotName;
        this.scope = scope;
        this.slotObject = slotObject;
        this.slotIndex = slotIndex;
        this.type = type;
    }

    @Override
    public GraphPart getFirstPart() {
        return this.value.getFirstPart();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.getSrcData().localName = this.getNameAsStr(localData);
        if (this.getSrcData().localName.equals(this.value.toString(localData))) {
            return writer;
        }
        this.getName(writer, localData);
        if (this.compoundOperator != null) {
            writer.append(" ");
            writer.append(this.compoundOperator);
            writer.append("= ");
            return this.compoundValue.toString(writer, localData);
        }
        writer.append(" = ");
        return SetTypeIns.handleNumberToInt(this.value, this.type).toString(writer, localData);
    }

    public String getNameAsStr(LocalData localData) throws InterruptedException {
        if (this.slotName == null) {
            return this.slotObject.toString(localData) + ".\u00a7\u00a7slot[" + this.slotIndex + "]";
        }
        return this.slotName.getName(localData.usedDeobfuscations, localData.abc, localData.constantsAvm2, localData.fullyQualifiedNames, false, true);
    }

    public GraphTextWriter getName(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return writer.append(this.getNameAsStr(localData));
    }

    @Override
    public GraphTargetItem getObject() {
        return new GetSlotAVM2Item(this.getInstruction(), this.getLineStartIns(), this.scope, this.slotObject, this.slotIndex, this.slotName, this.type);
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.scope);
        hash = 29 * hash + this.slotIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetSlotAVM2Item other = (SetSlotAVM2Item)obj;
        if (this.slotIndex != other.slotIndex) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public GraphTargetItem getCompoundValue() {
        return this.compoundValue;
    }

    @Override
    public void setCompoundValue(GraphTargetItem value) {
        this.compoundValue = value;
    }

    @Override
    public void setCompoundOperator(String operator) {
        this.compoundOperator = operator;
    }

    @Override
    public String getCompoundOperator() {
        return this.compoundOperator;
    }
}

