/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.EscapeXAttrAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.EscapeXElemAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ActionScript3Parser;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLAVM2Item
extends AVM2Item {
    public List<GraphTargetItem> parts;

    public XMLAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, List<GraphTargetItem> parts) {
        super(instruction, lineStartIns, 17);
        this.parts = parts;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.parts);
    }

    private String handleSingleXml(String s, Reference<Boolean> inAttributeRef, Reference<Boolean> inOpeningTagRef) {
        String identRegexp = "[:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD][\\-\\.0-9:A-Z_a-z\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u036F\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]*";
        StringBuilder writer = new StringBuilder();
        block10: for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            switch (c) {
                case '\"': {
                    if (inOpeningTagRef.getVal().booleanValue()) {
                        inAttributeRef.setVal(inAttributeRef.getVal() == false);
                    }
                    writer.append(c);
                    continue block10;
                }
                case '<': {
                    Pattern p = Pattern.compile("^(" + identRegexp + ").*", 40);
                    String sub = s.substring(j + 1);
                    Matcher m = p.matcher(sub);
                    writer.append(c);
                    if (!m.matches()) continue block10;
                    inOpeningTagRef.setVal(true);
                    String tag = m.group(1);
                    writer.append(tag);
                    j += tag.length();
                    continue block10;
                }
                case '>': {
                    if (inOpeningTagRef.getVal().booleanValue()) {
                        inOpeningTagRef.setVal(false);
                    }
                    writer.append(c);
                    continue block10;
                }
                default: {
                    if (inAttributeRef.getVal().booleanValue()) {
                        switch (c) {
                            case '\r': {
                                writer.append("&#13;");
                                continue block10;
                            }
                            case '\n': {
                                writer.append("&#10;");
                                continue block10;
                            }
                            case '\t': {
                                writer.append("&#9;");
                                continue block10;
                            }
                        }
                        writer.append(c);
                        continue block10;
                    }
                    writer.append(c);
                }
            }
        }
        return writer.toString();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        Reference<Boolean> inAttributeRef = new Reference<Boolean>(false);
        Reference<Boolean> inOpeningTagRef = new Reference<Boolean>(false);
        if (this.parts.size() == 1 && this.parts.get(0) instanceof StringAVM2Item) {
            String s = ((StringAVM2Item)this.parts.get(0)).getValue();
            s = this.handleSingleXml(s, inAttributeRef, inOpeningTagRef);
            boolean validXml = true;
            try {
                ActionScript3Parser par = new ActionScript3Parser(new AbcIndexing());
                if (!par.checkBasicXmlOnly(s)) {
                    validXml = false;
                }
            }
            catch (Throwable ex) {
                validXml = false;
            }
            if (!validXml) {
                writer.append("new XML");
                writer.spaceBeforeCallParenthesis(1);
                writer.append("(\"").append(Helper.escapeActionScriptString(s)).append("\")");
                return writer;
            }
            writer.spaceBeforeCallParenthesis(this.precedence);
            writer.append(s);
            return writer;
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            GraphTargetItem partAfter;
            GraphTargetItem part = this.parts.get(i);
            GraphTargetItem partBefore = i > 0 ? this.parts.get(i - 1) : null;
            GraphTargetItem graphTargetItem = partAfter = i < this.parts.size() - 1 ? this.parts.get(i + 1) : null;
            if (part instanceof StringAVM2Item) {
                String s = ((StringAVM2Item)part).getValue();
                if (partAfter instanceof EscapeXAttrAVM2Item && s.endsWith("\"")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (partBefore instanceof EscapeXAttrAVM2Item && s.startsWith("\"")) {
                    s = s.substring(1);
                }
                writer.append(this.handleSingleXml(s, inAttributeRef, inOpeningTagRef));
                continue;
            }
            if (part instanceof EscapeXElemAVM2Item || part instanceof EscapeXAttrAVM2Item) {
                part.toString(writer, localData);
                continue;
            }
            writer.append("{");
            part.appendTo(writer, localData);
            writer.append("}");
        }
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.XML);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.parts);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLAVM2Item other = (XMLAVM2Item)obj;
        return Objects.equals(this.parts, other.parts);
    }
}

