/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.UnaryOpItem;
import java.util.List;

public class BitNotAVM2Item
extends UnaryOpItem {
    public BitNotAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value) {
        super(AVM2GraphTargetDialect.INSTANCE, instruction, lineStartIns, 2, value, "~", "int");
    }

    @Override
    public Object getResult() {
        return (long)this.value.getResultAsNumber().doubleValue() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return BitNotAVM2Item.toSourceMerge(localData, generator, this.value, new AVM2Instruction(0L, 151, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.INT;
    }

    @Override
    protected void operandToString(GraphTargetItem operand, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        Integer val;
        if (operand instanceof IntegerValueAVM2Item && (val = ((IntegerValueAVM2Item)operand).value) > 9) {
            String valHex = Integer.toHexString(val).toUpperCase();
            if (valHex.length() % 2 == 1) {
                valHex = "0" + valHex;
            }
            writer.append("0x" + valHex);
            return;
        }
        operand.toString(writer, localData, "", false);
    }
}

