/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.model.DoubleValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.CompoundableBinaryOp;
import com.jpexs.decompiler.graph.model.LocalData;

public abstract class BitwiseBinaryOpAVM2Item
extends BinaryOpItem
implements CompoundableBinaryOp {
    public BitwiseBinaryOpAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartItem, int precedence, GraphTargetItem leftSide, GraphTargetItem rightSide, String operator, String coerceLeft, String coerceRight) {
        super(AVM2GraphTargetDialect.INSTANCE, instruction, lineStartItem, precedence, leftSide, rightSide, operator, coerceLeft, coerceRight);
    }

    @Override
    protected void operandToString(GraphTargetItem operand, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        long val;
        if ((operand instanceof IntegerValueAVM2Item || operand instanceof DoubleValueAVM2Item) && (val = operand.getAsLong()) > 9L) {
            String valHex = Long.toHexString(val).toUpperCase();
            if (valHex.length() % 2 == 1) {
                valHex = "0" + valHex;
            }
            writer.append("0x" + valHex);
            return;
        }
        operand.toString(writer, localData, "", false);
    }
}

