/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineFontAlignZonesTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class InstanceInfo {
    public int name_index;
    public int super_index;
    public int flags;
    public int protectedNS;
    public int[] interfaces;
    public int iinit_index;
    public Traits instance_traits;
    public static final int CLASS_SEALED = 1;
    public static final int CLASS_FINAL = 2;
    public static final int CLASS_INTERFACE = 4;
    public static final int CLASS_PROTECTEDNS = 8;
    public static final int CLASS_NON_NULLABLE = 16;
    @Internal
    public boolean deleted;

    public InstanceInfo() {
        this.instance_traits = new Traits();
    }

    public InstanceInfo(Traits traits) {
        this.instance_traits = traits;
    }

    public String toString() {
        return "name_index=" + this.name_index + " super_index=" + this.super_index + " flags=" + this.flags + " protectedNS=" + this.protectedNS + " interfaces=" + Helper.intArrToString(this.interfaces) + " method_index=" + this.iinit_index + "\r\n" + this.instance_traits.toString();
    }

    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        String supIndexStr = "[nothing]";
        if (this.super_index > 0) {
            supIndexStr = abc.constants.getMultiname(this.super_index).toString(abc.constants, fullyQualifiedNames);
        }
        return "name_index=" + abc.constants.getMultiname(this.name_index).toString(abc.constants, fullyQualifiedNames) + " super_index=" + supIndexStr + " flags=" + this.flags + " protectedNS=" + this.protectedNS + " interfaces=" + Helper.intArrToString(this.interfaces) + " method_index=" + this.iinit_index + "\r\n" + this.instance_traits.toString(abc, fullyQualifiedNames);
    }

    public GraphTextWriter getClassHeaderStr(Set<String> usedDeobfuscations, String assetsDir, GraphTextWriter writer, ABC abc, List<DottedChain> fullyQualifiedNames, boolean allowPrivate, boolean allowEmbed) {
        String ASSETS_DIR = assetsDir;
        if (allowEmbed && abc.getSwf() != null) {
            String className = this.getName(abc.constants).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, false).toRawString();
            CharacterTag ct = abc.getSwf().getCharacterByClass(className);
            if (ct != null) {
                DefineSoundTag st;
                String fileName = ct.getCharacterExportFileName();
                if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue()) {
                    fileName = Configuration.autoDeobfuscateIdentifiers.get() != false ? this.getName(abc.constants).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, false).toPrintableString(new LinkedHashSet<String>(), abc.getSwf(), true) : this.getName(abc.constants).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, false).toRawString();
                }
                String ext = "";
                if (ct instanceof DefineBinaryDataTag) {
                    DefineBinaryDataTag db = (DefineBinaryDataTag)ct;
                    String string = ext = db.innerSwf != null ? ".swf" : ".bin";
                }
                if (ct instanceof ImageTag) {
                    ImageTag it = (ImageTag)ct;
                    ext = it.getImageFormat().getExtension();
                }
                if (ct instanceof DefineSoundTag) {
                    st = (DefineSoundTag)ct;
                    if (st.getSoundFormat().formatId == 2) {
                        ext = ".mp3";
                    }
                }
                if (ct instanceof FontTag) {
                    ext = ".ttf";
                }
                if (ct instanceof DefineFont4Tag) {
                    ext = ".cff";
                }
                fileName = Helper.makeFileName(fileName + ext);
                if (ct instanceof DefineBinaryDataTag) {
                    writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + fileName + "\", mimeType=\"application/octet-stream\")]").newLine();
                }
                if (ct instanceof ImageTag) {
                    writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + fileName + "\")]").newLine();
                }
                if (ct instanceof DefineSpriteTag) {
                    writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + "assets.swf\", symbol=\"symbol" + ct.getCharacterId() + "\")]").newLine();
                }
                if (ct instanceof DefineSoundTag) {
                    st = (DefineSoundTag)ct;
                    if (st.getSoundFormat().formatId == 2) {
                        writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + fileName + "\")]").newLine();
                    } else {
                        writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + "assets.swf\", symbol=\"symbol" + ct.getCharacterId() + "\")]").newLine();
                    }
                }
                if (ct instanceof FontTag) {
                    FontTag ft = (FontTag)ct;
                    boolean hasFontAlignZones = false;
                    List<CharacterIdTag> sameIdTags = ft.getSwf().getCharacterIdTags(abc.getSwf().getCharacterId(ft));
                    for (CharacterIdTag sit : sameIdTags) {
                        if (!(sit instanceof DefineFontAlignZonesTag)) continue;
                        hasFontAlignZones = true;
                        break;
                    }
                    writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + fileName + "\",").newLine();
                    writer.appendNoHilight("fontName=\"" + Helper.escapeActionScriptString(ft.getFontNameIntag()) + "\",").newLine();
                    writer.appendNoHilight("fontFamily=\"" + Helper.escapeActionScriptString(ft.getFontName()) + "\",").newLine();
                    writer.appendNoHilight("mimeType=\"application/x-font\",").newLine();
                    writer.appendNoHilight("fontWeight=\"" + (ft.isBold() ? "bold" : "normal") + "\",").newLine();
                    writer.appendNoHilight("fontStyle=\"" + (ft.isItalic() ? "italic" : "normal") + "\",").newLine();
                    String fontChars = ft.getCharacters();
                    if (!fontChars.isEmpty()) {
                        Character firstC = null;
                        Character lastC = null;
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < fontChars.length(); ++i) {
                            char c = fontChars.charAt(i);
                            if (firstC == null) {
                                firstC = Character.valueOf(c);
                                lastC = Character.valueOf(c);
                                continue;
                            }
                            if (lastC.charValue() + '\u0001' != c) {
                                if (sb.length() > 0) {
                                    sb.append(",");
                                }
                                if (firstC == lastC) {
                                    sb.append(String.format("U+%04X", firstC.charValue()));
                                } else {
                                    sb.append(String.format("U+%04X-%04X", firstC.charValue(), (int)lastC.charValue()));
                                }
                                firstC = Character.valueOf(c);
                            }
                            lastC = Character.valueOf(c);
                        }
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        if (firstC == lastC) {
                            sb.append(String.format("U+%04X", firstC.charValue()));
                        } else {
                            sb.append(String.format("U+%04X-%04X", firstC.charValue(), (int)lastC.charValue()));
                        }
                        writer.appendNoHilight("unicodeRange=\"").appendNoHilight(sb.toString()).appendNoHilight("\",").newLine();
                    }
                    writer.appendNoHilight("advancedAntiAliasing=\"" + (hasFontAlignZones ? "true" : "false") + "\",").newLine();
                    writer.appendNoHilight("embedAsCFF=\"false\"").newLine();
                    writer.appendNoHilight(")]").newLine();
                }
                if (ct instanceof DefineFont4Tag) {
                    DefineFont4Tag ft4 = (DefineFont4Tag)ct;
                    writer.appendNoHilight("[Embed(source=\"" + ASSETS_DIR + fileName + "\",").newLine();
                    writer.appendNoHilight("fontName=\"" + Helper.escapeActionScriptString(ft4.fontName) + "\",").newLine();
                    writer.appendNoHilight("mimeType=\"application/x-font\",").newLine();
                    writer.appendNoHilight("fontWeight=\"" + (ft4.fontFlagsBold ? "bold" : "normal") + "\",").newLine();
                    writer.appendNoHilight("fontStyle=\"" + (ft4.fontFlagsItalic ? "italic" : "normal") + "\",").newLine();
                    writer.appendNoHilight("embedAsCFF=\"true\"").newLine();
                    writer.appendNoHilight(")]").newLine();
                }
            }
        }
        Namespace ns = abc.constants.getMultiname(this.name_index).getNamespace(abc.constants);
        String modifiers = ns.getPrefix();
        if (!allowPrivate && modifiers.equals("private")) {
            modifiers = "";
        }
        if (!modifiers.isEmpty()) {
            modifiers = modifiers + " ";
        }
        if (this.isFinal()) {
            modifiers = modifiers + "final ";
        }
        if (!this.isInterface() && this.isDynamic()) {
            modifiers = modifiers + "dynamic ";
        }
        String objType = "class ";
        if (this.isInterface()) {
            objType = "interface ";
        }
        writer.appendNoHilight(modifiers + objType);
        String classTypeName = abc.constants.getMultiname(this.name_index).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, true).toRawString();
        writer.hilightSpecial(abc.constants.getMultiname(this.name_index).getName(usedDeobfuscations, abc, abc.constants, null, false, true), HighlightSpecialType.CLASS_NAME, classTypeName);
        if (!this.isNullable()) {
            writer.appendNoHilight("!");
        }
        if (this.super_index > 0) {
            String typeName = abc.constants.getMultiname(this.super_index).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, true).toRawString();
            String parentName = abc.constants.getMultiname(this.super_index).getName(usedDeobfuscations, abc, abc.constants, fullyQualifiedNames, false, true);
            if (!parentName.equals("Object")) {
                writer.appendNoHilight(" extends ");
                writer.hilightSpecial(parentName, HighlightSpecialType.TYPE_NAME, typeName);
            }
        }
        if (this.interfaces.length > 0) {
            if (this.isInterface()) {
                writer.appendNoHilight(" extends ");
            } else {
                writer.appendNoHilight(" implements ");
            }
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                String typeName = abc.constants.getMultiname(this.interfaces[i]).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, true).toRawString();
                writer.hilightSpecial(abc.constants.getMultiname(this.interfaces[i]).getName(usedDeobfuscations, abc, abc.constants, fullyQualifiedNames, false, true), HighlightSpecialType.TYPE_NAME, typeName);
            }
        }
        return writer;
    }

    public Multiname getName(AVM2ConstantPool constants) {
        return constants.getMultiname(this.name_index);
    }

    public boolean isInterface() {
        return (this.flags & 4) == 4;
    }

    public boolean isDynamic() {
        return (this.flags & 1) == 0;
    }

    public boolean isFinal() {
        return (this.flags & 2) == 2;
    }

    public boolean isNullable() {
        return (this.flags & 0x10) != 16;
    }
}

