/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.helpers.Helper;

public class ValueKind {
    public static final int CONSTANT_DecimalOrFloat = 2;
    public static final int CONSTANT_Int = 3;
    public static final int CONSTANT_UInt = 4;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_True = 11;
    public static final int CONSTANT_False = 10;
    public static final int CONSTANT_Null = 12;
    public static final int CONSTANT_Undefined = 0;
    public static final int CONSTANT_Namespace = 8;
    public static final int CONSTANT_PackageNamespace = 22;
    public static final int CONSTANT_PackageInternalNs = 23;
    public static final int CONSTANT_ProtectedNamespace = 24;
    public static final int CONSTANT_ExplicitNamespace = 25;
    public static final int CONSTANT_StaticProtectedNs = 26;
    public static final int CONSTANT_PrivateNs = 5;
    public static final int CONSTANT_Float4 = 30;
    private static final int[] kinds = new int[]{3, 4, 6, 2, 1, 11, 10, 12, 0, 8, 22, 23, 24, 25, 26, 5, 30};
    private static final String[] kindNames = new String[]{"Int", "UInt", "Double", "Decimal/Float", "Utf8", "True", "False", "Null", "Undefined", "Namespace", "PackageNamespace", "PackageInternalNs", "ProtectedNamespace", "ExplicitNamespace", "StaticProtectedNs", "PrivateNamespace", "Float4"};
    public int value_index;
    public int value_kind;

    public ValueKind() {
    }

    public ValueKind(int value_index, int value_kind) {
        this.value_index = value_index;
        this.value_kind = value_kind;
    }

    public static int nsKindToValueKind(int nsKind) {
        switch (nsKind) {
            case 25: {
                return 25;
            }
            case 8: {
                return 8;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 5: {
                return 5;
            }
            case 24: {
                return 24;
            }
            case 26: {
                return 26;
            }
        }
        return 0;
    }

    public boolean isNamespace() {
        switch (this.value_kind) {
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = "";
        s = s + this.value_index + ":";
        boolean found = false;
        for (int i = 0; i < kinds.length; ++i) {
            if (kinds[i] != this.value_kind) continue;
            s = s + kindNames[i];
            found = true;
            break;
        }
        if (!found) {
            s = s + "?";
        }
        return s;
    }

    public String toString(ABC abc) {
        String ret = "?";
        switch (this.value_kind) {
            case 3: {
                ret = EcmaScript.toString(abc.constants.getInt(this.value_index));
                break;
            }
            case 4: {
                ret = EcmaScript.toString(abc.constants.getUInt(this.value_index));
                break;
            }
            case 6: {
                ret = EcmaScript.toString(abc.constants.getDouble(this.value_index));
                break;
            }
            case 2: {
                if (abc.hasDecimalSupport()) {
                    ret = abc.constants.getDecimal(this.value_index).toActionScriptString();
                    break;
                }
                float fval = abc.constants.getFloat(this.value_index).floatValue();
                ret = EcmaScript.toString(Float.valueOf(fval)) + (Float.isFinite(fval) ? "f" : "");
                break;
            }
            case 30: {
                Float4 f4 = abc.constants.getFloat4(this.value_index);
                StringBuilder fsb = new StringBuilder();
                fsb.append("float4");
                fsb.append("(");
                fsb.append(EcmaScript.toString(Float.valueOf(f4.values[0])));
                if (Float.isFinite(f4.values[0])) {
                    fsb.append("f");
                }
                fsb.append(",");
                fsb.append(EcmaScript.toString(Float.valueOf(f4.values[1])));
                if (Float.isFinite(f4.values[1])) {
                    fsb.append("f");
                }
                fsb.append(",");
                fsb.append(EcmaScript.toString(Float.valueOf(f4.values[2])));
                if (Float.isFinite(f4.values[2])) {
                    fsb.append("f");
                }
                fsb.append(",");
                fsb.append(EcmaScript.toString(Float.valueOf(f4.values[3])));
                if (Float.isFinite(f4.values[3])) {
                    fsb.append("f");
                }
                fsb.append(")");
                ret = fsb.toString();
                break;
            }
            case 1: {
                ret = "\"" + Helper.escapeActionScriptString(abc.constants.getString(this.value_index)) + "\"";
                break;
            }
            case 11: {
                ret = "true";
                break;
            }
            case 10: {
                ret = "false";
                break;
            }
            case 12: {
                ret = "null";
                break;
            }
            case 0: {
                ret = "undefined";
                break;
            }
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                ret = "\"" + abc.constants.getNamespace(this.value_index).getName(abc.constants).toRawString() + "\"";
            }
        }
        return ret;
    }

    public String toASMString(ABC abc) {
        String ret = "?";
        block0 : switch (this.value_kind) {
            case 3: {
                ret = "Integer(" + abc.constants.getInt(this.value_index) + ")";
                break;
            }
            case 4: {
                ret = "UInteger(" + abc.constants.getUInt(this.value_index) + ")";
                break;
            }
            case 6: {
                ret = "Double(" + EcmaScript.toString(abc.constants.getDouble(this.value_index)) + ")";
                break;
            }
            case 2: {
                if (abc.hasDecimalSupport()) {
                    ret = "Decimal(" + abc.constants.getDecimal(this.value_index) + ")";
                    break;
                }
                ret = "Float(" + EcmaScript.toString(abc.constants.getFloat(this.value_index)) + ")";
                break;
            }
            case 30: {
                Float4 f4 = abc.constants.getFloat4(this.value_index);
                ret = "Float4(" + EcmaScript.toString(Float.valueOf(f4.values[0])) + ", " + EcmaScript.toString(Float.valueOf(f4.values[1])) + ", " + EcmaScript.toString(Float.valueOf(f4.values[2])) + ", " + EcmaScript.toString(Float.valueOf(f4.values[3])) + ")";
                break;
            }
            case 1: {
                ret = "Utf8(\"" + Helper.escapePCodeString(abc.constants.getString(this.value_index)) + "\")";
                break;
            }
            case 11: {
                ret = "True()";
                break;
            }
            case 10: {
                ret = "False()";
                break;
            }
            case 12: {
                ret = "Null()";
                break;
            }
            case 0: {
                ret = "Undefined()";
                break;
            }
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                String nsVal = abc.constants.getNamespace(this.value_index).getKindStr() + "(\"" + abc.constants.getNamespace(this.value_index).getName(abc.constants).toRawString() + "\")";
                switch (this.value_kind) {
                    case 8: {
                        ret = "Namespace(" + nsVal + ")";
                        break block0;
                    }
                    case 23: {
                        ret = "PackageInternalNs(" + nsVal + ")";
                        break block0;
                    }
                    case 24: {
                        ret = "ProtectedNamespace(" + nsVal + ")";
                        break block0;
                    }
                    case 25: {
                        ret = "ExplicitNamespace(" + nsVal + ")";
                        break block0;
                    }
                    case 26: {
                        ret = "StaticProtectedNs(" + nsVal + ")";
                        break block0;
                    }
                    case 5: {
                        ret = "PrivateNamespace(" + nsVal + ")";
                    }
                }
            }
        }
        return ret;
    }
}

