/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types.traits;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.NewFunctionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.AssignedValue;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitWithSlot;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyParser;
import com.jpexs.decompiler.flash.exporters.script.DependencyType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TraitSlotConst
extends Trait
implements TraitWithSlot {
    public int slot_id;
    public int type_index;
    public int value_index;
    public int value_kind;

    @Override
    public void delete(ABC abc, boolean d) {
        super.delete(abc, d);
        abc.constants.getMultiname((int)this.name_index).deleted = d;
    }

    @Override
    public int getSlotIndex() {
        return this.slot_id;
    }

    public String getType(Set<String> usedDeobfuscations, ABC abc, AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        String typeStr = "*";
        if (this.type_index > 0) {
            typeStr = constants.getMultiname(this.type_index).getName(usedDeobfuscations, abc, constants, fullyQualifiedNames, false, true);
        }
        return typeStr;
    }

    public GraphTextWriter getNameStr(GraphTextWriter writer, ABC abc, List<DottedChain> fullyQualifiedNames, Set<String> usedDeobfuscations) {
        String typeStr = this.getType(usedDeobfuscations, abc, abc.constants, fullyQualifiedNames);
        ValueKind val = null;
        if (this.value_kind != 0) {
            val = new ValueKind(this.value_index, this.value_kind);
        }
        typeStr = ":" + typeStr;
        String slotconst = "var";
        if (this.kindType == 6) {
            slotconst = "const";
        }
        if (val != null && this.type_index == 0 && val.isNamespace()) {
            slotconst = "namespace";
            typeStr = "";
        }
        writer.hilightSpecial(slotconst + " ", HighlightSpecialType.TRAIT_TYPE);
        writer.hilightSpecial(this.getName(abc).getName(usedDeobfuscations, abc, abc.constants, new ArrayList<DottedChain>(), false, true), HighlightSpecialType.TRAIT_NAME);
        writer.hilightSpecial(typeStr, HighlightSpecialType.TRAIT_TYPE_NAME);
        return writer;
    }

    private boolean hasValueStr(ABC abc, ConvertData convertData) {
        if (convertData.assignedValues.containsKey(this)) {
            return true;
        }
        if (this.value_kind == 8 && abc.constants.getNamespace((int)this.value_index).kind == 23) {
            return false;
        }
        return this.value_kind != 0;
    }

    public void getValueStr(Set<String> usedDeobfuscations, int swfVersion, AbcIndexing abcIndex, ScriptExportMode exportMode, ConvertData convertData, GraphTextWriter writer, ABC abc, List<DottedChain> fullyQualifiedNames) throws InterruptedException {
        if (convertData.assignedValues.containsKey(this)) {
            AssignedValue assignment = convertData.assignedValues.get(this);
            writer.startTrait(assignment.initializer);
            writer.startMethod(assignment.method, null);
            if (Configuration.showMethodBodyId.get().booleanValue()) {
                writer.appendNoHilight("// method body index: ");
                writer.appendNoHilight(abc.findBodyIndex(assignment.method));
                writer.appendNoHilight(" method index: ");
                writer.appendNoHilight(assignment.method);
                writer.newLine();
            }
            if (exportMode != ScriptExportMode.AS_METHOD_STUBS) {
                ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                callStack.add(abc.bodies.get(abc.findBodyIndex(assignment.method)));
                assignment.value.toString(writer, LocalData.create(callStack, abcIndex, abc, new HashMap<Integer, String>(), fullyQualifiedNames, new HashSet<Integer>(), exportMode, swfVersion, usedDeobfuscations));
            }
            writer.endMethod();
            writer.endTrait();
            return;
        }
        if (this.value_kind != 0) {
            ValueKind val = new ValueKind(this.value_index, this.value_kind);
            writer.hilightSpecial(val.toString(abc), HighlightSpecialType.TRAIT_VALUE);
        }
    }

    public boolean isNamespace() {
        if (this.value_kind != 0) {
            ValueKind val = new ValueKind(this.value_index, this.value_kind);
            return val.isNamespace();
        }
        return false;
    }

    @Override
    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        String typeStr = "*";
        if (this.type_index > 0) {
            typeStr = abc.constants.getMultiname(this.type_index).toString(abc.constants, fullyQualifiedNames);
        }
        return "0x" + Helper.formatAddress(this.fileOffset) + " " + Helper.byteArrToString(this.bytes) + " SlotConst " + abc.constants.getMultiname(this.name_index).toString(abc.constants, fullyQualifiedNames) + " slot=" + this.slot_id + " type=" + typeStr + " value=" + new ValueKind(this.value_index, this.value_kind).toString(abc) + " metadata=" + Helper.intArrToString(this.metadata);
    }

    @Override
    public GraphTextWriter toString(Set<String> usedDeobfuscations, int swfVersion, AbcIndexing abcIndex, DottedChain packageName, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, boolean insideInterface) throws InterruptedException {
        GraphTargetItem val;
        this.getMetaData(usedDeobfuscations, this, convertData, abc, writer);
        Multiname n = this.getName(abc);
        boolean showModifier = true;
        if (classIndex == -1 && n != null) {
            Namespace ns = n.getNamespace(abc.constants);
            if (ns == null) {
                showModifier = false;
            } else if (ns.kind != 22 && ns.kind != 23) {
                showModifier = false;
            }
        }
        if (showModifier) {
            this.getModifiers(usedDeobfuscations, abc, isStatic, insideInterface, writer, classIndex);
        }
        if (convertData.assignedValues.containsKey(this) && (val = convertData.assignedValues.get((Object)this).value) instanceof NewFunctionAVM2Item) {
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
            AssignedValue assignment = convertData.assignedValues.get(this);
            callStack.add(abc.bodies.get(abc.findBodyIndex(assignment.method)));
            return val.toString(writer, LocalData.create(callStack, abcIndex, abc, new HashMap<Integer, String>(), fullyQualifiedNames, new HashSet<Integer>(), exportMode, swfVersion, usedDeobfuscations));
        }
        this.getNameStr(writer, abc, fullyQualifiedNames, usedDeobfuscations);
        if (this.hasValueStr(abc, convertData)) {
            writer.appendNoHilight(" = ");
            this.getValueStr(usedDeobfuscations, swfVersion, abcIndex, exportMode, convertData, writer, abc, fullyQualifiedNames);
        }
        return writer.appendNoHilight(";").newLine();
    }

    @Override
    public void convert(Set<String> usedDeobfuscations, int swfVersion, AbcIndexing abcIndex, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, ScopeStack scopeStack) throws InterruptedException {
        this.getNameStr(writer, abc, fullyQualifiedNames, usedDeobfuscations);
        if (this.hasValueStr(abc, convertData)) {
            this.getValueStr(usedDeobfuscations, swfVersion, abcIndex, exportMode, convertData, writer, abc, fullyQualifiedNames);
        }
    }

    public boolean isConst() {
        return this.kindType == 6;
    }

    public boolean isVar() {
        return this.kindType == 0;
    }

    @Override
    public int removeTraps(int scriptIndex, int classIndex, boolean isStatic, ABC abc, String path) {
        return 0;
    }

    @Override
    public TraitSlotConst clone() {
        TraitSlotConst ret = (TraitSlotConst)super.clone();
        return ret;
    }

    @Override
    public void getDependencies(Set<String> usedDeobfuscations, AbcIndexing abcIndex, int scriptIndex, int classIndex, boolean isStatic, String customNamespace, ABC abc, List<Dependency> dependencies, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, List<String> uses, Reference<Integer> numberContextRef) throws InterruptedException {
        if (ignorePackage == null) {
            ignorePackage = this.getPackage(abc);
        }
        super.getDependencies(usedDeobfuscations, abcIndex, scriptIndex, classIndex, isStatic, customNamespace, abc, dependencies, ignorePackage, fullyQualifiedNames, uses, numberContextRef);
        DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, customNamespace, abc, dependencies, abc.constants.getMultiname(this.type_index), this.getPackage(abc), fullyQualifiedNames, DependencyType.SIGNATURE, uses);
    }

    @Override
    public boolean isVisible(boolean isStatic, ABC abc) {
        return Configuration.handleSkinPartsAutomatically.get() == false || !isStatic || !"_skinParts".equals(this.getName(abc).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, true)) || this.kindType != 0 || !"_skinParts".equals(this.getName(abc).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, true)) || this.getName((ABC)abc).getNamespace((AVM2ConstantPool)abc.constants).kind != 5;
    }

    @Override
    public GraphTextWriter convertTraitHeader(ABC abc, GraphTextWriter writer) {
        this.convertCommonHeaderFlags(this.isConst() ? "const" : "slot", abc, writer);
        writer.newLine();
        writer.appendNoHilight("slotid ");
        writer.hilightSpecial(Integer.toString(this.slot_id), HighlightSpecialType.SLOT_ID);
        writer.newLine();
        writer.appendNoHilight("type ");
        writer.hilightSpecial(abc.constants.multinameToString(this.type_index), HighlightSpecialType.TRAIT_TYPE_NAME);
        writer.newLine();
        if (this.value_kind != 0) {
            writer.appendNoHilight("value ");
            writer.hilightSpecial(new ValueKind(this.value_index, this.value_kind).toASMString(abc), HighlightSpecialType.TRAIT_VALUE);
            writer.newLine();
        }
        return writer;
    }

    @Override
    public void getMethodInfos(ABC abc, int traitId, int classIndex, List<MethodId> methodInfos) {
    }
}

