/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.InitArrayActionItem;
import com.jpexs.decompiler.flash.action.model.InitObjectActionItem;
import com.jpexs.decompiler.flash.ecma.ArrayType;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.TrueItem;
import java.util.ArrayList;

public class ActionGraphTargetDialect
extends GraphTargetDialect {
    public static final GraphTargetDialect INSTANCE = new ActionGraphTargetDialect();

    private ActionGraphTargetDialect() {
    }

    @Override
    public String getName() {
        return "Action";
    }

    @Override
    public GraphTargetItem valToItem(Object r) {
        if (r == null) {
            return null;
        }
        if (r instanceof Boolean) {
            if (((Boolean)r).booleanValue()) {
                return new TrueItem(this, null, null);
            }
            return new FalseItem(this, null, null);
        }
        if (r instanceof String) {
            return new DirectValueActionItem((String)r);
        }
        if (r instanceof Long) {
            return new DirectValueActionItem((Long)r);
        }
        if (r instanceof Integer) {
            return new DirectValueActionItem((Integer)r);
        }
        if (r instanceof Short) {
            return new DirectValueActionItem((Short)r);
        }
        if (r instanceof Byte) {
            return new DirectValueActionItem((Byte)r);
        }
        if (r instanceof Double) {
            return new DirectValueActionItem((Double)r);
        }
        if (r instanceof Null) {
            return new DirectValueActionItem(Null.INSTANCE);
        }
        if (r instanceof Undefined) {
            return new DirectValueActionItem(Undefined.INSTANCE);
        }
        if (r instanceof ArrayType) {
            ArrayList<GraphTargetItem> vals = new ArrayList<GraphTargetItem>();
            ArrayType at = (ArrayType)r;
            for (Object v : at.values) {
                vals.add(this.valToItem(v));
            }
            return new InitArrayActionItem(null, null, vals);
        }
        if (r instanceof ObjectType) {
            ArrayList<GraphTargetItem> names = new ArrayList<GraphTargetItem>();
            ArrayList<GraphTargetItem> vals = new ArrayList<GraphTargetItem>();
            ObjectType ot = (ObjectType)r;
            for (String k : ot.getAttributeNames()) {
                names.add(this.valToItem(k));
                vals.add(this.valToItem(ot.getAttribute(k)));
            }
            return new InitObjectActionItem(null, null, names, vals);
        }
        return null;
    }

    @Override
    public boolean doesAllowMultilevelBreaks() {
        return false;
    }

    @Override
    public GraphTextWriter writeTemporaryDeclaration(GraphTextWriter writer, LocalData localData, String suffix, int tempIndex, GraphTargetItem value) throws InterruptedException {
        writer.append("var ");
        writer.append("_temp");
        writer.append(suffix);
        writer.append("_").append(tempIndex);
        if (value != null) {
            writer.append(" = ");
            value.appendTry(writer, localData);
        }
        return writer;
    }
}

