/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.as2;

import com.jpexs.decompiler.flash.action.as2.Method;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.as2.Variable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionScript2Classes {
    private static final Map<String, Map<String, Trait>> classToTraits = new HashMap<String, Map<String, Trait>>();
    private static final Map<String, List<String>> classInheritance = new HashMap<String, List<String>>();
    private static boolean inited = false;

    private ActionScript2Classes() {
    }

    private static synchronized void initClasses() {
        if (inited) {
            return;
        }
        InputStream is = ActionScript2Classes.class.getResourceAsStream("/com/jpexs/decompiler/flash/action/as2/as2_classes.txt");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String clsName = "";
            while ((line = br.readLine()) != null) {
                Trait trait;
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(" ");
                if (parts[0].equals("class")) {
                    clsName = parts[1];
                    classToTraits.put(clsName, new TreeMap());
                    continue;
                }
                boolean isStatic = false;
                int pos = 0;
                if (parts[pos].equals("static")) {
                    isStatic = true;
                    ++pos;
                }
                if (parts[pos].equals("extends")) {
                    if (!classInheritance.containsKey(clsName)) {
                        classInheritance.put(clsName, new ArrayList());
                    }
                    classInheritance.get(clsName).add(parts[pos + 1]);
                    continue;
                }
                String traitType = parts[pos];
                String name = parts[pos + 1];
                String type = parts[pos + 2];
                switch (traitType) {
                    case "function": {
                        trait = new Method(isStatic, name, type, clsName);
                        break;
                    }
                    case "var": {
                        trait = new Variable(isStatic, name, type, clsName);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown trait type: " + traitType);
                    }
                }
                classToTraits.get(clsName).put(name, trait);
            }
        }
        catch (UnsupportedEncodingException br) {
        }
        catch (IOException ex) {
            Logger.getLogger(ActionScript2Classes.class.getName()).log(Level.SEVERE, null, ex);
        }
        inited = true;
    }

    public static boolean traitExists(String className, String name, boolean withInheritance) {
        if (!classToTraits.containsKey(className)) {
            return false;
        }
        if (classToTraits.get(className).containsKey(name)) {
            return true;
        }
        if (withInheritance && classInheritance.containsKey(className)) {
            for (String parentClassName : classInheritance.get(className)) {
                if (!classToTraits.containsKey(parentClassName) || !classToTraits.get(parentClassName).containsKey(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Trait> getClassTraits(String className, boolean withInheritance) {
        ActionScript2Classes.initClasses();
        LinkedHashMap<String, Trait> result = new LinkedHashMap<String, Trait>();
        if (!classToTraits.containsKey(className)) {
            return null;
        }
        for (String name : classToTraits.get(className).keySet()) {
            result.put(name, classToTraits.get(className).get(name));
        }
        if (withInheritance && classInheritance.containsKey(className)) {
            for (String parentClassName : classInheritance.get(className)) {
                if (!classToTraits.containsKey(parentClassName)) continue;
                for (String name : classToTraits.get(parentClassName).keySet()) {
                    if (result.containsKey(name)) continue;
                    result.put(name, classToTraits.get(parentClassName).get(name));
                }
            }
        }
        return result;
    }

    public static Map<String, Map<String, Trait>> getClassToTraits() {
        ActionScript2Classes.initClasses();
        return classToTraits;
    }

    public static Map<String, List<String>> getClassInheritance() {
        ActionScript2Classes.initClasses();
        return classInheritance;
    }

    public static void main(String[] args) {
        Map<String, Trait> traits = ActionScript2Classes.getClassTraits("flash.filters.BevelFilter", true);
        if (traits != null) {
            for (String name : traits.keySet()) {
                Trait t = traits.get(name);
                System.out.println(t.toString() + " (" + t.getClassName() + ")");
            }
        }
        System.out.println("trait exists: " + ActionScript2Classes.traitExists("flash.filters.BevelFilter", "quality", false));
    }
}

