/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.fastactionlist;

import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.fastactionlist.ActionItem;
import com.jpexs.decompiler.flash.action.fastactionlist.FastActionList;
import java.util.Iterator;

public final class FastActionListIterator
implements Iterator<ActionItem> {
    private ActionItem item;
    private final FastActionList list;
    private boolean started = false;

    FastActionListIterator(FastActionList list) {
        this.item = list.first();
        this.list = list;
    }

    FastActionListIterator(FastActionList list, int index) {
        this.item = list.first();
        this.list = list;
        for (int i = 0; i < index; ++i) {
            if (!this.hasNext()) {
                throw new Error("Invalid index");
            }
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.item != null && (!this.started || this.item != this.list.first());
    }

    @Override
    public ActionItem next() {
        ActionItem result = this.item;
        this.item = this.item.next;
        this.started = true;
        return result;
    }

    public ActionItem prev() {
        this.item = this.item.prev;
        if (this.item == this.list.first()) {
            this.started = false;
        }
        return this.item;
    }

    public void setCurrent(ActionItem item) {
        this.item = item;
        if (item == this.list.first()) {
            this.started = false;
        }
    }

    @Override
    public void remove() {
        this.item = this.list.removeItem(this.item.prev);
    }

    public void add(Action action) {
        this.item = this.list.insertItemAfter((ActionItem)this.item.prev, (Action)action).next;
    }

    public void add(ActionItem actionItem) {
        this.item = this.list.insertItemAfter((ActionItem)this.item.prev, (ActionItem)actionItem).next;
    }

    public void addBefore(ActionItem actionItem) {
        this.list.insertItemBefore(this.item.prev, actionItem);
    }

    public ActionItem peek(int index) {
        ActionItem item = this.item;
        for (int i = 0; i < index && item != null; ++i) {
            item = item.next;
        }
        return item;
    }
}

