/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionCallMethod;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class CallMethodActionItem
extends ActionItem {
    public GraphTargetItem methodName;
    public GraphTargetItem scriptObject;
    public List<GraphTargetItem> arguments;
    public static int SPECIAL_GETTER = 1;
    public static int SPECIAL_SETTER = 2;
    private int special = 0;
    private String setterGetterVarName = null;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.arguments);
        visitor.visit(this.scriptObject);
    }

    public CallMethodActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scriptObject, GraphTargetItem methodName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        DirectValueActionItem dv;
        this.methodName = methodName;
        this.arguments = arguments;
        this.scriptObject = scriptObject;
        if (methodName instanceof DirectValueActionItem && (dv = (DirectValueActionItem)methodName).isString()) {
            String methodNameStr = dv.getAsString();
            if (methodNameStr.startsWith("__get__") && arguments.isEmpty()) {
                this.special = SPECIAL_GETTER;
                this.setterGetterVarName = methodNameStr.substring(7);
            } else if (methodNameStr.startsWith("__set__") && arguments.size() == 1) {
                this.special = SPECIAL_SETTER;
                this.setterGetterVarName = methodNameStr.substring(7);
                this.precedence = 15;
            }
        }
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.special == SPECIAL_GETTER) {
            if (this.scriptObject.getPrecedence() > this.precedence) {
                writer.append("(");
                this.scriptObject.toString(writer, localData);
                writer.append(")");
            } else {
                this.scriptObject.toString(writer, localData);
            }
            writer.allowWrapHere().append(".");
            writer.append(this.setterGetterVarName);
            return writer;
        }
        if (this.special == SPECIAL_SETTER) {
            if (this.scriptObject.getPrecedence() > this.precedence) {
                writer.append("(");
                this.scriptObject.toString(writer, localData);
                writer.append(")");
            } else {
                this.scriptObject.toString(writer, localData);
            }
            writer.allowWrapHere().append(".");
            writer.append(this.setterGetterVarName);
            writer.append(" = ");
            this.arguments.get(0).toStringNL(writer, localData);
            return writer;
        }
        if (this.methodName instanceof DirectValueActionItem) {
            boolean blankMethod = false;
            if (((DirectValueActionItem)this.methodName).value == Undefined.INSTANCE) {
                blankMethod = true;
            }
            if (((DirectValueActionItem)this.methodName).value instanceof String && ((DirectValueActionItem)this.methodName).value.equals("")) {
                blankMethod = true;
            }
            if (!blankMethod) {
                if (this.scriptObject.getPrecedence() > this.precedence || this.scriptObject instanceof DirectValueActionItem && ((DirectValueActionItem)this.scriptObject).value instanceof Long) {
                    writer.append("(");
                    this.scriptObject.toString(writer, localData);
                    writer.append(")");
                } else {
                    this.scriptObject.toString(writer, localData);
                }
                if (!(((DirectValueActionItem)this.methodName).value instanceof RegisterNumber) && IdentifiersDeobfuscation.isValidName(false, this.methodName.toStringNoQuotes(localData), new String[0])) {
                    writer.allowWrapHere().append(".");
                    this.methodName.toStringNoQuotes(writer, localData);
                } else {
                    writer.append("[");
                    this.methodName.toString(writer, localData);
                    writer.append("]");
                }
            } else {
                this.scriptObject.toString(writer, localData);
            }
        } else {
            if (this.scriptObject.getPrecedence() > this.precedence) {
                writer.append("(");
                this.scriptObject.toString(writer, localData);
                writer.append(")");
            } else {
                this.scriptObject.toString(writer, localData);
            }
            writer.append("[");
            this.methodName.appendTry(writer, localData);
            writer.append("]");
        }
        writer.spaceBeforeCallParenthesis(this.arguments.size());
        writer.append("(");
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                writer.allowWrapHere().append(",");
            }
            this.arguments.get(t).toStringNL(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.methodName.getNeededSources());
        ret.addAll(this.scriptObject.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return CallMethodActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.scriptObject, this.methodName, new ActionCallMethod());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.methodName);
        hash = 79 * hash + Objects.hashCode(this.scriptObject);
        hash = 79 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallMethodActionItem other = (CallMethodActionItem)obj;
        if (!Objects.equals(this.methodName, other.methodName)) {
            return false;
        }
        if (!Objects.equals(this.scriptObject, other.scriptObject)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallMethodActionItem other = (CallMethodActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.methodName, other.methodName)) {
            return false;
        }
        if (!GraphTargetItem.objectsValueEquals(this.scriptObject, other.scriptObject)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

