/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionCloneSprite;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class CloneSpriteActionItem
extends ActionItem {
    public GraphTargetItem source;
    public GraphTargetItem target;
    public GraphTargetItem depth;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.source);
        visitor.visit(this.target);
        visitor.visit(this.depth);
    }

    public CloneSpriteActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem source, GraphTargetItem target, GraphTargetItem depth) {
        super(instruction, lineStartIns, 0);
        this.source = source;
        this.target = target;
        this.depth = depth;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("duplicateMovieClip");
        writer.spaceBeforeCallParenthesis(3);
        writer.append("(");
        this.target.toString(writer, localData);
        writer.append(",");
        this.source.toString(writer, localData);
        writer.append(",");
        this.depth.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.source.getNeededSources());
        ret.addAll(this.target.getNeededSources());
        ret.addAll(this.depth.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        return CloneSpriteActionItem.toSourceMerge(localData, generator, this.source, this.target, this.depth, new ActionCloneSprite(), new ActionPush(new Object[]{Undefined.INSTANCE, Undefined.INSTANCE}, charset));
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return CloneSpriteActionItem.toSourceMerge(localData, generator, this.source, this.target, this.depth, new ActionCloneSprite());
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.source);
        hash = 17 * hash + Objects.hashCode(this.target);
        hash = 17 * hash + Objects.hashCode(this.depth);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloneSpriteActionItem other = (CloneSpriteActionItem)obj;
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        if (!Objects.equals(this.target, other.target)) {
            return false;
        }
        return Objects.equals(this.depth, other.depth);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloneSpriteActionItem other = (CloneSpriteActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.source, other.source)) {
            return false;
        }
        if (!GraphTargetItem.objectsValueEquals(this.target, other.target)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.depth, other.depth);
    }
}

