/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionNewMethod;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class NewMethodActionItem
extends ActionItem {
    public GraphTargetItem methodName;
    public GraphTargetItem scriptObject;
    public List<GraphTargetItem> arguments;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.scriptObject);
        visitor.visitAll(this.arguments);
    }

    public NewMethodActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scriptObject, GraphTargetItem methodName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.methodName = methodName;
        this.arguments = arguments;
        this.scriptObject = scriptObject;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean blankMethod = false;
        if (this.methodName instanceof DirectValueActionItem) {
            if (((DirectValueActionItem)this.methodName).value == Undefined.INSTANCE) {
                blankMethod = true;
            } else if (((DirectValueActionItem)this.methodName).value instanceof String && ((DirectValueActionItem)this.methodName).value.equals("")) {
                blankMethod = true;
            }
        }
        writer.append("new ");
        this.scriptObject.toString(writer, localData);
        if (!blankMethod) {
            if (this.methodName instanceof DirectValueActionItem) {
                if (((DirectValueActionItem)this.methodName).value != Undefined.INSTANCE) {
                    if (((DirectValueActionItem)this.methodName).value instanceof String && IdentifiersDeobfuscation.isValidName(false, (String)((DirectValueActionItem)this.methodName).value, new String[0])) {
                        writer.append(".");
                        ((DirectValueActionItem)this.methodName).toStringNoQuotes(writer, localData);
                    } else {
                        writer.append("[");
                        this.methodName.toString(writer, localData);
                        writer.append("]");
                    }
                }
            } else {
                writer.append("[");
                this.methodName.toString(writer, localData);
                writer.append("]");
            }
        }
        writer.spaceBeforeCallParenthesis(this.arguments.size());
        writer.append("(");
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                writer.append(",");
            }
            this.arguments.get(t).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.methodName.getNeededSources());
        ret.addAll(this.scriptObject.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return NewMethodActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.scriptObject, this.methodName, new ActionNewMethod());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.methodName);
        hash = 47 * hash + Objects.hashCode(this.scriptObject);
        hash = 47 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewMethodActionItem other = (NewMethodActionItem)obj;
        if (!Objects.equals(this.methodName, other.methodName)) {
            return false;
        }
        if (!Objects.equals(this.scriptObject, other.scriptObject)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewMethodActionItem other = (NewMethodActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.methodName, other.methodName)) {
            return false;
        }
        if (!GraphTargetItem.objectsValueEquals(this.scriptObject, other.scriptObject)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

