/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionSetVariable;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SetVariableActionItem
extends ActionItem
implements SetTypeActionItem {
    public GraphTargetItem name;
    private int tempRegister = -1;
    public GraphTargetItem compoundValue;
    public String compoundOperator;
    public boolean forceUseSet = false;

    @Override
    public GraphPart getFirstPart() {
        return this.value.getFirstPart();
    }

    @Override
    public void setValue(GraphTargetItem value) {
        this.value = value;
    }

    @Override
    public int getTempRegister() {
        return this.tempRegister;
    }

    @Override
    public void setTempRegister(int tempRegister) {
        this.tempRegister = tempRegister;
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    public SetVariableActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem name, GraphTargetItem value) {
        super(instruction, lineStartIns, 15, value);
        this.name = name;
    }

    private boolean resultNeeded() {
        boolean needsTempRegister = false;
        if (this.value instanceof StoreRegisterActionItem) {
            StoreRegisterActionItem sr = (StoreRegisterActionItem)this.value;
            if (sr.temporary) {
                needsTempRegister = true;
            }
        }
        return needsTempRegister;
    }

    private boolean isValidName(LocalData localData) {
        return this.name instanceof DirectValueActionItem && ((DirectValueActionItem)this.name).isString() && IdentifiersDeobfuscation.isValidName(false, ((DirectValueActionItem)this.name).toStringNoQuotes(localData), "this", "super");
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.isValidName(localData) || this.resultNeeded()) {
            HighlightData srcData = this.getSrcData();
            srcData.localName = this.name.toStringNoQuotes(localData);
            writer.append(IdentifiersDeobfuscation.printIdentifier(localData.swf, localData.usedDeobfuscations, false, this.name.toStringNoQuotes(localData), new String[0]));
            if (this.compoundOperator != null) {
                writer.append(" ");
                writer.append(this.compoundOperator);
                writer.append("= ");
                return this.compoundValue.toString(writer, localData);
            }
            writer.append(" = ");
            return this.value.toString(writer, localData);
        }
        writer.append("set");
        writer.spaceBeforeCallParenthesis(2);
        writer.append("(");
        this.name.toString(writer, localData);
        writer.append(",");
        this.value.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public GraphTargetItem getObject() {
        return new GetVariableActionItem(this.getSrc(), this.getLineStartItem(), this.name);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.name.getNeededSources());
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        if (!(this.value instanceof SimpleValue) || !((SimpleValue)((Object)this.value)).isSimpleValue()) {
            dependencies.add(this.value);
        }
        return this.value.isCompileTime(dependencies);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        if (this.forceUseSet) {
            return SetVariableActionItem.toSourceMerge(localData, generator, this.name, this.value, new ActionSetVariable(), new ActionPush(Undefined.INSTANCE, charset));
        }
        int tmpReg = asGenerator.getTempRegister(localData);
        try {
            List<GraphSourceItem> list = SetVariableActionItem.toSourceMerge(localData, generator, this.name, this.value, new ActionStoreRegister(tmpReg, charset), new ActionSetVariable(), new ActionPush(new RegisterNumber(tmpReg), charset));
            return list;
        }
        finally {
            asGenerator.releaseTempRegister(localData, tmpReg);
        }
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return SetVariableActionItem.toSourceMerge(localData, generator, this.name, this.value, new ActionSetVariable());
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetVariableActionItem other = (SetVariableActionItem)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetVariableActionItem other = (SetVariableActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.name, other.name)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.value, other.value);
    }

    @Override
    public GraphTargetItem getCompoundValue() {
        return this.compoundValue;
    }

    @Override
    public void setCompoundValue(GraphTargetItem value) {
        this.compoundValue = value;
    }

    @Override
    public void setCompoundOperator(String operator) {
        this.compoundOperator = operator;
    }

    @Override
    public String getCompoundOperator() {
        return this.compoundOperator;
    }
}

