/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.LoopActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.LoopWithType;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class ForInActionItem
extends LoopActionItem
implements Block {
    public GraphTargetItem variableName;
    public GraphTargetItem enumVariable;
    public List<GraphTargetItem> commands;
    private boolean labelUsed;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.commands != null) {
            ret.add(this.commands);
        }
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.variableName);
        visitor.visit(this.enumVariable);
        visitor.visitAll(this.commands);
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.variableName);
        visitor.visit(this.enumVariable);
    }

    public ForInActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, Loop loop, GraphTargetItem variableName, GraphTargetItem enumVariable, List<GraphTargetItem> commands) {
        super(instruction, lineStartIns, loop);
        this.variableName = variableName;
        this.enumVariable = enumVariable;
        this.commands = commands;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (writer instanceof NulWriter) {
            ((NulWriter)writer).startLoop(this.loop.id, LoopWithType.LOOP_TYPE_LOOP);
        }
        if (this.labelUsed) {
            writer.append("loop").append(this.loop.id).append(":").newLine();
        }
        writer.append("for");
        if (writer.getFormatting().spaceBeforeParenthesesForParentheses) {
            writer.append(" ");
        }
        writer.append("(");
        if (this.variableName instanceof SetTypeActionItem) {
            GraphTargetItem vn = ((SetTypeActionItem)((Object)this.variableName)).getObject();
            if (this.variableName instanceof StoreRegisterActionItem && ((StoreRegisterActionItem)this.variableName).define) {
                writer.append("var ");
            }
            if (vn instanceof GetVariableActionItem) {
                ((GetVariableActionItem)vn).printObfuscatedName = true;
            }
            this.stripQuotes(vn, localData, writer);
        }
        writer.append(" in ");
        if (this.enumVariable.getPrecedence() > 0) {
            writer.append("(");
        }
        this.enumVariable.toString(writer, localData);
        if (this.enumVariable.getPrecedence() > 0) {
            writer.append(")");
        }
        writer.append(")").startBlock();
        for (GraphTargetItem ti : this.commands) {
            ti.toStringSemicoloned(writer, localData).newLine();
        }
        writer.endBlock();
        if (writer instanceof NulWriter) {
            LoopWithType loopOjb = ((NulWriter)writer).endLoop(this.loop.id);
            this.labelUsed = loopOjb.used;
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem ti : this.commands) {
            if (ti instanceof ContinueItem) {
                ret.add((ContinueItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }

    @Override
    public List<BreakItem> getBreaks() {
        ArrayList<BreakItem> ret = new ArrayList<BreakItem>();
        for (GraphTargetItem ti : this.commands) {
            if (ti instanceof BreakItem) {
                ret.add((BreakItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getBreaks());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return ((ActionSourceGenerator)generator).generate(localData, this);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

