/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.parser.script;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.script.ActionScriptLexer;
import com.jpexs.decompiler.flash.action.parser.script.LexBufferer;
import com.jpexs.decompiler.flash.action.parser.script.ParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.script.SymbolGroup;
import com.jpexs.decompiler.flash.action.parser.script.SymbolType;
import com.jpexs.decompiler.flash.simpleparser.CatchScope;
import com.jpexs.decompiler.flash.simpleparser.ClassScope;
import com.jpexs.decompiler.flash.simpleparser.FunctionScope;
import com.jpexs.decompiler.flash.simpleparser.LinkHandler;
import com.jpexs.decompiler.flash.simpleparser.MethodScope;
import com.jpexs.decompiler.flash.simpleparser.Path;
import com.jpexs.decompiler.flash.simpleparser.SimpleParseException;
import com.jpexs.decompiler.flash.simpleparser.SimpleParser;
import com.jpexs.decompiler.flash.simpleparser.TraitVarConstValueScope;
import com.jpexs.decompiler.flash.simpleparser.Type;
import com.jpexs.decompiler.flash.simpleparser.Variable;
import com.jpexs.decompiler.flash.simpleparser.VariableOrScope;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Reference;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ActionScript2SimpleParser
implements SimpleParser {
    private final int swfVersion;
    private final boolean debugMode = false;
    private static final String[] operatorIdentifiers = new String[]{"add", "eq", "ne", "lt", "ge", "gt", "le"};
    private ActionScriptLexer lexer = null;

    public ActionScript2SimpleParser(SWF swf) {
        this.swfVersion = swf.version;
    }

    private void commands(List<SimpleParseException> errors, boolean inWith, boolean inFunction, boolean inMethod, int forinlevel, boolean inTellTarget, List<VariableOrScope> variables, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        while (this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval)) {
        }
    }

    private Path type(List<SimpleParseException> errors, boolean definition, List<VariableOrScope> variables) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol s = this.lex();
        if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0])) {
            return null;
        }
        ParsedSymbol lastIdent = s;
        Variable vret = new Variable(false, new Path(s.value.toString()), s.position);
        variables.add(vret);
        Path ret = new Path(s.value.toString());
        s = this.lex();
        while (s.type == SymbolType.DOT) {
            s = this.lex();
            if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0])) {
                return null;
            }
            lastIdent = s;
            ret = ret.add(s.value.toString());
            s = this.lex();
        }
        this.lexer.pushback(s);
        Type t = new Type(definition, ret, lastIdent.position);
        variables.add(t);
        return ret;
    }

    private boolean expected(List<SimpleParseException> errors, ParsedSymbol symb, int line, Object ... expected) throws IOException {
        boolean found = false;
        for (Object t : expected) {
            if (symb.type == t) {
                found = true;
            }
            if (symb.group != t) continue;
            found = true;
        }
        if (!found) {
            String expStr = "";
            boolean first = true;
            for (Object e : expected) {
                if (!first) {
                    expStr = expStr + " or ";
                }
                expStr = expStr + e;
                first = false;
            }
            errors.add(new SimpleParseException("" + expStr + " expected but " + (Object)((Object)symb.type) + " found", line, symb.position));
            return false;
        }
        return true;
    }

    private ParsedSymbol expectedType(List<SimpleParseException> errors, Object ... type) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol symb = this.lex();
        if (!this.expected(errors, symb, this.lexer.yyline(), type)) {
            return null;
        }
        return symb;
    }

    private ParsedSymbol lex() throws IOException, InterruptedException, SimpleParseException, ActionParseException, ActionParseException {
        if (CancellableWorker.isInterrupted()) {
            throw new InterruptedException();
        }
        ParsedSymbol ret = this.lexer.lex();
        return ret;
    }

    private List<GraphTargetItem> call(List<SimpleParseException> errors, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, List<VariableOrScope> variables, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ParsedSymbol s = this.lex();
        while (s.type != SymbolType.PARENT_CLOSE) {
            if (s.type != SymbolType.COMMA) {
                this.lexer.pushback(s);
            }
            this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
            s = this.lex();
            if (this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.COMMA, SymbolType.PARENT_CLOSE})) continue;
            break;
        }
        return ret;
    }

    private FunctionScope function(List<SimpleParseException> errors, boolean withBody, Path functionName, int functionNamePosition, boolean isMethod, List<VariableOrScope> variables, boolean inTellTarget, Reference<Boolean> hasEval, boolean isStatic) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol s = this.lex();
        int scopePos = s.position;
        this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.PARENT_OPEN});
        s = this.lex();
        ArrayList<Path> paramNames = new ArrayList<Path>();
        ArrayList<Integer> paramPositions = new ArrayList<Integer>();
        while (s.type != SymbolType.PARENT_CLOSE) {
            if (s.type != SymbolType.COMMA) {
                this.lexer.pushback(s);
            }
            if (!this.expectedIdentifier(errors, s = this.lex(), this.lexer.yyline(), new Object[0])) break;
            paramNames.add(new Path(s.value.toString()));
            paramPositions.add(s.position);
            s = this.lex();
            if (s.type == SymbolType.COLON) {
                this.type(errors, false, variables);
                s = this.lex();
            }
            if (s.isType(new Object[]{SymbolType.COMMA, SymbolType.PARENT_CLOSE}) || this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.COMMA, SymbolType.PARENT_CLOSE})) continue;
        }
        int scopeEndPos = s.position;
        ArrayList<VariableOrScope> subvariables = new ArrayList<VariableOrScope>();
        Reference<Boolean> subHasEval = new Reference<Boolean>(false);
        if (!isMethod && !functionName.isEmpty()) {
            variables.add(0, new Variable(true, functionName, functionNamePosition));
        }
        for (int i = 0; i < paramNames.size(); ++i) {
            subvariables.add(new Variable(true, (Path)paramNames.get(i), (Integer)paramPositions.get(i)));
        }
        if (withBody) {
            this.expectedType(errors, new Object[]{SymbolType.CURLY_OPEN});
            this.commands(errors, false, true, isMethod, 0, inTellTarget, subvariables, subHasEval);
            s = this.lex();
            this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.CURLY_CLOSE});
            scopeEndPos = s.position;
        }
        if (subHasEval.getVal().booleanValue()) {
            hasEval.setVal(true);
        }
        if (isMethod) {
            return new MethodScope(scopePos, scopeEndPos, subvariables, isStatic);
        }
        return new FunctionScope(scopePos, scopeEndPos, subvariables, isStatic);
    }

    private boolean traits(List<SimpleParseException> errors, boolean isInterface, Path className, List<VariableOrScope> variables, boolean inTellTarget, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ArrayList<VariableOrScope> traitVariables = new ArrayList<VariableOrScope>();
        block4: while (true) {
            boolean isStatic = false;
            ParsedSymbol s = this.lex();
            int staticPos = -1;
            while (s.isType(new Object[]{SymbolType.STATIC, SymbolType.PUBLIC, SymbolType.PRIVATE})) {
                if (s.type == SymbolType.STATIC) {
                    isStatic = true;
                    staticPos = s.position;
                }
                s = this.lex();
            }
            switch (s.type) {
                case FUNCTION: {
                    s = this.lex();
                    if (s.type == SymbolType.SET) {
                        s = this.lex();
                    } else if (s.type == SymbolType.GET) {
                        s = this.lex();
                    }
                    if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0])) continue block4;
                    Path simpleClassName = className.getLast();
                    if (!simpleClassName.equals(new Path(s.value.toString()))) {
                        traitVariables.add(new Variable(true, isStatic ? className.add(s.value.toString()) : new Path("this", s.value.toString()), s.position, isStatic));
                    } else if (isStatic) {
                        errors.add(new SimpleParseException("Constructor cannot be static", this.lexer.yyline(), staticPos));
                    }
                    if (isInterface) continue block4;
                    variables.add(this.function(errors, !isInterface, isStatic ? className.add(s.value.toString()) : new Path("this", s.value.toString()), isStatic ? -1 : s.position, true, traitVariables, inTellTarget, hasEval, isStatic));
                    break;
                }
                case VAR: {
                    s = this.lex();
                    if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0])) continue block4;
                    traitVariables.add(new Variable(true, isStatic ? className.add(s.value.toString()) : new Path("this").add(s.value.toString()), s.position, isStatic));
                    s = this.lex();
                    if (s.type == SymbolType.COLON) {
                        this.type(errors, false, variables);
                        s = this.lex();
                    }
                    if (s.type == SymbolType.ASSIGN) {
                        int scopePos = s.position;
                        ArrayList<VariableOrScope> subVariables = new ArrayList<VariableOrScope>();
                        this.expression(errors, false, false, false, false, true, subVariables, false, hasEval);
                        s = this.lex();
                        variables.add(new TraitVarConstValueScope(scopePos, s.position, subVariables, isStatic));
                    }
                    if (s.type == SymbolType.SEMICOLON) continue block4;
                    this.lexer.pushback(s);
                    break;
                }
                default: {
                    this.lexer.pushback(s);
                    break block4;
                }
            }
        }
        variables.addAll(0, traitVariables);
        return true;
    }

    private boolean expressionCommands(List<SimpleParseException> errors, ParsedSymbol s, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, List<VariableOrScope> variables, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        boolean ret;
        switch (s.type) {
            case DUPLICATEMOVIECLIP: 
            case FSCOMMAND: 
            case FSCOMMAND2: 
            case SET: 
            case TRACE: 
            case GETURL: 
            case GOTOANDSTOP: 
            case GOTOANDPLAY: 
            case NEXTFRAME: 
            case PLAY: 
            case PREVFRAME: 
            case STOP: 
            case STOPALLSOUNDS: 
            case TOGGLEHIGHQUALITY: 
            case STOPDRAG: 
            case UNLOADMOVIE: 
            case UNLOADMOVIENUM: 
            case PRINT: 
            case PRINTASBITMAP: 
            case PRINTASBITMAPNUM: 
            case PRINTNUM: 
            case LOADVARIABLES: 
            case LOADMOVIE: 
            case LOADVARIABLESNUM: 
            case LOADMOVIENUM: 
            case REMOVEMOVIECLIP: 
            case STARTDRAG: 
            case CALL: 
            case GETVERSION: 
            case MBORD: 
            case MBCHR: 
            case MBLENGTH: 
            case MBSUBSTRING: 
            case SUBSTRING: 
            case LENGTH: 
            case RANDOM: 
            case INT: 
            case NUMBER_OP: 
            case STRING_OP: 
            case ORD: 
            case CHR: 
            case GETTIMER: 
            case TARGETPATH: {
                variables.add(new Variable(false, new Path("" + s.value), s.position));
            }
        }
        switch (s.type) {
            case DUPLICATEMOVIECLIP: 
            case GETURL: 
            case GOTOANDSTOP: 
            case GOTOANDPLAY: 
            case NEXTFRAME: 
            case PLAY: 
            case PREVFRAME: 
            case STOP: 
            case UNLOADMOVIE: 
            case UNLOADMOVIENUM: 
            case LOADVARIABLES: 
            case LOADMOVIE: 
            case LOADVARIABLESNUM: 
            case LOADMOVIENUM: 
            case REMOVEMOVIECLIP: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.call(errors, inWith, inFunction, inMethod, inTellTarget, variables, hasEval);
                return true;
            }
        }
        switch (s.type) {
            case DUPLICATEMOVIECLIP: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case FSCOMMAND: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                if (s.isType(new Object[]{SymbolType.COMMA})) {
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                } else {
                    this.lexer.pushback(s);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case FSCOMMAND2: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                while (s.isType(new Object[]{SymbolType.COMMA})) {
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                    s = this.lex();
                }
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case SET: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                hasEval.setVal(true);
                ret = true;
                break;
            }
            case TRACE: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case GETURL: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.PARENT_CLOSE, SymbolType.COMMA});
                if (s.type == SymbolType.COMMA) {
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                    s = this.lex();
                    if (s.type == SymbolType.COMMA) {
                        s = this.lex();
                        this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.STRING});
                        if (!s.value.equals("GET") && !s.value.equals("POST")) {
                            errors.add(new SimpleParseException("Invalid method, \"GET\" or \"POST\" expected.", this.lexer.yyline(), s.position));
                        }
                    } else {
                        this.lexer.pushback(s);
                    }
                } else {
                    this.lexer.pushback(s);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case GOTOANDSTOP: 
            case GOTOANDPLAY: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                if (s.type == SymbolType.COMMA) {
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                } else {
                    this.lexer.pushback(s);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case NEXTFRAME: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case PLAY: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case PREVFRAME: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case STOP: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case STOPALLSOUNDS: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case TOGGLEHIGHQUALITY: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case STOPDRAG: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case UNLOADMOVIE: 
            case UNLOADMOVIENUM: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case PRINT: 
            case PRINTASBITMAP: 
            case PRINTASBITMAPNUM: 
            case PRINTNUM: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case LOADVARIABLES: 
            case LOADMOVIE: 
            case LOADVARIABLESNUM: 
            case LOADMOVIENUM: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.PARENT_CLOSE, SymbolType.COMMA});
                if (s.type == SymbolType.COMMA) {
                    s = this.lex();
                    this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.STRING});
                    if (!s.value.equals("POST") && !s.value.equals("GET")) {
                        errors.add(new SimpleParseException("Invalid method, \"GET\" or \"POST\" expected.", this.lexer.yyline(), s.position));
                    }
                } else {
                    this.lexer.pushback(s);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case REMOVEMOVIECLIP: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case STARTDRAG: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                if (s.type == SymbolType.COMMA) {
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                    s = this.lex();
                    if (s.type == SymbolType.COMMA) {
                        this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                        s = this.lex();
                        if (s.type == SymbolType.COMMA) {
                            this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                            s = this.lex();
                            if (s.type == SymbolType.COMMA) {
                                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                                s = this.lex();
                                if (s.type == SymbolType.COMMA) {
                                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                                } else {
                                    this.lexer.pushback(s);
                                }
                            } else {
                                this.lexer.pushback(s);
                            }
                        } else {
                            this.lexer.pushback(s);
                        }
                    } else {
                        this.lexer.pushback(s);
                    }
                } else {
                    this.lexer.pushback(s);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case CALL: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case GETVERSION: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case MBORD: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case MBCHR: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case MBLENGTH: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case MBSUBSTRING: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case SUBSTRING: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COMMA});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case LENGTH: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case RANDOM: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case INT: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case NUMBER_OP: {
                ParsedSymbol sopn = s;
                s = this.lex();
                if (s.type == SymbolType.DOT) {
                    this.lexer.pushback(s);
                    Variable vi = new Variable(false, new Path(sopn.value.toString()), sopn.position);
                    variables.add(vi);
                    ret = true;
                    break;
                }
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case STRING_OP: {
                ParsedSymbol sop = s;
                s = this.lex();
                if (s.type == SymbolType.DOT) {
                    this.lexer.pushback(s);
                    Variable vi2 = new Variable(false, new Path(sop.value.toString()), sop.position);
                    variables.add(vi2);
                    ret = true;
                    break;
                }
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case ORD: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case CHR: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case GETTIMER: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case TARGETPATH: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            default: {
                return false;
            }
        }
        return ret;
    }

    private boolean isIdentifier(ParsedSymbol s, Object ... exceptions) {
        for (Object ex : exceptions) {
            if (!s.isType(ex)) continue;
            return true;
        }
        return s.isType(new Object[]{SymbolType.IDENTIFIER, SymbolType.TRUE, SymbolType.FALSE, SymbolGroup.GLOBALCONST, SymbolType.GET, SymbolType.SET, SymbolType.EACH, SymbolGroup.GLOBALFUNC, SymbolType.NUMBER_OP, SymbolType.STRING_OP});
    }

    private boolean expectedIdentifier(List<SimpleParseException> errors, ParsedSymbol s, int line, Object ... exceptions) throws IOException {
        for (Object ex : exceptions) {
            if (!s.isType(ex)) continue;
            return true;
        }
        if (!this.isIdentifier(s, new Object[0])) {
            errors.add(new SimpleParseException((Object)((Object)SymbolType.IDENTIFIER) + " expected but " + (Object)((Object)s.type) + " found", line, s.position));
            return false;
        }
        return true;
    }

    private boolean command(List<SimpleParseException> errors, boolean inWith, boolean inFunction, boolean inMethod, int forinlevel, boolean inTellTarget, List<VariableOrScope> variables, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        LexBufferer buf = new LexBufferer();
        this.lexer.addListener(buf);
        boolean ret = false;
        ParsedSymbol s = this.lex();
        if (s.type == SymbolType.EOF) {
            return false;
        }
        if (s.group == SymbolGroup.GLOBALFUNC) {
            ParsedSymbol s2 = this.lex();
            if (s2.type != SymbolType.PARENT_OPEN) {
                this.lexer.removeListener(buf);
                buf.pushAllBack(this.lexer);
                ret = this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                if (s != null && s.type != SymbolType.SEMICOLON) {
                    this.lexer.pushback(s);
                }
                return ret;
            }
            this.lexer.pushback(s2);
        }
        block0 : switch (s.type) {
            case WITH: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.expectedType(errors, new Object[]{SymbolType.CURLY_OPEN});
                this.commands(errors, true, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case DELETE: {
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, false, hasEval);
                ret = true;
                break;
            }
            case TELLTARGET: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.expectedType(errors, new Object[]{SymbolType.CURLY_OPEN});
                this.commands(errors, inWith, inFunction, inMethod, forinlevel, true, variables, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case IFFRAMELOADED: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.expectedType(errors, new Object[]{SymbolType.CURLY_OPEN});
                this.commands(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case CLASS: {
                int scopePos = s.position;
                Path className = this.type(errors, true, variables);
                if (className == null) break;
                s = this.lex();
                if (s.type == SymbolType.EXTENDS) {
                    this.type(errors, false, variables);
                    s = this.lex();
                }
                if (s.type == SymbolType.IMPLEMENTS) {
                    do {
                        this.type(errors, false, variables);
                        s = this.lex();
                    } while (s.type == SymbolType.COMMA);
                }
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.CURLY_OPEN});
                variables.add(new Variable(true, new Path("this"), s.position));
                ArrayList<VariableOrScope> subVariables = new ArrayList<VariableOrScope>();
                this.traits(errors, false, className, subVariables, inTellTarget, hasEval);
                s = this.lex();
                ClassScope cs = new ClassScope(scopePos, s.position, subVariables);
                variables.add(cs);
                this.expectedType(errors, new Object[]{s, this.lexer.yyline(), SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case INTERFACE: {
                Path interfaceName = this.type(errors, true, variables);
                if (interfaceName == null) break;
                s = this.lex();
                if (s.type == SymbolType.EXTENDS) {
                    do {
                        this.type(errors, false, variables);
                        s = this.lex();
                    } while (s.type == SymbolType.COMMA);
                }
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.CURLY_OPEN});
                this.traits(errors, true, interfaceName, variables, inTellTarget, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case FUNCTION: {
                s = this.lexer.lex();
                if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0])) break;
                variables.add(this.function(errors, true, new Path(s.value.toString()), s.position, false, variables, inTellTarget, hasEval, false));
                break;
            }
            case VAR: {
                s = this.lex();
                if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0])) break;
                Path varIdentifier = new Path(s.value.toString());
                int varPosition = s.position;
                s = this.lex();
                if (s.type == SymbolType.COLON) {
                    this.type(errors, false, variables);
                    s = this.lex();
                }
                if (s.type == SymbolType.ASSIGN) {
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                    Variable vret = new Variable(true, varIdentifier, varPosition);
                    variables.add(vret);
                } else {
                    Variable vret = new Variable(true, varIdentifier, varPosition);
                    variables.add(vret);
                    this.lexer.pushback(s);
                }
                ret = true;
                break;
            }
            case CURLY_OPEN: {
                this.commands(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case INCREMENT: 
            case DECREMENT: {
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, false, hasEval);
                ret = true;
                break;
            }
            case SUPER: {
                ParsedSymbol ss2 = this.lex();
                if (ss2.type == SymbolType.PARENT_OPEN) {
                    this.call(errors, inWith, inFunction, inMethod, inTellTarget, variables, hasEval);
                    Variable supItem = new Variable(false, new Path(s.value.toString()), s.position);
                    variables.add(supItem);
                    ret = true;
                    break;
                }
                this.lexer.pushback(ss2);
                this.lexer.pushback(s);
                break;
            }
            case IF: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                s = this.lex();
                if (s.type == SymbolType.ELSE) {
                    this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                } else {
                    this.lexer.pushback(s);
                }
                ret = true;
                break;
            }
            case WHILE: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, true, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                ret = true;
                break;
            }
            case DO: {
                this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.WHILE});
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, true, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                ret = true;
                break;
            }
            case FOR: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                s = this.lex();
                boolean forin = false;
                boolean define = false;
                if (s.type == SymbolType.VAR || this.isIdentifier(s, new Object[0])) {
                    ParsedSymbol s2 = null;
                    ParsedSymbol ssel = s;
                    if (s.type == SymbolType.VAR) {
                        ssel = s2 = this.lex();
                        define = true;
                    }
                    if (this.isIdentifier(ssel, new Object[0])) {
                        Path objIdent = new Path(ssel.value.toString());
                        ParsedSymbol s3 = this.lex();
                        if (s3.type == SymbolType.IN) {
                            Variable item = new Variable(define, objIdent, ssel.position);
                            variables.add(item);
                            this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                            forin = true;
                        } else {
                            this.lexer.pushback(s3);
                            if (s2 != null) {
                                this.lexer.pushback(s2);
                            }
                            this.lexer.pushback(s);
                        }
                    } else {
                        if (s2 != null) {
                            this.lexer.pushback(s2);
                        }
                        this.lexer.pushback(s);
                    }
                } else {
                    this.lexer.pushback(s);
                }
                if (!forin) {
                    this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                    this.expectedType(errors, new Object[]{SymbolType.SEMICOLON});
                    this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.command(errors, inWith, inFunction, inMethod, forin ? forinlevel + 1 : forinlevel, inTellTarget, variables, hasEval);
                ret = true;
                break;
            }
            case SWITCH: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                this.expectedType(errors, new Object[]{SymbolType.CURLY_OPEN});
                s = this.lex();
                while (s.type == SymbolType.CASE || s.type == SymbolType.DEFAULT) {
                    while (s.type == SymbolType.CASE || s.type == SymbolType.DEFAULT) {
                        if (s.type != SymbolType.DEFAULT) {
                            this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                        }
                        this.expectedType(errors, new Object[]{SymbolType.COLON});
                        s = this.lex();
                    }
                    this.lexer.pushback(s);
                    this.commands(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                    s = this.lex();
                }
                this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.CURLY_CLOSE});
                ret = true;
                break;
            }
            case BREAK: {
                ret = true;
                break;
            }
            case CONTINUE: {
                ret = true;
                break;
            }
            case RETURN: {
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                ret = true;
                break;
            }
            case TRY: {
                this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                s = this.lex();
                boolean found = false;
                while (s.type == SymbolType.CATCH) {
                    int catchScopePos = s.position;
                    this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                    ParsedSymbol si = this.lex();
                    if (this.expectedIdentifier(errors, si, this.lexer.yyline(), new Object[]{SymbolType.STRING})) {
                        s = this.lex();
                        if (s.type == SymbolType.COLON) {
                            this.type(errors, false, variables);
                        } else {
                            this.lexer.pushback(s);
                        }
                        this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                        ArrayList<VariableOrScope> subvariables = new ArrayList<VariableOrScope>();
                        this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, subvariables, hasEval);
                        s = this.lex();
                        variables.add(new CatchScope(catchScopePos, s.position, new Variable(true, new Path((String)si.value), si.position), subvariables));
                        this.lexer.pushback(s);
                    }
                    s = this.lex();
                    found = true;
                }
                if (s.type == SymbolType.FINALLY) {
                    this.command(errors, inWith, inFunction, inMethod, forinlevel, inTellTarget, variables, hasEval);
                    found = true;
                    s = this.lex();
                }
                if (!found) {
                    this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.CATCH, SymbolType.FINALLY});
                }
                this.lexer.pushback(s);
                ret = true;
                break;
            }
            case THROW: {
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                ret = true;
                break;
            }
            case SEMICOLON: {
                return true;
            }
            case DIRECTIVE: {
                switch ((String)s.value) {
                    case "strict": {
                        ret = true;
                        break block0;
                    }
                }
                errors.add(new SimpleParseException("Unknown directive: #" + s.value, this.lexer.yyline(), s.position));
                break;
            }
            default: {
                this.lexer.pushback(s);
                ret = this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, true, hasEval);
            }
        }
        this.lexer.removeListener(buf);
        if (!ret) {
            buf.pushAllBack(this.lexer);
            ret = this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
        }
        if ((s = this.lex()) != null && s.type != SymbolType.SEMICOLON) {
            this.lexer.pushback(s);
        }
        return ret;
    }

    private boolean expression(List<SimpleParseException> errors, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, boolean allowRemainder, List<VariableOrScope> variables, boolean allowComma, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol symb;
        do {
            boolean prim;
            if (!(prim = this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, true, hasEval))) {
                return false;
            }
            this.expression1(errors, prim, 17, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, hasEval);
            symb = this.lex();
        } while (allowComma && symb != null && symb.type == SymbolType.COMMA);
        if (symb != null) {
            this.lexer.pushback(symb);
        }
        return true;
    }

    private ParsedSymbol peekLex() throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol lookahead = this.lex();
        this.lexer.pushback(lookahead);
        return lookahead;
    }

    private boolean isBinaryOperator(ParsedSymbol s) {
        if (s.type == SymbolType.IDENTIFIER && Arrays.asList(operatorIdentifiers).contains(s.value.toString())) {
            return true;
        }
        return s.type.isBinary();
    }

    private int getSymbPrecedence(ParsedSymbol s) {
        if (s.type == SymbolType.IDENTIFIER && Arrays.asList(operatorIdentifiers).contains(s.value.toString())) {
            switch (s.value.toString()) {
                case "add": {
                    return 4;
                }
                case "eq": 
                case "ne": {
                    return 7;
                }
                case "lt": 
                case "ge": 
                case "gt": 
                case "le": {
                    return 6;
                }
            }
        }
        return s.type.getPrecedence();
    }

    private boolean expression1(List<SimpleParseException> errors, boolean lhs, int min_precedence, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, boolean allowRemainder, List<VariableOrScope> variables, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol lookahead = this.peekLex();
        while (this.isBinaryOperator(lookahead) && this.getSymbPrecedence(lookahead) <= min_precedence) {
            boolean rhs;
            ParsedSymbol op = lookahead;
            this.lex();
            if (op.type == SymbolType.TERNAR) {
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.COLON});
            }
            if (!(rhs = this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, true, hasEval))) {
                this.lexer.pushback(op);
                errors.add(new SimpleParseException("Missing operand", this.lexer.yyline(), op.position));
                return false;
            }
            lookahead = this.peekLex();
            while ((this.isBinaryOperator(lookahead) && this.getSymbPrecedence(lookahead) < this.getSymbPrecedence(op) || lookahead.type.isRightAssociative() && this.getSymbPrecedence(lookahead) == this.getSymbPrecedence(op)) && (rhs = this.expression1(errors, rhs, this.getSymbPrecedence(lookahead), inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, hasEval))) {
                lookahead = this.peekLex();
            }
            switch (op.type) {
                case TERNAR: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: 
                case USHIFT_RIGHT: 
                case BITAND: 
                case BITOR: 
                case DIVIDE: 
                case MODULO: 
                case EQUALS: 
                case STRICT_EQUALS: 
                case NOT_EQUAL: 
                case STRICT_NOT_EQUAL: 
                case LOWER_THAN: 
                case LOWER_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case AND: 
                case OR: 
                case FULLAND: 
                case FULLOR: 
                case MINUS: 
                case MULTIPLY: 
                case PLUS: 
                case XOR: 
                case INSTANCEOF: {
                    lhs = true;
                    break;
                }
                case ASSIGN: 
                case ASSIGN_BITAND: 
                case ASSIGN_BITOR: 
                case ASSIGN_DIVIDE: 
                case ASSIGN_MINUS: 
                case ASSIGN_MODULO: 
                case ASSIGN_MULTIPLY: 
                case ASSIGN_PLUS: 
                case ASSIGN_SHIFT_LEFT: 
                case ASSIGN_SHIFT_RIGHT: 
                case ASSIGN_USHIFT_RIGHT: 
                case ASSIGN_XOR: {
                    lhs = true;
                    break;
                }
                case IDENTIFIER: {
                    switch (op.value.toString()) {
                        case "add": 
                        case "eq": 
                        case "ne": 
                        case "lt": 
                        case "ge": 
                        case "gt": 
                        case "le": {
                            lhs = true;
                        }
                    }
                }
            }
        }
        return lhs;
    }

    private int brackets(List<SimpleParseException> errors, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, List<VariableOrScope> variables, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol s = this.lex();
        int arrCnt = 0;
        if (s.type == SymbolType.BRACKET_OPEN) {
            s = this.lex();
            while (s.type != SymbolType.BRACKET_CLOSE) {
                if (s.type != SymbolType.COMMA) {
                    this.lexer.pushback(s);
                }
                ++arrCnt;
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                s = this.lex();
                if (this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.COMMA, SymbolType.BRACKET_CLOSE})) continue;
                break;
            }
        } else {
            this.lexer.pushback(s);
            return -1;
        }
        return arrCnt;
    }

    private boolean handleVariable(List<SimpleParseException> errors, ParsedSymbol s, boolean ret, List<VariableOrScope> variables, Reference<Boolean> allowMemberOrCall, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        if (s.value.equals("not")) {
            this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, true, hasEval);
            ret = true;
        } else {
            Path varName = new Path(s.value.toString());
            Variable vret = new Variable(false, varName, s.position);
            variables.add(vret);
            allowMemberOrCall.setVal(true);
            if (varName.equals("this")) {
                ParsedSymbol s2 = this.lex();
                if (s2.type == SymbolType.DOT) {
                    ParsedSymbol s3 = this.lex();
                    if (this.isIdentifier(s3, new Object[0])) {
                        Variable thisVar = new Variable(false, new Path("this", s3.value.toString()), s3.position);
                        variables.add(thisVar);
                    } else {
                        this.lexer.pushback(s3);
                        this.lexer.pushback(s2);
                    }
                } else {
                    this.lexer.pushback(s2);
                }
            }
            ParsedSymbol ss = this.lex();
            Path fullName = varName;
            while (ss.type == SymbolType.DOT) {
                ParsedSymbol si = this.lex();
                if (!this.isIdentifier(si, new Object[0])) {
                    this.lexer.pushback(si);
                    break;
                }
                fullName = fullName.add(si.value.toString());
                Variable v = new Variable(false, fullName, si.position);
                variables.add(v);
                ss = this.lex();
            }
            this.lexer.pushback(ss);
            ret = true;
        }
        return ret;
    }

    private boolean expressionPrimary(List<SimpleParseException> errors, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, boolean allowRemainder, List<VariableOrScope> variables, boolean allowCall, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        boolean allowMemberOrCall = false;
        boolean ret = false;
        ParsedSymbol s = this.lex();
        switch (s.type) {
            case PREPROCESSOR: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                switch ("" + s.value) {
                    case "constant": {
                        s = this.lexer.lex();
                        this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.INTEGER});
                        ret = true;
                        break;
                    }
                    case "enumerate": {
                        this.expression(errors, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, false, hasEval);
                        ret = true;
                        break;
                    }
                    case "dup": {
                        this.expression(errors, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, false, hasEval);
                        ret = true;
                        allowMemberOrCall = true;
                        break;
                    }
                    case "push": {
                        this.expression(errors, inWith, inFunction, inMethod, inTellTarget, allowRemainder, variables, false, hasEval);
                        ret = true;
                        break;
                    }
                    case "pop": {
                        ret = true;
                        allowMemberOrCall = true;
                        break;
                    }
                    case "swap": {
                        ret = true;
                        break;
                    }
                    case "strict": {
                        s = this.lexer.lex();
                        this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.INTEGER});
                        ret = true;
                        break;
                    }
                    case "goto": {
                        s = this.lexer.lex();
                        this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[0]);
                        ret = true;
                        break;
                    }
                    default: {
                        errors.add(new SimpleParseException("Unknown preprocessor instruction: \u00a7\u00a7" + s.value, this.lexer.yyline(), s.position));
                    }
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                break;
            }
            case NEGATE: {
                this.versionRequired(errors, s, 5);
                this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, true, hasEval);
                ret = true;
                break;
            }
            case MINUS: {
                s = this.lex();
                if (s.isType(new Object[]{SymbolType.DOUBLE})) {
                    ret = true;
                    break;
                }
                if (s.isType(new Object[]{SymbolType.INTEGER})) {
                    ret = true;
                    break;
                }
                this.lexer.pushback(s);
                this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, true, hasEval);
                ret = true;
                break;
            }
            case TYPEOF: {
                this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, true, hasEval);
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case TRUE: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case NULL: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case UNDEFINED: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case FALSE: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case CURLY_OPEN: {
                s = this.lex();
                while (s.type != SymbolType.CURLY_CLOSE) {
                    if (s.type != SymbolType.COMMA) {
                        this.lexer.pushback(s);
                    }
                    if (!this.expectedIdentifier(errors, s = this.lex(), this.lexer.yyline(), new Object[0]) || this.expectedType(errors, new Object[]{SymbolType.COLON}) == null) break;
                    this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                    s = this.lex();
                    if (s.isType(new Object[]{SymbolType.COMMA, SymbolType.CURLY_CLOSE}) || this.expected(errors, s, this.lexer.yyline(), new Object[]{SymbolType.COMMA, SymbolType.CURLY_CLOSE})) continue;
                }
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case BRACKET_OPEN: {
                this.lexer.pushback(s);
                this.brackets(errors, inWith, inFunction, inMethod, inTellTarget, variables, hasEval);
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case FUNCTION: {
                s = this.lex();
                Path fname = new Path(new String[0]);
                int fnamePos = -1;
                if (this.isIdentifier(s, new Object[0])) {
                    fname = new Path(s.value.toString());
                    fnamePos = s.position;
                } else {
                    this.lexer.pushback(s);
                }
                variables.add(this.function(errors, true, fname, fnamePos, false, variables, inTellTarget, hasEval, false));
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case STRING: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case NEWLINE: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case INTEGER: 
            case DOUBLE: {
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case DELETE: {
                this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, true, hasEval);
                ret = true;
                break;
            }
            case INCREMENT: 
            case DECREMENT: {
                this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, true, hasEval);
                ret = true;
                break;
            }
            case NOT: {
                this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, true, hasEval);
                ret = true;
                break;
            }
            case PARENT_OPEN: {
                boolean pexpr = this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, true, hasEval);
                if (!pexpr) {
                    errors.add(new SimpleParseException("Expression expected", this.lexer.yyline(), s.position));
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                allowMemberOrCall = true;
                ret = true;
                break;
            }
            case NEW: {
                ParsedSymbol s1 = this.lex();
                if (s1.type == SymbolType.NUMBER_OP || s1.type == SymbolType.STRING_OP) {
                    ParsedSymbol s2 = this.lex();
                    if (s2.type == SymbolType.PARENT_OPEN) {
                        this.lexer.pushback(s2);
                    } else {
                        this.lexer.pushback(s2);
                        this.lexer.pushback(s1);
                        this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, false, hasEval);
                    }
                } else {
                    this.lexer.pushback(s1);
                    this.expressionPrimary(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, false, hasEval);
                }
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.call(errors, inWith, inFunction, inMethod, inTellTarget, variables, hasEval);
                ret = true;
                allowMemberOrCall = true;
                break;
            }
            case EVAL: {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, true, variables, false, hasEval);
                this.expectedType(errors, new Object[]{SymbolType.PARENT_CLOSE});
                hasEval.setVal(true);
                allowMemberOrCall = true;
                ret = true;
                break;
            }
            case SUPER: 
            case IDENTIFIER: 
            case THIS: {
                Reference<Boolean> allowMemberOrCallRef = new Reference<Boolean>(allowMemberOrCall);
                ret = this.handleVariable(errors, s, ret, variables, allowMemberOrCallRef, inWith, inFunction, inMethod, inTellTarget, hasEval);
                allowMemberOrCall = allowMemberOrCallRef.getVal();
                break;
            }
            default: {
                boolean isGlobalFuncVar = false;
                if (s.group == SymbolGroup.GLOBALFUNC) {
                    ParsedSymbol s2 = this.peekLex();
                    if (s2.type != SymbolType.PARENT_OPEN) {
                        Reference<Boolean> allowMemberOrCallRef2 = new Reference<Boolean>(allowMemberOrCall);
                        ret = this.handleVariable(errors, s, ret, variables, allowMemberOrCallRef2, inWith, inFunction, inMethod, inTellTarget, hasEval);
                        allowMemberOrCall = allowMemberOrCallRef2.getVal();
                        isGlobalFuncVar = true;
                    }
                }
                if (isGlobalFuncVar) break;
                boolean excmd = this.expressionCommands(errors, s, inWith, inFunction, inMethod, inTellTarget, variables, hasEval);
                if (excmd) {
                    ret = excmd;
                    allowMemberOrCall = true;
                    break;
                }
                this.lexer.pushback(s);
            }
        }
        if (allowMemberOrCall && ret) {
            ret = this.memberOrCall(errors, ret, inWith, inFunction, inMethod, inTellTarget, variables, allowCall, hasEval);
        }
        return ret;
    }

    private boolean memberOrCall(List<SimpleParseException> errors, boolean ret, boolean inWith, boolean inFunction, boolean inMethod, boolean inTellTarget, List<VariableOrScope> variables, boolean allowCall, Reference<Boolean> hasEval) throws IOException, InterruptedException, SimpleParseException, ActionParseException {
        ParsedSymbol op = this.lex();
        while (op.isType(new Object[]{SymbolType.PARENT_OPEN, SymbolType.BRACKET_OPEN, SymbolType.DOT})) {
            if (op.type == SymbolType.PARENT_OPEN) {
                if (!allowCall) break;
                this.call(errors, inWith, inFunction, inMethod, inTellTarget, variables, hasEval);
                ret = true;
            }
            if (op.type == SymbolType.BRACKET_OPEN) {
                this.expression(errors, inWith, inFunction, inMethod, inTellTarget, false, variables, false, hasEval);
                if (this.expectedType(errors, new Object[]{SymbolType.BRACKET_CLOSE}) == null) break;
                ret = true;
            }
            if (op.type == SymbolType.DOT) {
                ParsedSymbol s = this.lex();
                if (!this.expectedIdentifier(errors, s, this.lexer.yyline(), new Object[]{SymbolType.THIS, SymbolType.SUPER})) break;
                ret = true;
            }
            op = this.lex();
        }
        switch (op.type) {
            case INCREMENT: {
                ret = true;
                op = this.lex();
                break;
            }
            case DECREMENT: {
                ret = true;
                op = this.lex();
            }
        }
        this.lexer.pushback(op);
        return ret;
    }

    @Override
    public void parse(String str, Map<Integer, List<Integer>> definitionPosToReferences, Map<Integer, Integer> referenceToDefinition, List<SimpleParseException> errors, List<Path> externalTypes, Map<Integer, Integer> referenceToExternalTypeIndex, Map<Integer, List<Integer>> externalTypeIndexToReference, LinkHandler linkHandler, Map<Integer, Path> referenceToExternalTraitKey, Map<Path, List<Integer>> externalTraitKeyToReference, Map<Integer, Path> separatorPosToType, Map<Integer, Boolean> separatorIsStatic, Map<Path, List<Variable>> localTypeTraits, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Integer caretPosition, List<Variable> variableSuggestions) throws SimpleParseException, IOException, InterruptedException {
        ArrayList<VariableOrScope> vars = new ArrayList<VariableOrScope>();
        try {
            this.lexer = new ActionScriptLexer(new StringReader(str));
            if (this.swfVersion >= 7) {
                this.lexer.setCaseSensitiveIdentifiers(true);
            }
            ParsedSymbol symb = this.lexer.lex();
            boolean inOnHandler = false;
            if (symb.type == SymbolType.IDENTIFIER && ("on".equals(symb.value) || "onClipEvent".equals(symb.value))) {
                this.expectedType(errors, new Object[]{SymbolType.PARENT_OPEN});
                symb = this.lexer.lex();
                boolean condEmpty = true;
                while (symb.type == SymbolType.IDENTIFIER) {
                    condEmpty = false;
                    switch ((String)symb.value) {
                        case "press": {
                            break;
                        }
                        case "release": {
                            break;
                        }
                        case "releaseOutside": {
                            break;
                        }
                        case "rollOver": {
                            break;
                        }
                        case "rollOut": {
                            break;
                        }
                        case "dragOut": {
                            break;
                        }
                        case "dragOver": {
                            break;
                        }
                        case "keyPress": {
                            symb = this.lexer.lex();
                            this.expected(errors, symb, this.lexer.yyline(), new Object[]{SymbolType.STRING});
                            Integer key = CLIPACTIONRECORD.stringToKey((String)symb.value);
                            if (key != null) break;
                            errors.add(new SimpleParseException("Invalid key", this.lexer.yyline(), symb.position));
                            break;
                        }
                        case "keyUp": {
                            break;
                        }
                        case "keyDown": {
                            break;
                        }
                        case "mouseUp": {
                            break;
                        }
                        case "mouseDown": {
                            break;
                        }
                        case "mouseMove": {
                            break;
                        }
                        case "unload": {
                            break;
                        }
                        case "enterFrame": {
                            break;
                        }
                        case "load": {
                            break;
                        }
                        case "data": {
                            break;
                        }
                        default: {
                            errors.add(new SimpleParseException("Unrecognized event type", this.lexer.yyline(), symb.position));
                        }
                    }
                    symb = this.lexer.lex();
                    if (symb.type == SymbolType.PARENT_CLOSE) break;
                    this.expected(errors, symb, this.lexer.yyline(), new Object[]{SymbolType.COMMA});
                    symb = this.lexer.lex();
                }
                this.expected(errors, symb, this.lexer.yyline(), new Object[]{SymbolType.PARENT_CLOSE});
                if (condEmpty) {
                    errors.add(new SimpleParseException("condition must be non empty", this.lexer.yyline(), symb.position));
                }
                this.expectedType(errors, new Object[]{SymbolType.CURLY_OPEN});
                inOnHandler = true;
            } else {
                this.lexer.pushback(symb);
            }
            Reference<Boolean> hasEval = new Reference<Boolean>(false);
            this.commands(errors, false, false, false, 0, false, vars, hasEval);
            if (inOnHandler) {
                this.expectedType(errors, new Object[]{SymbolType.CURLY_CLOSE});
            }
            if (this.lexer.lex().type != SymbolType.EOF) {
                errors.add(new SimpleParseException("Parsing finished before end of the file", this.lexer.yyline(), this.lexer.yychar()));
            }
        }
        catch (ActionParseException ex) {
            errors.add(new SimpleParseException(ex.getMessage(), ex.line, ex.position));
        }
        SimpleParser.parseVariablesList(vars, definitionPosToReferences, referenceToDefinition, errors, false, externalTypes, referenceToExternalTypeIndex, externalTypeIndexToReference, linkHandler, referenceToExternalTraitKey, externalTraitKeyToReference, separatorPosToType, separatorIsStatic, localTypeTraits, definitionToType, definitionToCallType, caretPosition, variableSuggestions);
    }

    private void versionRequired(List<SimpleParseException> errors, ParsedSymbol s, int min) throws SimpleParseException {
        this.versionRequired(errors, s.value.toString(), min, Integer.MAX_VALUE, s.position);
    }

    private void versionRequired(List<SimpleParseException> errors, String type, int min, int max, long position) throws SimpleParseException {
        if (min == max && this.swfVersion != min) {
            errors.add(new SimpleParseException(type + " requires SWF version " + min, this.lexer.yyline(), position));
        }
        if (this.swfVersion < min) {
            errors.add(new SimpleParseException(type + " requires at least SWF version " + min, this.lexer.yyline(), position));
        }
        if (this.swfVersion > max) {
            errors.add(new SimpleParseException(type + " requires SWF version lower than " + max, this.lexer.yyline(), position));
        }
    }
}

