/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf7;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.model.CastOpActionItem;
import com.jpexs.decompiler.flash.action.model.DefineLocalActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.TemporaryRegister;
import com.jpexs.decompiler.flash.action.model.clauses.TryActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.ExitItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@SWFVersion(from=7)
public class ActionTry
extends Action
implements GraphSourceItemContainer {
    @Reserved
    public int reserved;
    public boolean catchInRegisterFlag;
    public boolean finallyBlockFlag;
    public boolean catchBlockFlag;
    public String catchName;
    public int catchRegister;
    long trySize;
    long catchSize;
    long finallySize;
    private final int version;

    @Override
    public boolean execute(LocalDataArea lda) {
        return false;
    }

    public ActionTry(boolean catchInRegisterFlag, boolean finallyBlockFlag, boolean catchBlockFlag, String catchName, int catchRegister, long trySize, long catchSize, long finallySize, int version, String charset) {
        super(143, 0, charset);
        this.catchInRegisterFlag = catchInRegisterFlag;
        this.finallyBlockFlag = finallyBlockFlag;
        this.catchBlockFlag = catchBlockFlag;
        this.catchName = catchName;
        this.catchRegister = catchRegister;
        this.trySize = trySize;
        this.catchSize = catchSize;
        this.finallySize = finallySize;
        this.version = version;
    }

    public ActionTry(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(143, actionLength, sis.getCharset());
        long startPos = sis.getPos();
        this.version = version;
        this.reserved = (int)sis.readUB(5, "reserved");
        this.catchInRegisterFlag = sis.readUB(1, "catchInRegisterFlag") == 1L;
        this.finallyBlockFlag = sis.readUB(1, "finallyBlockFlag") == 1L;
        this.catchBlockFlag = sis.readUB(1, "catchBlockFlag") == 1L;
        this.trySize = sis.readUI16("trySize");
        this.catchSize = sis.readUI16("catchSize");
        this.finallySize = sis.readUI16("finallySize");
        if (this.catchInRegisterFlag) {
            this.catchRegister = sis.readUI8("catchRegister");
        } else {
            this.catchName = sis.readString("catchName");
        }
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeUB(5, this.reserved);
        sos.writeUB(1, this.catchInRegisterFlag ? 1L : 0L);
        sos.writeUB(1, this.finallyBlockFlag ? 1L : 0L);
        sos.writeUB(1, this.catchBlockFlag ? 1L : 0L);
        sos.writeUI16((int)this.trySize);
        sos.writeUI16((int)this.catchSize);
        sos.writeUI16((int)this.finallySize);
        if (this.catchInRegisterFlag) {
            sos.writeUI8(this.catchRegister);
        } else {
            sos.writeString(this.catchName == null ? "" : this.catchName);
        }
    }

    @Override
    protected int getContentBytesLength() {
        int res = 8;
        if (!this.catchInRegisterFlag) {
            res += Utf8Helper.getBytesLength(this.catchName == null ? "" : this.catchName);
        }
        return res;
    }

    public ActionTry(FlasmLexer lexer, int version, String charset) throws IOException, ActionParseException {
        super(143, 0, charset);
        this.version = version;
        ASMParsedSymbol symb = lexer.lex();
        if (symb.type == 1) {
            this.catchInRegisterFlag = false;
            this.catchName = (String)symb.value;
        } else if (symb.type == 12) {
            this.catchRegister = ((RegisterNumber)symb.value).number;
            this.catchInRegisterFlag = true;
        } else {
            if (symb.type == 10) {
                return;
            }
            throw new ActionParseException("Unknown symbol after Try", lexer.yyline());
        }
        this.lexBlockOpen(lexer);
    }

    @Override
    public String getASMSourceBetween(int pos) {
        if (pos == 0) {
            if (this.catchBlockFlag) {
                return "Catch {\r\n";
            }
            if (this.finallyBlockFlag) {
                return "Finally {\r\n";
            }
        }
        if (pos == 1 && this.catchBlockFlag && this.finallyBlockFlag) {
            return "Finally {\r\n";
        }
        return "";
    }

    @Override
    public String getASMSource(ActionList container, Set<Long> knownAddresses, ScriptExportMode exportMode) {
        StringBuilder ret = new StringBuilder();
        ret.append("Try ");
        if (this.catchBlockFlag) {
            if (this.catchInRegisterFlag) {
                ret.append("register").append(this.catchRegister);
            } else {
                ret.append("\"").append(Helper.escapeActionScriptString(this.catchName)).append("\"");
            }
            ret.append(" ");
        }
        ret.append("{");
        return ret.toString();
    }

    @Override
    public long getHeaderSize() {
        return this.getBytesLength();
    }

    public long getTrySize() {
        return this.trySize;
    }

    @Override
    public List<Long> getContainerSizes() {
        ArrayList<Long> ret = new ArrayList<Long>();
        ret.add(this.trySize);
        if (this.catchBlockFlag) {
            ret.add(this.catchSize);
        }
        if (this.finallyBlockFlag) {
            ret.add(this.finallySize);
        }
        return ret;
    }

    @Override
    public void setContainerSize(int index, long size) {
        int pos = 0;
        if (pos == index) {
            this.trySize = size;
        }
        if (this.catchBlockFlag && ++pos == index) {
            this.catchSize = size;
        }
        if (this.finallyBlockFlag && ++pos == index) {
            this.finallySize = size;
        }
        if (index > pos) {
            throw new IllegalArgumentException("Valid indexes are 0 to " + pos + ".");
        }
    }

    @Override
    public boolean parseDivision(long size, FlasmLexer lexer) {
        try {
            ASMParsedSymbol symb = lexer.lex();
            if (symb.type == 3) {
                if (((String)symb.value).toLowerCase().equals("catch")) {
                    this.trySize = size - this.getHeaderSize();
                    this.catchBlockFlag = true;
                    this.lexBlockOpen(lexer);
                    return true;
                }
                if (symb.type == 3) {
                    if (((String)symb.value).toLowerCase().equals("finally")) {
                        if (this.catchBlockFlag) {
                            this.catchSize = size - this.getHeaderSize() - this.trySize;
                        } else {
                            this.trySize = size - this.getHeaderSize();
                        }
                        this.finallyBlockFlag = true;
                        this.lexBlockOpen(lexer);
                        return true;
                    }
                    lexer.pushback(symb);
                } else {
                    lexer.pushback(symb);
                }
            } else {
                lexer.pushback(symb);
            }
        }
        catch (ActionParseException | IOException exception) {
            // empty catch block
        }
        if (this.finallyBlockFlag) {
            this.finallySize = size - this.getHeaderSize() - this.trySize - this.catchSize;
        } else if (this.catchBlockFlag) {
            this.catchSize = size - this.getHeaderSize() - this.trySize;
        }
        return false;
    }

    @Override
    public void translateContainer(List<List<GraphTargetItem>> contents, GraphSourceItem lineStartItem, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions) {
        List<GraphTargetItem> tryCommands = contents.get(0);
        ArrayList<GraphTargetItem> catchExceptionNames = new ArrayList<GraphTargetItem>();
        ArrayList<GraphTargetItem> catchExceptionTypes = new ArrayList<GraphTargetItem>();
        ArrayList<List<GraphTargetItem>> catchCommands = new ArrayList<List<GraphTargetItem>>();
        int p = 0;
        if (this.catchBlockFlag) {
            List<GraphTargetItem> body = contents.get(++p);
            if (this.catchInRegisterFlag) {
                if (body.size() >= 2) {
                    int pos = 0;
                    while (body.get(pos) instanceof PushItem) {
                        ArrayList<GraphTargetItem> catchBody;
                        DefineLocalActionItem dl;
                        int regNumber;
                        PushItem pi = (PushItem)body.get(pos);
                        if (!(pi.value instanceof CastOpActionItem)) break;
                        CastOpActionItem co = (CastOpActionItem)pi.value;
                        if ((!(co.object instanceof DirectValueActionItem) || !(((DirectValueActionItem)co.object).value instanceof RegisterNumber)) && !(co.object instanceof TemporaryRegister)) break;
                        if (co.object instanceof TemporaryRegister) {
                            TemporaryRegister tr = (TemporaryRegister)co.object;
                            regNumber = tr.getRegId();
                        } else {
                            RegisterNumber rn = (RegisterNumber)((DirectValueActionItem)co.object).value;
                            regNumber = rn.number;
                        }
                        if (regNumber != this.catchRegister) break;
                        catchExceptionTypes.add(co.constructor);
                        if (!(body.get(pos + 1) instanceof IfItem)) break;
                        IfItem ifi = (IfItem)body.get(pos + 1);
                        List<GraphTargetItem> onFalse = ifi.onFalse;
                        int onFalsePos = 0;
                        if (ifi.onFalse.isEmpty() && !ifi.onTrue.isEmpty() && (ifi.onTrue.get(ifi.onTrue.size() - 1) instanceof ExitItem || ifi.onTrue.get(ifi.onTrue.size() - 1) instanceof BreakItem || ifi.onTrue.get(ifi.onTrue.size() - 1) instanceof ContinueItem)) {
                            onFalse = body;
                            onFalsePos = pos + 2;
                        }
                        if (!ifi.onTrue.isEmpty() && ifi.onTrue.get(0) instanceof DefineLocalActionItem) {
                            dl = (DefineLocalActionItem)ifi.onTrue.get(0);
                            catchExceptionNames.add(dl.name);
                            catchBody = new ArrayList<GraphTargetItem>(ifi.onTrue);
                            catchBody.remove(0);
                            catchCommands.add(catchBody);
                            if (onFalse.size() <= onFalsePos || !(onFalse.get(onFalsePos) instanceof PopItem)) break;
                            pos = onFalsePos + 1;
                            body = onFalse;
                            continue;
                        }
                        if (onFalse.size() <= onFalsePos || !(onFalse.get(onFalsePos) instanceof DefineLocalActionItem)) break;
                        dl = (DefineLocalActionItem)onFalse.get(onFalsePos);
                        catchExceptionNames.add(dl.name);
                        catchBody = new ArrayList();
                        for (int i = onFalsePos; i < onFalse.size(); ++i) {
                            catchBody.add(onFalse.get(i));
                        }
                        catchBody.remove(0);
                        catchCommands.add(catchBody);
                        if (ifi.onTrue.isEmpty() || !(ifi.onTrue.get(0) instanceof PopItem)) break;
                        pos = 1;
                        body = ifi.onTrue;
                    }
                    if (body.get(pos) instanceof DefineLocalActionItem) {
                        DefineLocalActionItem dl = (DefineLocalActionItem)body.get(pos);
                        catchExceptionNames.add(dl.name);
                        catchExceptionTypes.add(null);
                        ArrayList<GraphTargetItem> catchBody = new ArrayList<GraphTargetItem>(body);
                        catchBody.remove(0);
                        catchBody.remove(0);
                        catchCommands.add(catchBody);
                    }
                }
            } else {
                catchExceptionNames.add(new DirectValueActionItem(this, lineStartItem, -1, this.catchName, new ArrayList<String>()));
                catchExceptionTypes.add(null);
                catchCommands.add(body);
            }
        }
        ArrayList<GraphTargetItem> finallyCommands = new ArrayList();
        if (this.finallyBlockFlag) {
            finallyCommands = contents.get(++p);
        }
        output.add(new TryActionItem(tryCommands, catchExceptionNames, catchExceptionTypes, catchCommands, finallyCommands));
    }

    @Override
    public String toString() {
        return "Try";
    }

    @Override
    public HashMap<Integer, String> getRegNames() {
        return new HashMap<Integer, String>();
    }

    @Override
    public String getName() {
        return null;
    }
}

