/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf0;

import com.jpexs.decompiler.flash.amf.amf0.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf0.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf0.types.ComplexObject;
import com.jpexs.decompiler.flash.amf.amf0.types.DateType;
import com.jpexs.decompiler.flash.amf.amf0.types.EcmaArrayType;
import com.jpexs.decompiler.flash.amf.amf0.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf0.types.TypedObjectType;
import com.jpexs.decompiler.flash.amf.amf0.types.XmlDocumentType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class Amf0OutputStream
extends OutputStream {
    private final OutputStream os;

    public Amf0OutputStream(OutputStream os) {
        this.os = os;
    }

    public void writeU8(int v) throws IOException {
        this.write(v);
    }

    public void writeU16(int v) throws IOException {
        int b1 = v >> 8 & 0xFF;
        int b2 = v & 0xFF;
        this.write(b1);
        this.write(b2);
    }

    public void writeS16(int v) throws IOException {
        int b1 = v >> 8 & 0xFF;
        int b2 = v & 0xFF;
        this.write(b1);
        this.write(b2);
    }

    public void writeU32(long v) throws IOException {
        int b1 = (int)(v >> 24 & 0xFFL);
        int b2 = (int)(v >> 16 & 0xFFL);
        int b3 = (int)(v >> 8 & 0xFFL);
        int b4 = (int)(v & 0xFFL);
        this.write(b1);
        this.write(b2);
        this.write(b3);
        this.write(b4);
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    private void writeLong(long value) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        this.write(writeBuffer);
    }

    public void writeBytes(byte[] data) throws IOException {
        this.os.write(data);
    }

    @Override
    public void write(int v) throws IOException {
        this.os.write(v);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public void writeUtf8(String value) throws IOException {
        byte[] data = value.getBytes("UTF-8");
        this.writeU16(data.length);
        this.writeBytes(data);
    }

    public void writeUtf8Long(String value) throws IOException {
        byte[] data = value.getBytes("UTF-8");
        this.writeU32(data.length);
        this.writeBytes(data);
    }

    public void writeObjectProperty(String name, Object value, List<Object> complexObjectsList) throws IOException {
        this.writeUtf8(name);
        this.writeValue(value, complexObjectsList);
    }

    public void writeUtf8Empty() throws IOException {
        this.writeU16(0);
    }

    public void writeValue(Object value, List<Object> complexObjectsList) throws IOException {
        if (value instanceof ComplexObject) {
            int index = complexObjectsList.indexOf(value);
            if (index != -1 && index <= 65535) {
                this.write(7);
                this.writeU16(index);
                return;
            }
            complexObjectsList.add(value);
        }
        if (value instanceof Double) {
            this.write(0);
            this.writeDouble((Double)value);
        } else if (value instanceof Boolean) {
            this.write(1);
            this.write((Boolean)value != false ? 1 : 0);
        } else if (value instanceof String) {
            String sval = (String)value;
            if (sval.length() > 65535) {
                this.write(12);
                this.writeUtf8Long(sval);
            } else {
                this.write(2);
                this.writeUtf8(sval);
            }
        } else if (value instanceof ObjectType) {
            this.write(3);
            ObjectType ot = (ObjectType)value;
            for (String key : ot.properties.keySet()) {
                this.writeObjectProperty(key, ot.properties.get(key), complexObjectsList);
            }
            this.writeUtf8Empty();
            this.write(9);
        } else if (value == BasicType.NULL) {
            this.write(5);
        } else if (value == BasicType.UNDEFINED) {
            this.write(6);
        } else if (value instanceof EcmaArrayType) {
            this.write(8);
            EcmaArrayType ea = (EcmaArrayType)value;
            this.writeU32(ea.denseValues.size());
            for (String key : ea.denseValues.keySet()) {
                this.writeObjectProperty(key, ea.denseValues.get(key), complexObjectsList);
            }
            for (String key : ea.associativeValues.keySet()) {
                this.writeObjectProperty(key, ea.associativeValues.get(key), complexObjectsList);
            }
            this.writeUtf8Empty();
            this.write(9);
        } else if (value instanceof ArrayType) {
            this.write(10);
            ArrayType at = (ArrayType)value;
            this.writeU32(at.values.size());
            for (Object v : at.values) {
                this.writeValue(v, complexObjectsList);
            }
        } else if (value instanceof DateType) {
            this.write(11);
            DateType dt = (DateType)value;
            this.writeDouble(dt.getVal());
            this.writeS16(dt.getTimezone());
        } else if (value instanceof XmlDocumentType) {
            this.write(15);
            XmlDocumentType xmlDoc = (XmlDocumentType)value;
            this.writeUtf8Long(xmlDoc.getData());
        } else if (value instanceof TypedObjectType) {
            this.write(16);
            TypedObjectType tot = (TypedObjectType)value;
            this.writeUtf8(tot.className);
            for (String key : tot.properties.keySet()) {
                this.writeObjectProperty(key, tot.properties.get(key), complexObjectsList);
            }
            this.writeUtf8Empty();
            this.write(9);
        } else {
            throw new IllegalArgumentException("Unsupported value type for serialization");
        }
    }
}

