/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationName;
import com.jpexs.decompiler.flash.configuration.ConfigurationRemoved;
import com.jpexs.decompiler.flash.configuration.ConfigurationStorage;
import com.jpexs.decompiler.flash.configuration.SwfSpecificConfiguration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.helpers.Helper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tomlj.Toml;
import org.tomlj.TomlParseError;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public class TomlConfigurationStorage
implements ConfigurationStorage {
    @Override
    public String getConfigName() {
        return "config.toml";
    }

    @Override
    public Map<String, Object> loadFromFile(String file) {
        TomlTable configurationTable;
        TomlParseResult tomlResult;
        Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.FINE, "Loading TOML file {0}", file);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            tomlResult = Toml.parse((Path)Paths.get(file, new String[0]));
        }
        catch (IOException ex) {
            Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.SEVERE, "Error reading TOML file", ex);
            return result;
        }
        if (!tomlResult.errors().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error parsing configuration file:\r\n");
            for (TomlParseError tomlParseError : tomlResult.errors()) {
                sb.append("- ").append(tomlParseError).append("\r\n");
            }
            Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.SEVERE, sb.toString());
        }
        if ((configurationTable = tomlResult.getTable("configuration")) == null) {
            return result;
        }
        for (Map.Entry entry : Configuration.getConfigurationFields(false, true).entrySet()) {
            try {
                String key;
                String name = (String)entry.getKey();
                Field field = (Field)entry.getValue();
                ConfigurationItem item = (ConfigurationItem)field.get(null);
                ConfigurationName nameAnnotation = field.getAnnotation(ConfigurationName.class);
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if ((key = name).contains(".")) {
                    key = "\"" + key + "\"";
                }
                Object value = null;
                block7 : switch (name) {
                    case "fontPairingMap": {
                        TomlTable fontPairingTable = configurationTable.getTable(key);
                        if (fontPairingTable == null) break;
                        LinkedHashMap<String, String> fontPairingMap = new LinkedHashMap<String, String>();
                        for (Object fontEntry : fontPairingTable.entrySet()) {
                            if (!(fontEntry.getValue() instanceof String)) continue;
                            fontPairingMap.put((String)fontEntry.getKey(), (String)fontEntry.getValue());
                        }
                        value = fontPairingMap;
                        break;
                    }
                    case "swfSpecificConfigs": {
                        Object fontEntry;
                        TomlTable swfSpecificConfigsTable = configurationTable.getTable(key);
                        if (swfSpecificConfigsTable == null) break;
                        LinkedHashMap<String, SwfSpecificConfiguration> swfSpecificConfigs = new LinkedHashMap<String, SwfSpecificConfiguration>();
                        fontEntry = swfSpecificConfigsTable.entrySet().iterator();
                        while (fontEntry.hasNext()) {
                            Map.Entry swfEntry = (Map.Entry)fontEntry.next();
                            String swfKey = (String)swfEntry.getKey();
                            if (!(swfEntry.getValue() instanceof TomlTable)) continue;
                            SwfSpecificConfiguration swfSpecificConfig = new SwfSpecificConfiguration();
                            TomlTable configsTable = (TomlTable)swfEntry.getValue();
                            TomlTable swfSpecificFontPairingTable = configsTable.getTable("fontPairingMap");
                            LinkedHashMap<String, String> swfSpecificFontPairingMap = new LinkedHashMap<String, String>();
                            for (Map.Entry fontEntry2 : swfSpecificFontPairingTable.entrySet()) {
                                if (!(fontEntry2.getValue() instanceof String)) continue;
                                swfSpecificFontPairingMap.put((String)fontEntry2.getKey(), (String)fontEntry2.getValue());
                            }
                            swfSpecificConfig.fontPairingMap = swfSpecificFontPairingMap;
                            swfSpecificConfig.lastSelectedPath = configsTable.getString("lastSelectedPath");
                            swfSpecificConfigs.put(swfKey, swfSpecificConfig);
                        }
                        value = swfSpecificConfigs;
                        break;
                    }
                    case "swfSpecificCustomConfigs": {
                        TomlTable swfSpecificCustomConfigsTable = configurationTable.getTable(key);
                        if (swfSpecificCustomConfigsTable == null) break;
                        LinkedHashMap<String, SwfSpecificCustomConfiguration> swfSpecificCustomConfigs = new LinkedHashMap<String, SwfSpecificCustomConfiguration>();
                        for (Map.Entry swfEntry : swfSpecificCustomConfigsTable.entrySet()) {
                            String swfKey = (String)swfEntry.getKey();
                            if (!(swfEntry.getValue() instanceof TomlTable)) continue;
                            SwfSpecificCustomConfiguration swfSpecificCustomConfig = new SwfSpecificCustomConfiguration();
                            Map<String, String> swfSpecificCustomConfigMap = swfSpecificCustomConfig.getAllCustomData();
                            TomlTable configsTable = (TomlTable)swfEntry.getValue();
                            for (Map.Entry customDataEntry : configsTable.entrySet()) {
                                if (!(customDataEntry.getValue() instanceof String)) continue;
                                swfSpecificCustomConfigMap.put((String)customDataEntry.getKey(), (String)customDataEntry.getValue());
                            }
                            swfSpecificCustomConfigs.put(swfKey, swfSpecificCustomConfig);
                        }
                        value = swfSpecificCustomConfigs;
                        break;
                    }
                    default: {
                        Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        if (!(type instanceof Class)) break;
                        switch (((Class)type).getSimpleName()) {
                            case "Boolean": {
                                value = configurationTable.getBoolean(key);
                                break block7;
                            }
                            case "Calendar": {
                                OffsetDateTime offsetDateTime = configurationTable.getOffsetDateTime(key);
                                if (offsetDateTime == null) break block7;
                                Date date = Date.from(offsetDateTime.toInstant());
                                Calendar calendar = Calendar.getInstance();
                                calendar.setTime(date);
                                value = calendar;
                                break block7;
                            }
                            case "Color": {
                                Pattern colorPattern;
                                Matcher m;
                                String colorString = configurationTable.getString(key);
                                if (colorString == null || !(m = (colorPattern = Pattern.compile("#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$")).matcher(colorString)).matches()) break block7;
                                value = new Color(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16));
                                break block7;
                            }
                            case "Double": {
                                value = configurationTable.getDouble(key);
                                break block7;
                            }
                            case "Integer": {
                                Long longValue = configurationTable.getLong(key);
                                if (longValue == null) break block7;
                                value = (int)longValue.longValue();
                                break block7;
                            }
                            case "String": {
                                value = configurationTable.getString(key);
                            }
                        }
                    }
                }
                if (value == null) continue;
                result.put(name, value);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, "Cannot load TOML configuration", ex);
            }
            catch (Exception ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, "Exception during loading TOML configuration", ex);
            }
        }
        Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.FINE, "TOML file loaded.");
        return result;
    }

    private static List<String> wordWrap(String text, int maxLineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() + 1 > maxLineLength) {
                lines.add(line.toString().trim());
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.toString().isEmpty()) {
            lines.add(line.toString().trim());
        }
        return lines;
    }

    private static String stringOfChar(char c, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static String comment(String comment) {
        return "# " + String.join((CharSequence)(System.lineSeparator() + "# "), TomlConfigurationStorage.wordWrap(comment, 78));
    }

    @Override
    public void saveToFile(String file) {
        this.saveToFile(file, null, null);
    }

    public void saveToFile(String file, Boolean showComments, Boolean modifiedOnly) {
        if (new File(file).exists() && (showComments == null || modifiedOnly == null)) {
            try {
                TomlParseResult tomlResult = Toml.parse((Path)Paths.get(file, new String[0]));
                TomlTable metaTable = tomlResult.getTable("meta");
                if (metaTable != null) {
                    if (showComments == null) {
                        showComments = metaTable.getBoolean("showComments") == Boolean.TRUE;
                    }
                    if (modifiedOnly == null) {
                        modifiedOnly = metaTable.getBoolean("modifiedOnly") == Boolean.TRUE;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.WARNING, "Cannot load showComments/modifiedOnly flags from previous TOML file", ex);
            }
        }
        if (showComments == null) {
            showComments = false;
        }
        if (modifiedOnly == null) {
            modifiedOnly = true;
        }
        try (PrintWriter pw = new PrintWriter(file, "UTF-8");){
            String header = AppResources.translate("configurationFile").replace("%app%", "JPEXS Free Flash Decompiler");
            String splitter = TomlConfigurationStorage.stringOfChar('-', header.length());
            pw.println("# " + splitter);
            pw.println("# " + header);
            pw.println("# " + splitter);
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.comment")));
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.modify")));
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.meta")));
            pw.println("[meta]");
            pw.println();
            Calendar generatedCalendarValue = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssXXX");
            sdf.setTimeZone(generatedCalendarValue.getTimeZone());
            String generatedValue = sdf.format(generatedCalendarValue.getTime());
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.meta.saveDate")));
            pw.println("saveDate = " + generatedValue);
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.meta.appVersion")));
            pw.println("appVersion = \"" + ApplicationInfo.version + "\"");
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.meta.showComments")));
            pw.println("showComments = " + (showComments != false ? "true" : "false") + "");
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.meta.modifiedOnly")));
            pw.println("modifiedOnly = " + (modifiedOnly != false ? "true" : "false") + "");
            pw.println();
            pw.println(TomlConfigurationStorage.comment(AppResources.translate("configurationFile.configuration")));
            pw.println("[configuration]");
            pw.println();
            for (Map.Entry<String, Field> entry : Configuration.getConfigurationFields(false, true).entrySet()) {
                try {
                    Class c;
                    String key;
                    String name = entry.getKey();
                    Field field = entry.getValue();
                    ConfigurationItem item = (ConfigurationItem)field.get(null);
                    ConfigurationName nameAnnotation = field.getAnnotation(ConfigurationName.class);
                    if (nameAnnotation != null) {
                        name = nameAnnotation.value();
                    }
                    if ((key = name).contains(".")) {
                        key = "\"" + key + "\"";
                    }
                    if (!item.hasValue && modifiedOnly.booleanValue()) continue;
                    String title = Configuration.getConfigurationTitle(name);
                    String description = Configuration.getConfigurationDescription(name);
                    if (showComments.booleanValue()) {
                        if (title != null && !title.isEmpty()) {
                            pw.println("# " + title.replace("\n", "\n# "));
                        }
                        if (description != null && !description.isEmpty()) {
                            List<String> descriptionLines = TomlConfigurationStorage.wordWrap(description, 76);
                            boolean first = true;
                            for (String descriptionLine : descriptionLines) {
                                pw.println("#" + (first ? " - " : "   ") + descriptionLine);
                                first = false;
                            }
                        }
                        pw.println("#");
                    }
                    Object value = item.get();
                    Object defaultValue = Configuration.getDefaultValue(field);
                    String savedValue = null;
                    String savedDefaultValue = null;
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    String valueType = null;
                    if (value == null) {
                        savedValue = "";
                    } else {
                        block10 : switch (name) {
                            case "fontPairingMap": {
                                HashMap fontPairingMap = (HashMap)value;
                                sb.append("{");
                                for (Object fontKey : fontPairingMap.keySet()) {
                                    if (!first) {
                                        sb.append(", ");
                                    }
                                    sb.append("\"");
                                    sb.append(Helper.escapeJavaString((String)fontKey));
                                    sb.append("\" = \"");
                                    sb.append(Helper.escapeJavaString((String)fontPairingMap.get(fontKey)));
                                    sb.append("\"");
                                    first = false;
                                }
                                sb.append("}");
                                break;
                            }
                            case "swfSpecificConfigs": {
                                Object fontKey;
                                HashMap swfSpecificConfigs = (HashMap)value;
                                sb.append("{");
                                fontKey = swfSpecificConfigs.keySet().iterator();
                                while (fontKey.hasNext()) {
                                    String swfKey = (String)fontKey.next();
                                    if (!first) {
                                        sb.append(", ");
                                    }
                                    sb.append("\"");
                                    sb.append(Helper.escapeJavaString(swfKey));
                                    sb.append("\" = {");
                                    SwfSpecificConfiguration swfSpecificConf = (SwfSpecificConfiguration)swfSpecificConfigs.get(swfKey);
                                    sb.append("fontPairingMap = {");
                                    boolean first2 = true;
                                    for (String string : swfSpecificConf.fontPairingMap.keySet()) {
                                        if (!first2) {
                                            sb.append(", ");
                                        }
                                        sb.append("\"");
                                        sb.append(Helper.escapeJavaString(string));
                                        sb.append("\" = \"");
                                        sb.append(Helper.escapeJavaString(swfSpecificConf.fontPairingMap.get(string)));
                                        sb.append("\"");
                                        first2 = false;
                                    }
                                    sb.append("}, lastSelectedPath = \"");
                                    if (swfSpecificConf.lastSelectedPath != null) {
                                        sb.append(Helper.escapeJavaString(swfSpecificConf.lastSelectedPath));
                                    }
                                    sb.append("\"");
                                    sb.append("}");
                                    first = false;
                                }
                                sb.append("}");
                                savedValue = sb.toString();
                                break;
                            }
                            case "swfSpecificCustomConfigs": {
                                HashMap swfSpecificCustomConfigs = (HashMap)value;
                                sb.append("{");
                                for (String swfKey : swfSpecificCustomConfigs.keySet()) {
                                    if (!first) {
                                        sb.append(", ");
                                    }
                                    sb.append("\"");
                                    sb.append(Helper.escapeJavaString(swfKey));
                                    sb.append("\" = {");
                                    SwfSpecificCustomConfiguration swfSpecificCustomConf = (SwfSpecificCustomConfiguration)swfSpecificCustomConfigs.get(swfKey);
                                    boolean first2 = true;
                                    for (String customKey : swfSpecificCustomConf.getAllCustomData().keySet()) {
                                        if (!first2) {
                                            sb.append(", ");
                                        }
                                        sb.append("\"");
                                        sb.append(Helper.escapeJavaString(customKey));
                                        sb.append("\" = \"");
                                        sb.append(Helper.escapeJavaString(swfSpecificCustomConf.getAllCustomData().get(customKey)));
                                        sb.append("\"");
                                        first2 = false;
                                    }
                                    sb.append("}");
                                    first = false;
                                }
                                sb.append("}");
                                savedValue = sb.toString();
                                break;
                            }
                            default: {
                                Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                                if (!(type instanceof Class)) break;
                                switch (((Class)type).getSimpleName()) {
                                    case "Boolean": {
                                        Boolean booleanValue = (Boolean)value;
                                        savedValue = booleanValue == Boolean.TRUE ? "true" : "false";
                                        savedDefaultValue = defaultValue == Boolean.TRUE ? "true" : "false";
                                        valueType = "Boolean";
                                        break block10;
                                    }
                                    case "Calendar": {
                                        Calendar calendar = (Calendar)value;
                                        sdf.setTimeZone(calendar.getTimeZone());
                                        savedValue = sdf.format(calendar.getTime());
                                        if (defaultValue != null) {
                                            savedDefaultValue = sdf.format(((Calendar)defaultValue).getTime());
                                        }
                                        valueType = "Calendar";
                                        break block10;
                                    }
                                    case "Color": {
                                        Color colorValue = (Color)value;
                                        savedValue = "\"" + new RGB(colorValue).toHexRGB() + "\"";
                                        if (defaultValue != null) {
                                            savedDefaultValue = "\"" + new RGB((Color)defaultValue).toHexRGB() + "\"";
                                        }
                                        valueType = "Color";
                                        break block10;
                                    }
                                    case "Double": {
                                        savedValue = "" + value;
                                        if (defaultValue != null) {
                                            savedDefaultValue = "" + defaultValue;
                                        }
                                        valueType = "Double";
                                        break block10;
                                    }
                                    case "Integer": {
                                        savedValue = "" + value;
                                        if (defaultValue != null) {
                                            savedDefaultValue = "" + defaultValue;
                                        }
                                        valueType = "Integer";
                                        break block10;
                                    }
                                    case "String": {
                                        String stringValue = value.toString();
                                        savedValue = stringValue.contains("\\") && !stringValue.matches("^.*[\b\t\n\f\r\"'\\x00-\\x08\\x1A-\\x1F\\x7F].*$") ? "'" + stringValue + "'" : "\"" + Helper.escapeJavaString(stringValue) + "\"";
                                        if (defaultValue != null) {
                                            stringValue = defaultValue.toString();
                                            savedDefaultValue = stringValue.contains("\\") && !stringValue.matches("^.*[\b\t\n\f\r\"'\\x00-\\x08\\x1A-\\x1F\\x7F].*$") ? "'" + stringValue + "'" : "\"" + Helper.escapeJavaString(stringValue) + "\"";
                                        }
                                        valueType = "String";
                                        break block10;
                                    }
                                }
                                String stringOtherValue = value.toString();
                                savedValue = "\"" + Helper.escapeJavaString(stringOtherValue) + "\"";
                                if (defaultValue == null) break;
                                savedDefaultValue = "\"" + Helper.escapeJavaString(defaultValue.toString()) + "\"";
                            }
                        }
                    }
                    if (showComments.booleanValue() && valueType != null) {
                        pw.println("#   " + AppResources.translate("valueType") + " " + AppResources.translate("valueType." + valueType));
                    }
                    Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    if (showComments.booleanValue() && type instanceof Class && (c = (Class)type).isEnum()) {
                        Class enumType = (Class)type;
                        Enum[] values = (Enum[])enumType.getEnumConstants();
                        sb = new StringBuilder();
                        first = true;
                        for (Enum enumValue : values) {
                            if (!first) {
                                sb.append(", ");
                            }
                            sb.append("\"");
                            sb.append(enumValue.toString());
                            sb.append("\"");
                            first = false;
                        }
                        pw.println("#   " + AppResources.translate("valueType") + " " + enumType.getSimpleName());
                        pw.println("#   " + AppResources.translate("possibleValues") + " " + sb.toString());
                    }
                    if (showComments.booleanValue() && savedDefaultValue != null) {
                        pw.println("#   " + AppResources.translate("defaultValue") + " " + savedDefaultValue);
                    }
                    ConfigurationRemoved removed = field.getAnnotation(ConfigurationRemoved.class);
                    if (showComments.booleanValue() && removed != null) {
                        pw.println("# " + AppResources.translate("configuration.removed"));
                    }
                    if (showComments.booleanValue()) {
                        pw.println();
                    }
                    if (!item.hasValue || savedValue == null || savedValue.isEmpty()) {
                        pw.print("# ");
                    }
                    pw.print(key + " = ");
                    if (item.hasValue) {
                        pw.println(savedValue);
                    } else {
                        pw.println(savedDefaultValue);
                    }
                    if (!showComments.booleanValue()) continue;
                    pw.println();
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, "Cannot get configuration field to save", ex);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.SEVERE, "Cannot write TOML configuration", ex);
        }
        catch (Exception ex) {
            Logger.getLogger(TomlConfigurationStorage.class.getName()).log(Level.SEVERE, "Exception during saving configuration", ex);
        }
    }
}

