/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.BlendModeSettable;
import com.jpexs.decompiler.flash.exporters.FontExporter;
import com.jpexs.decompiler.flash.exporters.FrameExporter;
import com.jpexs.decompiler.flash.exporters.GraphicsGroupable;
import com.jpexs.decompiler.flash.exporters.GraphicsTextDrawable;
import com.jpexs.decompiler.flash.exporters.RequiresNormalizedFonts;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.StaticTextTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.DynamicTextGlyphEntry;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import gnu.jpdf.PDFGraphics;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DualPdfGraphics2D
extends Graphics2D
implements BlendModeSettable,
GraphicsGroupable,
GraphicsTextDrawable,
RequiresNormalizedFonts {
    private final Graphics2D imageGraphics;
    private final PDFGraphics pdfGraphics;
    private final Map<Integer, Font> existingFonts;
    private Map<Integer, FontTag> normalizedFonts = new LinkedHashMap<Integer, FontTag>();
    private Map<Integer, TextTag> normalizedTexts = new LinkedHashMap<Integer, TextTag>();

    public DualPdfGraphics2D(Graphics2D first, PDFGraphics second, Map<Integer, Font> existingFonts) {
        this.imageGraphics = first;
        this.pdfGraphics = second;
        this.existingFonts = existingFonts;
    }

    @Override
    public void draw(Shape s) {
        this.imageGraphics.draw(s);
        this.pdfGraphics.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        boolean ok1 = this.imageGraphics.drawImage(img, xform, obs);
        boolean ok2 = this.pdfGraphics.drawImage(img, xform, obs);
        return ok1 && ok2;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.imageGraphics.drawImage(img, op, x, y);
        this.pdfGraphics.drawImage(img, op, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        boolean ok1 = this.imageGraphics.drawImage(img, x, y, observer);
        boolean ok2 = this.pdfGraphics.drawImage(img, x, y, observer);
        return ok1 && ok2;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        boolean ok1 = this.imageGraphics.drawImage(img, x, y, width, height, observer);
        boolean ok2 = this.pdfGraphics.drawImage(img, x, y, width, height, observer);
        return ok1 && ok2;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        boolean ok1 = this.imageGraphics.drawImage(img, x, y, bgcolor, observer);
        boolean ok2 = this.pdfGraphics.drawImage(img, x, y, bgcolor, observer);
        return ok1 && ok2;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        boolean ok1 = this.imageGraphics.drawImage(img, x, y, width, height, bgcolor, observer);
        boolean ok2 = this.pdfGraphics.drawImage(img, x, y, width, height, bgcolor, observer);
        return ok1 && ok2;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        boolean ok1 = this.imageGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        boolean ok2 = this.pdfGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        return ok1 && ok2;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        boolean ok1 = this.imageGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        boolean ok2 = this.pdfGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        return ok1 && ok2;
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.imageGraphics.drawRenderedImage(img, xform);
        this.pdfGraphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.imageGraphics.drawRenderableImage(img, xform);
        this.pdfGraphics.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.imageGraphics.drawString(str, x, y);
        this.pdfGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.imageGraphics.drawString(str, x, y);
        this.pdfGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.imageGraphics.drawString(iterator, x, y);
        this.pdfGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.imageGraphics.drawString(iterator, x, y);
        this.pdfGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.imageGraphics.drawGlyphVector(g, x, y);
        this.pdfGraphics.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.imageGraphics.fill(s);
        this.pdfGraphics.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        boolean ok1 = this.imageGraphics.hit(rect, s, onStroke);
        boolean ok2 = this.pdfGraphics.hit(rect, s, onStroke);
        return ok1 && ok2;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.imageGraphics.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.imageGraphics.setComposite(comp);
        this.pdfGraphics.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.imageGraphics.setPaint(paint);
        this.pdfGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.imageGraphics.setStroke(s);
        this.pdfGraphics.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.imageGraphics.setRenderingHint(hintKey, hintValue);
        this.pdfGraphics.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.imageGraphics.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.imageGraphics.setRenderingHints(hints);
        this.pdfGraphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.imageGraphics.addRenderingHints(hints);
        this.pdfGraphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.imageGraphics.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.imageGraphics.translate(x, y);
        this.pdfGraphics.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.imageGraphics.translate(tx, ty);
        this.pdfGraphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.imageGraphics.rotate(theta);
        this.pdfGraphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.imageGraphics.rotate(theta, x, y);
        this.pdfGraphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.imageGraphics.scale(sx, sy);
        this.pdfGraphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.imageGraphics.shear(shx, shy);
        this.pdfGraphics.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.imageGraphics.transform(Tx);
        this.pdfGraphics.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.imageGraphics.setTransform(Tx);
        this.pdfGraphics.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.pdfGraphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.imageGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.imageGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.imageGraphics.setBackground(color);
        this.pdfGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.imageGraphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.imageGraphics.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.imageGraphics.clip(s);
        this.pdfGraphics.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.imageGraphics.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public Color getColor() {
        return this.imageGraphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.imageGraphics.setColor(c);
        this.pdfGraphics.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.imageGraphics.setPaintMode();
        this.pdfGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.imageGraphics.setXORMode(c1);
        this.pdfGraphics.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.imageGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.imageGraphics.setFont(font);
        this.pdfGraphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.imageGraphics.getFontMetrics();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.imageGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.imageGraphics.clearRect(x, y, width, height);
        this.pdfGraphics.clipRect(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.pdfGraphics.getClip();
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.imageGraphics.setClip(x, y, width, height);
        this.pdfGraphics.setClip(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this.imageGraphics.setClip(clip);
        this.pdfGraphics.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.imageGraphics.copyArea(x, y, width, height, dx, dy);
        this.pdfGraphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.imageGraphics.drawLine(x1, y1, x2, y2);
        this.pdfGraphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.imageGraphics.fillRect(x, y, width, height);
        this.pdfGraphics.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.imageGraphics.clearRect(x, y, width, height);
        this.pdfGraphics.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.imageGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.pdfGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.imageGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.pdfGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.imageGraphics.drawOval(x, y, width, height);
        this.pdfGraphics.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.imageGraphics.fillOval(x, y, width, height);
        this.pdfGraphics.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.imageGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
        this.pdfGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.imageGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
        this.pdfGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.imageGraphics.drawPolyline(xPoints, yPoints, nPoints);
        this.pdfGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.imageGraphics.drawPolyline(xPoints, yPoints, nPoints);
        this.pdfGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.imageGraphics.fillPolygon(xPoints, yPoints, nPoints);
        this.pdfGraphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void dispose() {
        this.imageGraphics.dispose();
        this.pdfGraphics.dispose();
    }

    @Override
    public void setBlendMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 2: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 3: {
                this.pdfGraphics.setBlendMode("Multiply");
                break;
            }
            case 4: {
                this.pdfGraphics.setBlendMode("Screen");
                break;
            }
            case 5: {
                this.pdfGraphics.setBlendMode("Lighten");
                break;
            }
            case 6: {
                this.pdfGraphics.setBlendMode("Darken");
                break;
            }
            case 7: {
                this.pdfGraphics.setBlendMode("Difference");
                break;
            }
            case 8: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 9: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 10: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 11: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 12: {
                this.pdfGraphics.setBlendMode("Normal");
                break;
            }
            case 13: {
                this.pdfGraphics.setBlendMode("Overlay");
                break;
            }
            case 14: {
                this.pdfGraphics.setBlendMode("HardLight");
                break;
            }
            default: {
                this.pdfGraphics.setBlendMode("Normal");
            }
        }
    }

    @Override
    public Graphics createGroup() {
        return this.pdfGraphics.createXObject();
    }

    @Override
    public void drawGroup(Graphics g) {
        this.pdfGraphics.drawXObject(g);
    }

    @Override
    public void drawTextRecords(SWF swf, List<TEXTRECORD> textRecords, int numText, MATRIX textMatrixM, Matrix transformation, ColorTransform colorTransform) {
        Matrix textMatrix = new Matrix(textMatrixM);
        Matrix mat = transformation.clone();
        Matrix mat0 = mat.concatenate(textMatrix);
        Matrix trans = mat0.preConcatenate(Matrix.getScaleInstance(0.05));
        FontTag font = null;
        int fontId = -1;
        int textHeight = 12;
        int x = 0;
        int y = 0;
        int textColor = 0;
        for (TEXTRECORD rec : textRecords) {
            if (rec.styleFlagsHasColor) {
                textColor = numText > 1 ? rec.textColorA.toInt() : rec.textColor.toInt();
                if (colorTransform != null) {
                    textColor = colorTransform.apply(textColor);
                }
            }
            if (rec.styleFlagsHasFont) {
                font = rec.getFont(swf);
                fontId = swf.getCharacterId(font);
                if (this.normalizedFonts.containsKey(fontId)) {
                    font = this.normalizedFonts.get(fontId);
                }
                textHeight = rec.textHeight;
            }
            if (rec.styleFlagsHasXOffset) {
                int offsetX;
                x = offsetX = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                int offsetY;
                y = offsetY = rec.yOffset;
            }
            if (font == null) continue;
            StringBuilder text = new StringBuilder();
            int deltaX = 0;
            for (int i = 0; i < rec.glyphEntries.size(); ++i) {
                GLYPHENTRY nextEntry;
                GLYPHENTRY entry = rec.glyphEntries.get(i);
                GLYPHENTRY gLYPHENTRY = nextEntry = i < rec.glyphEntries.size() - 1 ? rec.glyphEntries.get(i + 1) : null;
                if (entry.glyphIndex != -1) {
                    Character currentChar = Character.valueOf(font.glyphToChar(entry.glyphIndex));
                    Character nextChar = nextEntry == null ? null : Character.valueOf(font.glyphToChar(nextEntry.glyphIndex));
                    int calcAdvance = StaticTextTag.getAdvance(font, entry.glyphIndex, textHeight, currentChar.charValue(), nextChar);
                    int spacing = entry.glyphAdvance - calcAdvance;
                    char ch = font.glyphToChar(entry.glyphIndex);
                    if (spacing != 0) {
                        text.append(currentChar);
                        DualPdfGraphics2D.drawText(swf, x, y, trans, textColor, this.existingFonts, fontId, font, text.toString(), textHeight, this.pdfGraphics);
                        text = new StringBuilder();
                        x = x + deltaX + entry.glyphAdvance;
                        deltaX = 0;
                        continue;
                    }
                    text.append(ch);
                    deltaX += entry.glyphAdvance;
                    continue;
                }
                if (!(entry instanceof DynamicTextGlyphEntry)) continue;
                DynamicTextGlyphEntry dynamicEntry = (DynamicTextGlyphEntry)entry;
                text.append(dynamicEntry.character);
                deltaX += entry.glyphAdvance;
            }
            if (text.length() > 0) {
                DualPdfGraphics2D.drawText(swf, x, y, trans, textColor, this.existingFonts, fontId, font, text.toString(), textHeight, this.pdfGraphics);
            }
            x += deltaX;
        }
    }

    private static void drawText(SWF swf, float x, float y, Matrix trans, int textColor, Map<Integer, Font> existingFonts, int fontId, FontTag font, String text, int textHeight, PDFGraphics g) {
        if (existingFonts.containsKey(fontId)) {
            g.setExistingTtfFont(existingFonts.get(fontId).deriveFont((float)textHeight));
        } else if (font.getCharacterCount() < 1) {
            String fontName = font.getFontName();
            File fontFile = FontTag.fontNameToFile(fontName);
            if (fontFile == null) {
                fontFile = FontTag.fontNameToFile("Times New Roman");
            }
            if (fontFile == null) {
                fontFile = FontTag.fontNameToFile("Arial");
            }
            if (fontFile == null) {
                throw new RuntimeException("Font " + fontName + " not found in your system");
            }
            Font f = new Font("/MYFONT" + fontId, font.getFontStyle(), textHeight);
            existingFonts.put(fontId, f);
            try {
                g.setTtfFont(f, fontFile);
            }
            catch (IOException ex) {
                Logger.getLogger(FrameExporter.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            FontExporter fe = new FontExporter();
            File tempFile = null;
            try {
                tempFile = File.createTempFile("ffdec_font_export_", ".ttf");
                fe.exportFont(font, FontExportMode.TTF, tempFile);
                Font f = new Font("/MYFONT" + fontId, font.getFontStyle(), textHeight);
                existingFonts.put(fontId, f);
                g.setTtfFont(f, tempFile);
            }
            catch (IOException ex) {
                Logger.getLogger(FrameExporter.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
        g.setTransform(trans.toTransform());
        Color textColor2 = new Color(textColor, true);
        g.setColor(textColor2);
        text = text.replaceAll("\\p{Cc}", " ");
        g.drawString(text, x, y);
    }

    @Override
    public void setNormalizedFonts(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts) {
        this.normalizedFonts = normalizedFonts;
        this.normalizedTexts = normalizedTexts;
    }

    @Override
    public Map<Integer, FontTag> getNormalizedFonts() {
        return this.normalizedFonts;
    }

    @Override
    public Map<Integer, TextTag> getNormalizedTexts() {
        return this.normalizedTexts;
    }
}

