/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.tools.conversion.woff.WoffWriter;
import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.exporters.settings.FontExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.PathExporter;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import fontastic.FGlyph;
import fontastic.FPoint;
import fontastic.Fontastic;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FontExporter {
    public List<File> exportFonts(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, FontExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof FontTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof FontTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("font", currentIndex, count, t.getName());
            }
            FontTag st = (FontTag)t;
            String ext = ".ttf";
            if (settings.mode == FontExportMode.WOFF) {
                ext = ".woff";
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(st.getCharacterExportFileName() + ext));
            new RetryTask(() -> this.exportFont(st, settings.mode, file), handler).run();
            LinkedHashSet<String> classNames = st.getClassNames();
            if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue() && !classNames.isEmpty()) {
                for (String className : classNames) {
                    if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue()) {
                        className = DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), st.getSwf(), true);
                    }
                    File classFile = new File(outdir + File.separator + Helper.makeFileName(className + ext));
                    new RetryTask(() -> Files.copy(file.toPath(), classFile.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    ret.add(classFile);
                }
                file.delete();
            } else {
                ret.add(file);
            }
            if (CancellableWorker.isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("font", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }

    public byte[] exportFont(FontTag t, FontExportMode mode) {
        try {
            String ext = null;
            switch (mode) {
                case TTF: {
                    ext = ".ttf";
                    break;
                }
                case WOFF: {
                    ext = ".woff";
                }
            }
            File f = File.createTempFile("temp", ext);
            this.exportFont(t, mode, f);
            return Helper.readFile(f.getPath());
        }
        catch (IOException ex) {
            Logger.getLogger(FontExporter.class.getName()).log(Level.SEVERE, null, ex);
            return SWFInputStream.BYTE_ARRAY_EMPTY;
        }
    }

    public void exportFont(FontTag ft, FontExportMode mode, File file) throws IOException {
        int descent;
        String fontName;
        FontTag t = ft.toClassicFont();
        List<SHAPE> shapes = t.getGlyphShapeTable();
        final double divider = t.getDivider();
        File ttfFile = file;
        if (mode == FontExportMode.WOFF) {
            ttfFile = File.createTempFile("ffdec_export", ".ttf");
        }
        if ((fontName = Helper.makeFileName(t.getFontNameIntag())).length() == 0) {
            fontName = "noname";
        }
        Fontastic f = new Fontastic(fontName, ttfFile);
        String cop = t.getCopyright();
        f.getEngine().setCopyrightYear(cop == null ? "" : cop);
        if (Configuration.setFFDecVersionInExportedFont.get().booleanValue()) {
            f.setAuthor(ApplicationInfo.shortApplicationVerName);
        } else {
            f.setAuthor("FFDec");
        }
        f.setVersion("1.0");
        SWF swf = t.getSwf();
        if (swf != null) {
            Date date = swf.getFileModificationDate();
            f.setCreationDate(date);
            f.setModificationDate(date);
        }
        f.setDefaultMetrics();
        int ascent = t.getAscent();
        if (ascent != -1) {
            float value = Math.round((double)ascent / divider);
            value = Math.min(value, 1024.0f);
            f.setAscender(value);
        }
        if ((descent = t.getDescent()) != -1) {
            float value = Math.round((double)descent / divider);
            value = Math.min(value, 1024.0f);
            f.setDescender(value);
        }
        ArrayList<Integer> reallyExportedGlyphs = new ArrayList<Integer>();
        HashSet<Character> processedCharacters = new HashSet<Character>();
        for (int i = shapes.size() - 1; i >= 0; --i) {
            char c = t.glyphToChar(i);
            if (processedCharacters.contains(Character.valueOf(c))) continue;
            reallyExportedGlyphs.add(0, i);
            processedCharacters.add(Character.valueOf(c));
        }
        int glyphCount = 0;
        for (Integer ii : reallyExportedGlyphs) {
            int i = ii;
            char c = t.glyphToChar(i);
            SHAPE s = shapes.get(i);
            final ArrayList contours = new ArrayList();
            PathExporter seb = new PathExporter(this, 0, 1, swf, s, null){
                List<FPoint> path;
                final /* synthetic */ FontExporter this$0;
                {
                    this.this$0 = this$0;
                    super(windingRule, shapeNum, swf, shape, colorTransform);
                    this.path = new ArrayList<FPoint>();
                }

                private double transformX(double x) {
                    return Math.ceil(x / divider);
                }

                private double transformY(double y) {
                    return -Math.ceil(y / divider);
                }

                @Override
                protected void finalizePath() {
                    FPoint[] points = this.path.toArray(new FPoint[this.path.size()]);
                    if (points.length > 0) {
                        contours.add(points);
                    }
                    this.path.clear();
                }

                @Override
                public void moveTo(double x, double y) {
                    this.finalizePath();
                    this.path.add(new FPoint(this.transformX(x), this.transformY(y)));
                }

                @Override
                public void lineTo(double x, double y) {
                    this.path.add(new FPoint(this.transformX(x), this.transformY(y)));
                }

                @Override
                public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
                    this.path.add(new FPoint(new FPoint(this.transformX(anchorX), this.transformY(anchorY)), new FPoint(this.transformX(controlX), this.transformY(controlY))));
                }
            };
            seb.export();
            FGlyph g = f.addGlyph(c);
            ++glyphCount;
            double adv = t.getGlyphAdvance(i);
            if (adv != -1.0) {
                g.setAdvanceWidth((int)Math.round(adv / divider));
            } else {
                g.setAdvanceWidth((int)Math.round((double)t.getGlyphWidth(i) / divider + 100.0));
            }
            for (FPoint[] cnt : contours) {
                if (cnt.length == 0) continue;
                g.addContour(cnt);
            }
        }
        if (glyphCount == 0) {
            return;
        }
        f.buildFont();
        if (mode == FontExportMode.WOFF) {
            byte[] fontBytes;
            FontFactory fontFactory = FontFactory.getInstance();
            try (FileInputStream fis = new FileInputStream(ttfFile);){
                fontBytes = new byte[(int)ttfFile.length()];
                fis.read(fontBytes);
            }
            Font[] fontArray = null;
            fontArray = fontFactory.loadFonts(fontBytes);
            Font font = fontArray[0];
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                WoffWriter w = new WoffWriter();
                WritableFontData woffData = w.convert(font);
                woffData.copyTo((OutputStream)fos);
            }
            ttfFile.delete();
        }
    }
}

