/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.MorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ShapeExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ImageResizer;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import dev.matrixlab.webp4j.WebPCodec;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShapeExporter {
    public List<File> exportShapes(AbortRetryIgnoreHandler handler, String outdir, SWF swf, ReadOnlyTagList tags, ShapeExportSettings settings, EventListener evl, double unzoom, int aaScale) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Object t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ShapeTag st = (ShapeTag)t;
            if (evl != null) {
                evl.handleExportingEvent("shape", currentIndex, count, t.getName());
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(st.getCharacterExportFileName() + settings.getFileExtension()));
            new RetryTask(() -> {
                Matrix m = Matrix.getScaleInstance(settings.zoom);
                RECT rect = st.getRect();
                m.translate(-rect.Xmin, -rect.Ymin);
                switch (settings.mode) {
                    case SVG: {
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                            ExportRectangle rect2 = new ExportRectangle(st.getRect());
                            rect2.xMax *= settings.zoom;
                            rect2.yMax *= settings.zoom;
                            rect2.xMin *= settings.zoom;
                            rect2.yMin *= settings.zoom;
                            SVGExporter exporter = new SVGExporter(rect2, settings.zoom, "shape");
                            st.toSVG(0, 0, exporter, -2, new CXFORMWITHALPHA(), 0, m, m);
                            ((OutputStream)fos).write(Utf8Helper.getBytes(exporter.getSVG()));
                            break;
                        }
                    }
                    case PNG: 
                    case BMP: 
                    case WEBP: {
                        RGB backColor;
                        int realAaScale = Configuration.calculateRealAaScale(rect.getWidth(), rect.getHeight(), settings.zoom, aaScale);
                        int newWidth = (int)((double)rect.getWidth() * settings.zoom * (double)realAaScale / 20.0) + 1;
                        int newHeight = (int)((double)rect.getHeight() * settings.zoom * (double)realAaScale / 20.0) + 1;
                        SerializableImage img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                        img.fillTransparent();
                        if (settings.mode == ShapeExportMode.BMP && (backColor = swf.getBackgroundColor().backgroundColor) != null) {
                            Graphics2D g = (Graphics2D)img.getGraphics();
                            g.setColor(backColor.toColor());
                            g.fillRect(0, 0, img.getWidth(), img.getHeight());
                        }
                        Matrix m2 = Matrix.getScaleInstance(settings.zoom * (double)realAaScale);
                        m2.translate(-rect.Xmin, -rect.Ymin);
                        st.toImage(0, 0, 0, new RenderContext(), img, img, false, m2, m2, m2, m2, new CXFORMWITHALPHA(), unzoom * (double)realAaScale, false, new ExportRectangle(rect), new ExportRectangle(rect), true, 0, 0, true, realAaScale);
                        BufferedImage bim = img.getBufferedImage();
                        if (realAaScale > 1) {
                            bim = ImageResizer.resizeImage(bim, (newWidth - 1) / realAaScale + 1, (newHeight - 1) / realAaScale + 1, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
                        }
                        if (settings.mode == ShapeExportMode.PNG) {
                            ImageHelper.write(bim, ImageFormat.PNG, file);
                            break;
                        }
                        if (settings.mode == ShapeExportMode.WEBP) {
                            try (FileOutputStream fos = new FileOutputStream(file);){
                                fos.write(WebPCodec.encodeLosslessImage((BufferedImage)bim));
                                break;
                            }
                        }
                        BMPFile.saveBitmap(bim, file);
                        break;
                    }
                    case CANVAS: {
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                            SHAPEWITHSTYLE shp = st.getShapes();
                            int deltaX = -((SHAPE)shp).getBounds((int)1).Xmin;
                            int deltaY = -((SHAPE)shp).getBounds((int)1).Ymin;
                            CanvasShapeExporter cse = new CanvasShapeExporter(st.getWindingRule(), st.getShapeNum(), null, 20.0 / settings.zoom, st.getSwf(), shp, new CXFORMWITHALPHA(), deltaX, deltaY);
                            cse.export();
                            HashSet<Integer> needed = new HashSet<Integer>();
                            HashSet<String> neededClasses = new HashSet<String>();
                            needed.add(st.getCharacterId());
                            st.getNeededCharactersDeep(needed, neededClasses);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            baos.write(Utf8Helper.getBytes("var scalingGrids = {};\r\nvar boundRects = {};\r\n"));
                            SWF.libraryToHtmlCanvas(st.getSwf(), needed, baos);
                            ((OutputStream)fos).write(Utf8Helper.getBytes(cse.getHtml(new String(baos.toByteArray(), Utf8Helper.charset), SWF.getTypePrefix(st) + st.getCharacterId(), st.getRect())));
                            break;
                        }
                    }
                    case SWF: {
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                            try {
                                new PreviewExporter().exportSwf(fos, st, null, 0, false, null);
                            }
                            catch (ActionParseException ex) {
                                Logger.getLogger(MorphShapeExporter.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break;
                        }
                    }
                }
            }, handler).run();
            LinkedHashSet<String> classNames = st.getClassNames();
            if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue() && !classNames.isEmpty()) {
                for (String className : classNames) {
                    if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue()) {
                        className = DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), st.getSwf(), true);
                    }
                    File classFile = new File(outdir + File.separator + Helper.makeFileName(className + settings.getFileExtension()));
                    new RetryTask(() -> Files.copy(file.toPath(), classFile.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    ret.add(classFile);
                }
                file.delete();
            } else {
                ret.add(file);
            }
            if (CancellableWorker.isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("shape", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        if (settings.mode == ShapeExportMode.CANVAS) {
            File fcanvas = new File(foutdir + File.separator + "canvas.js");
            Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
            ret.add(fcanvas);
        }
        return ret;
    }
}

