/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.exporters.settings.SymbolClassExportSettings;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.utf8.Utf8OutputStreamWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SymbolClassExporter {
    public static final String SYMBOL_CLASS_EXPORT_FILENAME = "symbols.csv";

    public List<File> exportNames(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, SymbolClassExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof ExportAssetsTag) && !(t instanceof SymbolClassTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        File file = new File(outdir + File.separator + SYMBOL_CLASS_EXPORT_FILENAME);
        new RetryTask(() -> {
            try (BufferedWriter writer = new BufferedWriter(new Utf8OutputStreamWriter(new FileOutputStream(file)));){
                for (Tag t : tags) {
                    int i;
                    if (t instanceof ExportAssetsTag) {
                        ExportAssetsTag eat = (ExportAssetsTag)t;
                        for (i = 0; i < eat.tags.size(); ++i) {
                            writer.append(eat.tags.get(i) + ";\"" + Helper.escapePCodeString(eat.names.get(i)).replace("\"", "\"\"") + "\"" + Helper.newLine);
                        }
                    } else if (t instanceof SymbolClassTag) {
                        SymbolClassTag sct = (SymbolClassTag)t;
                        for (i = 0; i < sct.tags.size(); ++i) {
                            writer.append(sct.tags.get(i) + ";\"" + Helper.escapePCodeString(sct.names.get(i)).replace("\"", "\"\"") + "\"" + Helper.newLine);
                        }
                    }
                    if (!CancellableWorker.isInterrupted()) continue;
                    break;
                }
            }
        }, handler).run();
        ret.add(file);
        return ret;
    }
}

